/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.util.Vector;

public class Menu
extends MenuItem
implements MenuContainer {
    private static final long serialVersionUID = -8809584163345499784L;
    Vector items = new Vector(5);
    boolean isTearOff;

    public synchronized MenuItem add(MenuItem menuItem) {
        if (menuItem.getLabel().equals("-")) {
            menuItem = MenuItem.separator;
        }
        this.insert(menuItem, -1);
        return menuItem;
    }

    public void add(String string) {
        if (string.equals("-")) {
            this.addSeparator();
        } else {
            this.insert(string, -1);
        }
    }

    void addAll(Menu menu) {
        int n = menu.items.size();
        int n2 = 0;
        while (n2 < n) {
            this.add((MenuItem)menu.items.elementAt(n2));
            ++n2;
        }
    }

    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            super.addNotify();
            int n = this.items.size();
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = (MenuItem)this.items.elementAt(n2);
                menuItem.parent = this;
                menuItem.owner = this.owner;
                menuItem.addNotify();
                ++n2;
            }
        }
    }

    public void addSeparator() {
        this.insertSeparator(-1);
    }

    Vector addShortcuts(Vector vector) {
        int n = this.items.size();
        super.addShortcuts(vector);
        int n2 = 0;
        while (n2 < n) {
            ((MenuItem)this.items.elementAt(n2)).addShortcuts(vector);
            ++n2;
        }
        return vector;
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        try {
            return (MenuItem)this.items.elementAt(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.items.size();
        MenuItem menuItem = super.getShortcutMenuItem(menuShortcut);
        if (menuItem != null) {
            return menuItem;
        }
        int n2 = 0;
        while (n2 < n) {
            menuItem = ((MenuItem)this.items.elementAt(n2)).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void insert(MenuItem menuItem, int n) {
        try {
            this.items.insertElementAt(menuItem, n > -1 ? n : this.items.size());
            menuItem.parent = this;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void insertSeparator(int n) {
        this.insert(MenuItem.separator, n);
    }

    public boolean isTearOff() {
        return this.isTearOff;
    }

    public String paramString() {
        return super.paramString();
    }

    protected void propagateOldEvents(boolean bl) {
        super.propagateOldEvents(bl);
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            MenuItem menuItem = this.getItem(n);
            menuItem.propagateOldEvents(bl);
            --n;
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        try {
            this.items.removeElement(menuComponent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void remove(int n) {
        try {
            this.items.removeElementAt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeAll() {
        try {
            this.items.removeAllElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeNotify() {
        if ((this.flags & 0x400) > 0) {
            int n = this.items.size();
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = (MenuItem)this.items.elementAt(n2);
                menuItem.removeNotify();
                ++n2;
            }
            super.removeNotify();
        }
    }

    public Menu() {
        this(null, false);
    }

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.isTearOff = bl;
    }
}

