/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class EditMan
implements ActionListener,
ClipboardOwner {
    private TextEdit textEdit;
    private TextCanvas textCanvas;
    private String undoString = new String("Undo");
    private String redoString = new String("Redo");
    private String copyString = new String("Copy");
    private String cutString = new String("Cut");
    private String pasteString = new String("Paste");
    private String findString = new String("Find");
    private String replaceString = new String("Replace");
    private MenuItem undoItem;
    private MenuItem redoItem;
    private MenuItem copyItem;
    private MenuItem cutItem;
    private Clipboard clipboard;
    private FindDialog findDialog;
    private String findPattern;
    private ReplaceDialog replaceDialog;
    private String ReplacePattern;
    private String ReplaceReplace;

    public EditMan(TextEdit textEdit) {
        this.textEdit = textEdit;
        this.textCanvas = this.textEdit.getCanvas();
        this.clipboard = this.textEdit.getToolkit().getSystemClipboard();
    }

    public void addItems(Menu menu) {
        this.undoItem = new MenuItem(this.undoString, new MenuShortcut(90, false));
        this.undoItem.setActionCommand(this.undoString);
        this.undoItem.setEnabled(false);
        menu.add(this.undoItem);
        this.redoItem = new MenuItem(this.redoString, new MenuShortcut(89, false));
        this.redoItem.setActionCommand(this.redoString);
        this.redoItem.setEnabled(false);
        menu.add(this.redoItem);
        menu.addSeparator();
        this.copyItem = new MenuItem(this.copyString, new MenuShortcut(67, false));
        this.copyItem.setActionCommand(this.copyString);
        this.copyItem.setEnabled(false);
        menu.add(this.copyItem);
        this.cutItem = new MenuItem(this.cutString, new MenuShortcut(88, false));
        this.cutItem.setActionCommand(this.cutString);
        this.cutItem.setEnabled(false);
        menu.add(this.cutItem);
        MenuItem menuItem = new MenuItem(this.pasteString, new MenuShortcut(86, false));
        menuItem.setActionCommand(this.pasteString);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new MenuItem(this.findString, new MenuShortcut(70, false));
        menuItem.setActionCommand(this.findString);
        menu.add(menuItem);
        menuItem = new MenuItem(this.replaceString, new MenuShortcut(72, false));
        menuItem.setActionCommand(this.replaceString);
        menu.add(menuItem);
        menu.addActionListener(this);
        this.textCanvas.setEditMan(this);
    }

    public void updateCopyItems(boolean bl) {
        this.copyItem.setEnabled(bl);
        this.cutItem.setEnabled(bl);
    }

    public void updateUndoItems(boolean bl, boolean bl2) {
        this.undoItem.setEnabled(bl);
        this.redoItem.setEnabled(bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals(this.undoString)) {
            this.textCanvas.undo(true);
        }
        if (string.equals(this.redoString)) {
            this.textCanvas.undo(false);
            return;
        }
        if (string.equals(this.copyString)) {
            String string2 = this.textCanvas.copy(false);
            if (string2 != null) {
                StringSelection stringSelection = new StringSelection(string2);
                this.clipboard.setContents(stringSelection, this);
                return;
            }
        } else if (string.equals(this.cutString)) {
            String string3 = this.textCanvas.copy(true);
            if (string3 != null) {
                StringSelection stringSelection = new StringSelection(string3);
                this.clipboard.setContents(stringSelection, this);
                return;
            }
        } else if (string.equals(this.pasteString)) {
            Transferable transferable = this.clipboard.getContents(this);
            if (transferable != null) {
                String string4;
                try {
                    string4 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    System.out.println("Could not read clipboard");
                    return;
                }
                this.textCanvas.paste(string4);
                return;
            }
        } else {
            if (string.equals(this.findString)) {
                if (this.findDialog == null) {
                    this.findDialog = new FindDialog(this.textEdit, this, this.findPattern);
                }
                this.findDialog.show();
                return;
            }
            if (string.equals(this.replaceString)) {
                if (this.replaceDialog == null) {
                    this.replaceDialog = new ReplaceDialog(this.textEdit, this, this.ReplacePattern, this.ReplaceReplace);
                }
                this.replaceDialog.show();
            }
        }
    }

    public void CloseFindDialog(String string) {
        this.findDialog = null;
        this.findPattern = new String(string);
    }

    public void CloseReplaceDialog(String string, String string2) {
        this.replaceDialog = null;
        this.ReplacePattern = new String(string);
        this.ReplaceReplace = new String(string2);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

