/**
 * @file lex.h
 * @author Joe Wingbermuehle
 * @date 2004-2006
 *
 * @brief XML lexer header file.
 *
 */

#ifndef LEX_H
#define LEX_H

/** Tokens.
 * Note that any change made to this typedef must be reflected in
 * TOKEN_MAP in lex.c.
 */
typedef enum {

	TOK_INVALID,

	TOK_ACTIVEBACKGROUND,
	TOK_ACTIVEFOREGROUND,
	TOK_BACKGROUND,
	TOK_BORDERSTYLE,
	TOK_CLASS,
	TOK_CLOCK,
	TOK_CLOCKSTYLE,
	TOK_CLOSE,
	TOK_DESKTOPS,
	TOK_DOCK,
	TOK_DOUBLECLICKSPEED,
	TOK_DOUBLECLICKDELTA,
	TOK_EXIT,
	TOK_FOCUSMODEL,
	TOK_FONT,
	TOK_FOREGROUND,
	TOK_GROUP,
	TOK_HEIGHT,
	TOK_ICONPATH,
	TOK_INCLUDE,
	TOK_JWM,
	TOK_KEY,
	TOK_KILL,
	TOK_LAYER,
	TOK_MAXIMIZE,
	TOK_MENU,
	TOK_MENUSTYLE,
	TOK_MINIMIZE,
	TOK_MOUSE,
	TOK_MOVE,
	TOK_MOVEMODE,
	TOK_NAME,
	TOK_OPTION,
	TOK_OUTLINE,
	TOK_PAGER,
	TOK_PAGERSTYLE,
	TOK_POPUP,
	TOK_POPUPSTYLE,
	TOK_PROGRAM,
	TOK_RESIZE,
	TOK_RESIZEMODE,
	TOK_RESTART,
	TOK_RESTARTCOMMAND,
	TOK_ROOTMENU,
	TOK_SENDTO,
	TOK_SEPARATOR,
	TOK_SHADE,
	TOK_SHUTDOWNCOMMAND,
	TOK_SNAPMODE,
	TOK_STARTUPCOMMAND,
	TOK_STICK,
	TOK_SWALLOW,
	TOK_TASKLISTSTYLE,
	TOK_TASKLIST,
	TOK_THEME,
	TOK_THEMEPATH,
	TOK_TRAY,
	TOK_TRAYBUTTON,
	TOK_TRAYBUTTONSTYLE,
	TOK_TRAYSTYLE,
	TOK_WIDTH

} TokenType;

/** Structure to represent an XML attribute. */
typedef struct AttributeNode {

	char *name;                  /**< The name of the attribute. */
	char *value;                 /**< The value for the attribute. */
	struct AttributeNode *next;  /**< The next attribute in the list. */

} AttributeNode;

/** Structure to represent an XML tag. */
typedef struct TokenNode {

	TokenType type;
	char *invalidName;
	char *value;
	char *fileName;
	int line;
	struct AttributeNode *attributes;
	struct TokenNode *parent;
	struct TokenNode *subnodeHead, *subnodeTail;
	struct TokenNode *next;

} TokenNode;

TokenNode *Tokenize(const char *line, const char *fileName);

const char *GetTokenName(const TokenNode *tp);
const char *GetTokenTypeName(TokenType type);

#endif

