#include "sys.h"

#include <fcntl.h>

#ifdef USE_SGTTY
#include <sgtty.h>
#endif

#ifdef USE_TERMIO
/*#include <sys/termio.h>*/
#include <termio.h>
#endif

#ifdef USE_TERMIOS
/*#include <sys/termios.h>*/
#include <termios.h>
#endif

#ifdef hpux
#include <sys/file.h>
#define	TIOCNOTTY	O_NOCTTY
#endif

Onew_notty()
{	int fd;

#ifdef TIOCNOTTY
	if( 0 <= (fd = open("/dev/tty",0)) ){
		ioctl(fd,TIOCNOTTY,0);
		close(fd);
	}
#endif
}



#ifdef USE_SGTTY
Onew_ttyIcanon(on)
{	int fd;
	struct sgttyb buf;

	fd = open("/dev/tty", O_RDWR);
	ioctl(fd, TIOCGETP, &buf);
	if( on )
		buf.sg_flags |= ECHO, buf.sg_flags &= ~CBREAK;
	else	buf.sg_flags &= ~ECHO, buf.sg_flags |= CBREAK;
	ioctl(fd, TIOCSETN, &buf);
	close(fd);
}
#endif


#ifdef USE_TERMIO
Onew_ttyIcanon(on)
{	int fd;
	struct termio buf;

	fd = open("/dev/tty", O_RDWR);
	ioctl(fd, TCGETA, &buf);
	if( on )
		buf.c_lflag |= (ECHO|ICANON);
	else	buf.c_lflag &= ~(ECHO|ICANON);
	ioctl(fd, TCSETAW, &buf);
	set_cbreak(fd,!on);
	close(fd);
}
#endif

#ifdef USE_TERMIOS
Onew_ttyIcanon(on)
{	int fd;
	struct termios buf;

	fd = open("/dev/tty", O_RDWR);
	tcgetattr(fd, &buf);
	if( on )
		buf.c_lflag |= (ECHO|ICANON);
	else	buf.c_lflag &= ~(ECHO|ICANON);
	tcsetattr(fd, TCSADRAIN, &buf);
	set_cbreak(fd,!on);
	close(fd);
}
#endif

