#include <stdio.h>
#include "sys.h"

#if   defined(hpux) \
   || defined(solaris) \
   || defined(nec_ews) \
   || defined(_nec_ews_svr4) \
   || defined(__sgi) \
   || defined(__linux__) \
   || defined(_bufsiz)

#include <termio.h>

set_cbreak(fd,on)
{       struct termio termio;

        ioctl(fd,TCGETA,&termio);
	if( on ){
		termio.c_cc[VMIN]  = 1;
		termio.c_cc[VTIME] = 0;
		termio.c_lflag &= ~ICANON;
	}else{
		termio.c_cc[VMIN]  = 0;
		termio.c_cc[VTIME] = ('D'-0x40);
		termio.c_lflag |=  ICANON;
	}
	/* tcdrain(fd);*/
        ioctl(fd,TCSETA,&termio);
}

set_noflsh(fd,on){
	struct termio termio;

	ioctl(fd, TCGETA, &termio);
	if(on)	termio.c_lflag |=  NOFLSH;
	else	termio.c_lflag &= ~NOFLSH;
	ioctl(fd, TCSETA, &termio);
}

#else
static int dummy;
#endif
