#include "sys.h"

#include <errno.h>
extern int errno;

#ifdef HAS_SELECT	/* normally 4.xBSD is the case */
#include <sys/time.h>
Onew_fd_input_ready( fd, wait_usec )
{	struct timeval tv;
	int mask,nready;

	if( wait_usec ){
		tv.tv_sec  = wait_usec / 1000000;
		tv.tv_usec = wait_usec % 1000000;
	}
	mask = 1 << fd;

	nready = select(32, &mask,0,0, wait_usec ? &tv : 0);
	if( nready < 0 ){
		if( errno != EINTR ){
			Onew_message(" ERROR! select(%d,0x%x) TIMEOUT=%dusec",
				fd,mask,wait_usec);
		}
		return -1; /* SELECT INTERRUPTED */
	}
	return mask ? 1 : 0;
}
#endif

#ifdef HAS_POLL		/* normally SVR[34] is the case */
/*
 * by Jun Ohta
 */
#include <poll.h>
Onew_fd_input_ready( fd, wait_usec )
{	struct pollfd pfd;
	int nready;

	pfd.fd = fd;
	pfd.events = POLLIN;
	nready = poll(&pfd, 1L, wait_usec? (wait_usec / 1000): -1);
	if( nready < 0 ){
		Onew_message(" ERROR! poll(%d) TIMEOUT=%dusec",pfd,wait_usec);
		return -1; /* POLL INTERRUPTED */
	}
	return (pfd.revents == POLLIN)? 1: 0;
}
#endif

Onew_readycc(fp)
	FILE *fp;
{
	return READYCC(fp);
}
