/*
 *	REGULAR EXPRESSION
 */
#include "sys.h"

#if defined(nec_ews) \
 || defined(_nec_ews_svr4) \
 || defined(AUX3)

#if !defined(AUX3)
# include <libgen.h>
#endif

static char *REXP;
re_comp(rexp)
	char *rexp;
{
	if( REXP )
		free(REXP);
	REXP = regcmp(rexp, 0);
	return 0;
}

re_exec(pattern)
	char *pattern;
{
	if( REXP == 0 )
		return 0;

	if( regex(REXP, pattern, 0) == 0 )
		return 0;
	else	return 1;
}

#else
#if defined(hpux) \
 || defined(bsdi) \
 || defined(__FreeBSD__)

#ifdef bsdi
#include <stdio.h>
#include <sys/types.h>
#endif
#include <regex.h>

static regex_t REXP;
re_comp(s)
	char *s;
{
	if( *(int*)&REXP != 0 )
		regfree(&REXP);
	regcomp(&REXP, s, REG_NOSUB);
	return 0;
}
re_exec(s)
	char *s;
{
	if(s == 0) return 0;
	return regexec(&REXP,s,(size_t)0,NULL,0) == 0;
}

#else
#if defined(solaris)

#define MAXEXPBUF	128

static char expbuf[MAXEXPBUF];
static char *ptn;

#define INIT
#define GETC()     (*ptn++)
#define PEEKC()    (*ptn)
#define UNGETC(c)  (--ptn)
#define RETURN(c)  return;
#define ERROR(c)   return;
#include <regexp.h>

re_comp(s)
	char *s;
{
	ptn = s;
	compile(s, expbuf, &expbuf[MAXEXPBUF], '\0');
	return 0;
}
re_exec(s)
	char *s;
{
	if(s == 0) return 0;
	return step(s, expbuf);
}

#else
static int dummy;
#endif
#endif
#endif
