/*
 *	termcap interface
 *	Onew_tgetstr(), Onew_tgetnum(), Onew_tputs()
 */
#include <stdio.h>

static char tcapbuf[1024];
static tcap_init(force){
	static int init;
	char *term;

	if( init && !force )
		return init;
	term = (char*)getenv("TERM");
	if( term == 0 )
		return init = -1;
	if( tgetent(tcapbuf,term) == 0 )
		return init = -2;
	return init = 1;
}

char *
Onew_tgetstr(cap,tstr)
	char *cap,*tstr;
{	char *p;

	if( tcap_init(0) < 0 )
		return 0;
	p = tstr;
	return (char*)tgetstr(cap,&p);
}
Onew_tgetnum(cap)
	char *cap;
{
	if( tcap_init(0) < 0 )
		return 0;
	return tgetnum(cap);
}
Tgetnum(cap)
	char *cap;
{
	return Onew_tgetnum(cap);
}

static PUTC(ch)
{
	putchar(ch);
}
static char *TCAP(cap)
	char *cap;
{	static char tstr[128];

	if( Onew_tgetstr(cap,tstr) == 0 )
		sprintf(tstr,"<%s>",cap);
	return tstr;
}
Onew_tputs(cap,fp)
	char *cap;
	FILE *fp;
{
	tputs(TCAP(cap),1,PUTC);
}
