/*
 *	MESSAGE OUTPUT TO APPLICATION USER INTERFACE
 */
char *Onew_RK_smode();
char *romkan_help();

typedef char Linebuff[1024];
typedef char Mssgbuff[1024];

static Linebuff LASTMSG;
static Linebuff LASTMODE;
static Linebuff LASTHELP;
static int LASTMODEF;

extern int ONEW_modedepth;
static int ONEW_msg_overw;
static int ONEW_msg_retain;

Onew_putmode(mode,help)
	char *mode,*help;
{	int modeflags,xmodef;
	char xmode[128];
	char xhelp[512];

	if( ONEW_msg_retain ){
		ONEW_msg_retain = 0;
		ONEW_msg_overw = 1;
		return;
	}
	modeflags = Onew_modef(&mode,xmode,&help,xhelp);

	xmodef = modeflags | (ONEW_msg_overw ? (1<<23):0);
	ONEW_msg_overw = 0;

	ouiDISP_ROMKANMODE(mode,help,xmodef);

	if( strcmp(LASTMODE,mode) != 0 ){
/*	if( modeflags != LASTMODEF ){ */

		LASTMODEF = modeflags;
		strcpy(LASTMODE,mode);
		strcpy(LASTHELP,help);

		/* clear the mirror of status line since the real status
		 * message will be rewrote on the status change.
		 */
		LASTMSG[0] = 0;
	}
}

Onew_putmsg_sys(so,fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	ONEW_msg_overw = 1;
	Onew_putmsg(so,fmt,a,b,c,d,e,f,g);
}
Onew_putmsg_retain(so,fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{
	ONEW_msg_retain = 1;
	Onew_putmsg(so,fmt,a,b,c,d,e,f,g);
}

Onew_putmodef(mode,fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char help[1024];

	sprintf(help,fmt,a,b,c,d,e,f,g);
	Onew_putmode(mode,help);
}

static Linebuff PUSHEDMODE;
static Linebuff PUSHEDHELP;
Onew_pushmode(mode)
	char *mode;
{
	ONEW_modedepth++;
	strcpy(PUSHEDMODE,LASTMODE);
	strcpy(PUSHEDHELP,LASTHELP);
	Onew_putmode(mode,"");
}
Onew_popmode()
{
	ONEW_modedepth--;
	Onew_putmode(PUSHEDMODE,PUSHEDHELP);
}

Onew_curmsg(msg)
	char *msg;
{
	strcpy(LASTMSG,msg);
}
Onew_putmsg(so,F,a,b,c,d,e,f,g)
	char *F;
	char *a,*b,*c,*d,*e,*f,*g;
{	Mssgbuff tmsg,msg;
	char *mp;
	int maxcol = ouiMESSAGE_COLS();

	sprintf(tmsg,F,a,b,c,d,e,f,g);

/*	sprintf(msg,"%s%*s",so?" ":"",-maxcol,tmsg); */
	sprintf(msg,"%*s",-maxcol,tmsg);

	msg[maxcol-1] = 0;
	for(mp = msg; *mp; ){
		if( *mp & 0x80 ){
			if(mp[1] == 0 ){
				*mp = 0;
				break;
			}else	mp += 2;
		}else	mp++;
	}

	if( strcmp(LASTMSG,msg) )
	{
		ouiMESSAGE(so,"%s",msg);
		strcpy(LASTMSG,msg);
	}
}
