/************************************************************************
 *	interface for application user interface functions		*
 ************************************************************************/

#include <stdio.h>
char *getenv();

static FILE *ouiFp;
static int uin;
static int uilev;
ouiTrace(prim,fmt,a,b,c,d,e,f,g)
	char *fmt;
	FILE *prim;
{	char *logf;

	if( ouiFp == NULL ){
		if( logf = getenv("ONEW_UIFLOG") )
			ouiFp = fopen(logf,"w");
		if( ouiFp == NULL )
			ouiFp = (FILE*)-1;
	}
	if( ouiFp == (FILE*)-1 )
		return;
	fprintf(ouiFp,"%4d ",++uin);
	fprintf(ouiFp,"%-16s ",prim);
	if(fmt) fprintf(ouiFp,fmt,a,b,c,d,e,f,g);
	fprintf(ouiFp,"\n");
}
Onew_ouiTrace(prim,fmt,a,b,c,d,e,f,g){ ouiTrace(prim,fmt,a,b,c,d,e,f,g); }

ouiGETCHAR()
{	int ch;

	ouiTrace("GETCHAR",0);
	ch = ONEW_GETCHAR();
	ouiTrace("GETCHAR","(%x)",ch);
	/*if( ch == '\n' ) LASTMSG[0] = 0;*/
	return ch;
}
ouiPEEKCHAR(msecp)
	int *msecp;
{	int ch;

	ouiTrace("PEEKCHAR",0);
	ch = ONEW_PEEKCHAR(msecp);
	if( 0 < ch )
		ouiTrace("PEEKCHAR","(%x)",ch);
	return ch;
}
ouiGOT_2BCHAR(buf,hi,lo)
	char *buf;
{
	ouiTrace("GOT_2BCHAR",0);
	return ONEW_GOT_2BCHAR(buf,hi,lo);
}
ouiDISP_ROMKANMODE(mode,help,modeflags)
	char *mode,*help;
{
	ouiTrace("DISP_ROMKANMODE","%-6s[%04x]",mode,modeflags);
	return ONEW_DISP_ROMKANMODE(mode,help,modeflags);
}
ouiDISP_KANAHALVES(str)
	char *str;
{
	ouiTrace("DISP_KANAHALVES","(%s)",str);
	return ONEW_DISP_KANAHALVES(str);
}
ouiKANAKAN(kkchar)
{
	ouiTrace("KANAKAN","%x",kkchar);
	return ONEW_KANAKAN(kkchar);
}
ouiDISP_KANAKANB(so,left,cur,right)
	char *left,*cur,*right;
{
	ouiTrace("DISP_KANAKANB","%d",so);
	return ONEW_DISP_KANAKANB(so,left,cur,right);
}
ouiKAKUTEI(kakutei_start_char)
{
	ouiTrace("KAKUTEI","%x",kakutei_start_char);
	return ONEW_KAKUTEI(kakutei_start_char);
}
/*
 *	ONEW_KAKUTEI: returns true if the character is consumed for kakutei
 */

ouiBEEP(waitsec)
{
	ouiTrace("BEEP",0);
	return ONEW_BEEP(waitsec);
}
ouiMESSAGE_COLS()
{	int cols;

	cols = ONEW_MESSAGE_COLS();
	ouiTrace("MESSAGE_COLS","%d",cols);
	return cols;
}
ouiMESSAGE(so,fmt,a,b,c,d,e,f,g)
	char *fmt;
	char *a,*b,*c,*d,*e,*f,*g;
{	char msg[512];

	sprintf(msg,fmt,a,b,c,d,e,f,g);
	ouiTrace("MESSAGE","<%s>",msg);
	return ONEW_MESSAGE(so,fmt,a,b,c,d,e,f,g);
}


/*
 *
 */
Onew_disp_kanahalf(ch)
{	char buf[128];

	buf[0] = ch;
	buf[1] = 0;
	Onew_disp_kanahalves(buf);
}
Onew_disp_kanahalves(str)
	char *str;
{
	if( *str == 0 )
		ouiDISP_KANAHALVES(" ");
	else	ouiDISP_KANAHALVES(str);
}
