/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	931104	extracted from onewlib.c
///////////////////////////////////////////////////////////////////////*/
int RomkanExists;

#include <stdio.h>
#include WNN_RKSPCL
#include "onew.h"

extern char *ONEW_KEISEN_ON;
extern int   ONEW_kanamode;
extern int   ONEW_getch1();

/*
 *	MODE SWITCH CODE FOR romkan/Wnn
 */
#define S_KATAKANA	0x81
#define S_ZENKAKU	0x82
#define S_NOTKANA	0x83
#define S_KEISEN_A	0x85	/* by M.Kawafuji */
#define S_KEISEN_B	0x86	/* by M.Kawafuji */

/*/////////////////////////////////////////////////////////////////////*/
static ONEWromkan_getc(){
	return romkan_getc();
}
static ONEWromkan_next(){
	return romkan_next();
}
static ONEWromkan_clear(){
	return romkan_clear();
}

static int RkInitDone;
static ONEWromkan_modesw();

static ONEWromkan_ready(rkdir)
	char *rkdir;
{	int ri;
	Pathname rkbuf;
	char *rk;
	int rkfd;

	if( RkInitDone == 0 ){
		if((rkfd = Onew_searchPath(rkbuf,"",WNN_RKPATH)) < 0)
		if( Onew_extract_rktabs() )
		if((rkfd = Onew_searchPath(rkbuf,"",WNN_RKPATH)) < 0)
			;

		if( 0 <= rkfd ){
			close(rkfd);
			rk = rkbuf;
		}else	rk = 0;
		
		if( rk ){
			if( romkan_init(rk,Cntl('H'),1,ONEW_getch1,0) != 0 )
				rk = 0;
#ifndef ORIGINAL				/* Junn Ohta; 9/4/1991 */
#ifndef RK_SIMPLD				/* defined in rk_spclval.h */
#define RK_SIMPLD 040
#endif
			{
			extern int flags;	/* defined in rk_vars.c */
			flags |= RK_SIMPLD;	/* disable excellent delete */
			}
#endif
		}
		if( rk == 0 ){
			RkInitDone = -1;
			Onew_putmsg(1,"%s %s","ONEW_WNN_ROMKAND",
				ONEW_msg_missingromkan);
			ONEW_BEEP(4);
		}else{
			RkInitDone = 1;
			ONEWromkan_modesw(0);

			if( rkdir )
				strcpy(rkdir,rk);
		}
	}
	return RkInitDone;
}

static char *ONEWromkan_dispmode()
{
	return (char*)romkan_dispmode();
}

static char pending[16];
static int  pendx;
static ONEWromkan_gotch(kc){

	switch( kc ){
		case 0: break;
		case Cntl('\\'):
		case CHMSIG:
			kc = 0;
			break;

		case LTREOF:
			kc = EOF;
			break;

		case NISEBP:
			kc = 0;
			Onew_disp_kanahalf(' ');
			romkan_clear();
			break;

		default:
		if(kc & 0x80000000){
/*
if(romkanmode_ch()==RK_HIRA)
if( 'A' <= ch && ch <= 'Y' )
if( katakana_toggle() ){
romkan_clear();
enq_keyinQ(ch-('A'-'a'));
}
*/

			if( (kc & 0x7F) == Cntl('H') ){
Onew_disp_kanahalf(' ');
/* 940123:
This call seems unnecessary, moreover harmful for compatibility with Canna...*/
/* 940209:
seems NECESSARY to cancel the didplayed KANAHALF..., what's harmful? */

			}else{
				Onew_disp_kanahalf(kc&0x7F);
			}
			kc = 0;
		}
	}
	return kc;
}

static ONEWromkan_modesw(modei){
	int oldmode;
	int mode_diff;
	int ch;

	if( ONEWromkan_ready(0) <= 0 )
		return ONEW_kanamode;
	if( modei == ONEW_kanamode )
		return ONEW_kanamode;

	oldmode = ONEW_kanamode;
	mode_diff = modei ^ ONEW_kanamode;
	if(mode_diff&KF_KEISEN_B) ins_keyinQ(S_KEISEN_B),romkan_getc();
	if(mode_diff&KF_KEISEN_A) ins_keyinQ(S_KEISEN_A),romkan_getc();
	if(mode_diff&    ZENKAKU) ins_keyinQ( S_ZENKAKU),romkan_getc();
	if(mode_diff&    NOTKANA) ins_keyinQ( S_NOTKANA),romkan_getc();
	if(mode_diff&   KATAKANA) ins_keyinQ(S_KATAKANA),romkan_getc();
	ONEW_kanamode = modei;
	return oldmode;
}

RegisterRomkan(ONEW_WnnRomkan);
