/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	Canna.c (onew/Canna interface)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	931104	created
	931127	jrKanjiControl() for initialization with .canna
	931213	RkGetHinshi+RkDeleteDic
///////////////////////////////////////////////////////////////////////*/
int KanakanExists;

#include <canna/RK.h>
#include <canna/jrkanji.h>
#include "onew.h"
#include "Canna_euc.h"

#define BS	'\b'
/*/////////////////////////////////////////////////////////////////////*/

static int ready;
static int CID;
static int nbunsetsu;
int ONEW_CannarcDone;

static ONEWkanakan_ready()
{	char path[1024];
	char dics[1024];
	char *dp;
	int ndics,di,rc;
	char *chost,chostb[1024];

	if( ready )
		return 0 < ready;

	if( (chost = getenv("CANNAHOST")) == 0 ){
		gethostname(chostb,sizeof(chostb));
		chost = chostb;
	}
	onew_notify_kkinit("%s ** CANNAHOST(%s)",Onew_version(),chost);

	if( !ONEW_CannarcDone ){
		jrKanjiControl(0,KC_INITIALIZE,0);
		ONEW_CannarcDone = 1;
	}
	CID = jrKanjiControl(0,KC_GETCONTEXT,0);

	/*if( CID < 0 ){
		sprintf(path,"");

		if( RkInitialize(path) < 0 ){
			printf("Failed: RkInitialize\n");
			return ready = -1;
		}
		CID = RkCreateContext();
	}*/
	/*if( NO DICTIONARY WAS MOUNTED WITH .canna ){
		ndics = RkGetDicList(CID, dics, sizeof(dics));
		dp = dics;
		for(di = 0; di < ndics; di++){
			rc = RkMountDic(CID,dp,0);
			dp += strlen(dp)+1;
		}
	}*/
	return ready = 1;
}
static ONEWkanakan_freqsave()
{
}

static char *
ONEWkanakan_kouho(cid,i,kouho,len)
	char *kouho;
{
	kouho[0] = 0;
	RkXfer(CID,i);
	RkGetKanji(CID,kouho,len);
	return kouho;
}

static char OC_CurrentHinshi[32];
static char OC_CurrentHid;

static ONEWkanakan(startch, yomi)
	char *yomi;
{	RkStat rkstat;
	char kanji[1024];
	int bunsetsux,altx,candn;
	int xfers;
	int comch;
	int rcode;
	char yomibuf[1024];
	static disp_kanji_buf();

	Onew_setupYomistr(startch,yomi,yomibuf);
	yomi = yomibuf;

	xfers = 0;
	xfers = (xfers << RK_XFERBITS) | RK_XFER;
	xfers = (xfers << RK_XFERBITS) | RK_KFER;
	xfers = (xfers << RK_XFERBITS) | RK_ZFER;
	/*xfers = (xfers << RK_XFERBITS) | RK_HFER;*/
	nbunsetsu = RkBgnBun(CID,yomi,strlen(yomi),xfers);

	RkGetStat(CID,&rkstat);

	for(;;){
		if( nbunsetsu <= 0 ){
			Onew_putmsg(1,"Canna: nbunsetsu=%d",nbunsetsu);
			ONEW_BEEP(1);
			return DEL_CH;
		}

		RkGetStat(CID,&rkstat);
		bunsetsux = rkstat.bunnum;
		candn = rkstat.maxcand;
		altx = rkstat.candnum;

		for(;;){
			OC_CurrentHid = RkGetHinshi(CID,
				OC_CurrentHinshi,sizeof(OC_CurrentHinshi));

			onew_put_kanakanmode();
			disp_kanji_buf(1);
			comch = OnewGetchar();
			rcode = Onew_kanakancom(CID,comch,&bunsetsux,nbunsetsu,
					ONEWkanakan_kouho,&altx,candn,0);

			switch( rcode ){
				case ONEW_CONT: break;
				case ONEW_LOOP: goto Loop;
				case ONEW_EXIT: goto Exit;
			}

			RkGetStat(CID,&rkstat);
			if( altx < 0 )
				altx = rkstat.maxcand - 1;
			if( rkstat.maxcand <= altx )
				altx = 0;

			altx = RkXfer(CID,altx);
		} Loop:;
	}
Exit:	disp_kanji_buf(0);
	if( comch != ESC_CH && comch != DEL_CH && comch != BS )
		RkEndBun(CID,1);
	else	RkEndBun(CID,0);

	return comch;
}
static ONEWbunsetu_next(cid,cur,inc)
{
	if( cur == -1 ){
		cur = RkGoTo(CID,0);
	}else
	if( inc < 0 )
		cur = RkLeft(CID);
	else	cur = RkRight(CID);
	return cur;
}
static ONEWbunsetu_expand(cid)
{
	nbunsetsu = RkEnlarge(CID);
}
static ONEWbunsetu_shrink(cid)
{
	nbunsetsu = RkShorten(CID);
}
static ONEWexternal_henkan()
{
}

static disp_kanji_buf(so)
{	char kanji[1024];
	char left[1024],cur[1024],right[1024];
	int curbi,bi;
	RkStat rkstat;

	if( nbunsetsu <= 0 )
		return;

	left[0] = cur[0] = right[0] = 0;
	RkGetStat(CID,&rkstat);

	if( so )
		curbi = rkstat.bunnum;
	else	curbi = 0x10000; /* don't separate */

	for( bi = 0; bi < nbunsetsu; bi++ ){
		RkGoTo(CID,bi);
		RkGetKanji(CID,kanji,sizeof(kanji));

		if( bi <  curbi ){ strcat(left, kanji); }else
		if( bi == curbi ){ strcat(cur,  kanji); }else
		if( bi >  curbi ){ strcat(right,kanji); }
	}
	RkGoTo(CID,rkstat.bunnum);
	Onew_dispKanakanBuf(so,left,cur,right);
}
static ONEWbunsetu_delete(){
}

static ONEWjisyo_touroku(touroku,hinshi,yomi,kanji)
	char *hinshi,*yomi,*kanji;
{	char wordrec[4096];
	char *dicname = "user";
	int rcode;

	if( touroku ){
		sprintf(wordrec,"%s %s %s",yomi,hinshi,kanji);
		if( rcode = RkDefineDic(CID,dicname,wordrec) ){
			Onew_putmsg(1,"(%s) %s",dicname,ONEW_msg_tourokuERROR);
			ONEW_BEEP(2);
		}else{
			Onew_putmsg(1,"%s",ONEW_msg_tourokuOK);
		}
	}else{
		sprintf(wordrec,"%s %s %s",yomi,OC_CurrentHinshi,kanji);
		if( rcode = RkDeleteDic(CID,dicname,wordrec) ){
			Onew_putmsg(1,"REMOVE(%s){%s}=%d",
				dicname,wordrec,rcode);
			ONEW_BEEP(2);
		}else{
			Onew_putmsg(1,"%s (%s) %s",ONEW_msg_massyouOK,
				dicname,wordrec);
		}
	}
	return rcode;
}
static ONEWjisyo_hinshi(hinship)
	Hinshi **hinship;
{
	*hinship = CANNA_HINSHI;
	return 1;
}

RegisterKanakan(ONEW_CannaKanakan);
