#include "onew.h"
/*
 *	KEISEN_MODE with Wnn/Romkan
 *	By M. Kawafuji
 */
int KEISEN_TOGGLE_A	= Cntl('N');
int KEISEN_TOGGLE_B	= Cntl('B');

static
keisen_toggle(type)
int  type;
{
	if( in_kana_mode() ){
		if (type == KEISEN_TOGGLE_A) {
			ONEW_kanamode &= (ZENKAKU | KF_KEISEN_A);
			Onew_RK_imode_set( ONEW_kanamode ^ KF_KEISEN_A);
			return 1;
		}
		else if (type == KEISEN_TOGGLE_B) {
			ONEW_kanamode &= (ZENKAKU | KF_KEISEN_B);
			Onew_RK_imode_set( ONEW_kanamode ^ KF_KEISEN_B);
			return 1;
		}
		return 0;
	}
	return 0;
}


static char *ONEW_KEISEN_ON;
#define IS_KEISEN_TOGGLE(ch) \
	(ONEW_KEISEN_ON && (ch==KEISEN_TOGGLE_A || ch==KEISEN_TOGGLE_B))

static keisen_toggle_sw(ch)
{
	if( IS_KEISEN_TOGGLE(ch) ){
		keisen_toggle(ch);
		return 1;
	}
	return 0;
}
keisen_init(){
	ONEW_KEISEN_ON = getenv("ONEW_KEISENMODE");
	if( ONEW_KEISEN_ON == 0 )
		return;
	Onew_defineKanamode(ZENKAKU|KF_KEISEN_A,KEISEN_TOGGLE_A,keisen_toggle);
	Onew_defineKanamode(ZENKAKU|KF_KEISEN_B,KEISEN_TOGGLE_B,keisen_toggle);
}
