#include "onew.h"

/*
 *	GET A JIS CODE
 */

#define KU_SIZE 0x60

static Uchar *nth_jiscode(arg,n,code)
	Uchar *code;
{
	n++;
	code[0] = 0xA1 + n / 0x60;
	code[1] = 0xA0 + n % 0x60;
	code[2] = 0;

	/* the first and the last char in the KU */
	if( n % KU_SIZE == 0 || n % KU_SIZE == 0x5F )
		return 0;
	else	return code;
}
static ku_label(label,from,to,max)
	char *label;
{	Uchar code[3];
	int hi,lo;

	nth_jiscode(0,from,code);
	hi = code[0];
	lo = code[1];
	sprintf(label,"[%02d%02d]",hi-0xA0,lo-0xA0);
}
static ku_error(com){
	ouiBEEP(0);
	Onew_putmsg(1,"%s",ONEW_menu_jiscode);
	OnewGetchar();
}

OM_get_jisspecial(code)
	Uchar *code;
{	int n;
	static int curtop = 0;

	int NCODES = 0x60*84 - 16*4; /*84th-KU fragment*/
	
	Onew_putmode(ONEW_mode_kuten,"");
/*
	select_mode = 1;
*/
	n = Onew_list_sentaku(ku_label,ku_error,
		nth_jiscode,0,NCODES,KU_SIZE,&curtop);
	if( 0 < n ){
		if( nth_jiscode(0,n,code) == 0 ){
			code[0] = code[1] = 0xA1;
			code[2] = 0;
		}
	}
/*
	select_mode = 0;
*/
	return n;
}
