#include <stdio.h>
#include <ctype.h>
#include "onew.h"

/*
 *	INPUT CODE HANDLER (external code to internal code translation)
 *	problem: how to treat 2B input in "command" mode ...??
 */
int ONEW_INCHAR_WIDTH = 1;
int ONEW_INCHAR_NTH = 0;
int ONEW_ESC_TIMEOUT = 300;

static int chQb[32];
static int chQx;
static pushQ(ch)
{
	chQb[chQx++] = ch;
}
static popQ()
{
	if( chQx <= 0 )
		return EOF;
	return chQb[--chQx];
}
static PEEKCHAR(msecp,msec)
	int *msecp;
{
	if( 0 < chQx )
		return chQb[chQx-1];
	*msecp = msec;
	return ouiPEEKCHAR(msecp);
}
static GETCHAR(){
	int ch;
	static int N0,N1;

	if( ONEW_DEBUG ){
		fprintf(stderr,"\n\r[%d] ONEW_GETCHAR(): watining... ",++N0);
		fflush(stderr);
	}

	if( (ch = popQ()) == EOF )
		ch = ouiGETCHAR();

	if( ONEW_DEBUG ){
		alarm(0);
		fprintf(stderr,"\n\r[%d] got: %x",++N1,ch);
		fflush(stderr);
		sleep(1);
	}
	return ch;
}

static input_ready(){
	int msec;
	PEEKCHAR(&msec,1);
	/*return 0 <= msec;*/
	return 0 < msec;
}
OnewPeekchar(timeout){
	int msec,ch;
	ch = PEEKCHAR(&msec,timeout);
	if( msec < 0 )
		ch = EOF;
	return ch;
}

int ONEW_THRU_MODE;

OnewGetchar(){
	int ch,nch,nnch;
	int rmsec;

	ch = GETCHAR();

	if( ONEW_THRU_MODE )
		return ch;

	if( (ch & 0x80) && iscntrl(ch & 0x7F) && ch != EOF )
		/* maybe it is a control code of application and it
		 * should be passed transparently (or it's SJIS? X-<) */
	{
		if( ONEW_INCHAR_NTH == 0 ){
			pushQ(ch);
			/* ONEW_INCHAR_NTH = 1; ? */
			return ONEW_I_THRU_NEXTCH;
		}else{
			ONEW_INCHAR_NTH = 0;
			return ch;
		}
	}

	if( ONEW_IN_ISO2022 ){
	    if( ch == ESC_CH ){
		nch = PEEKCHAR(&rmsec,ONEW_ESC_TIMEOUT);
		if( rmsec < 0 ){
			;/* TIMEOUT */
		}else
		if( nch == '$' || nch == '(' ){
			GETCHAR(); /* flush '$','(' */
			nnch = PEEKCHAR(&rmsec,ONEW_ESC_TIMEOUT);
			if( rmsec < 0 || strchr("@BJ",nnch) == 0 ){
				pushQ(nch);
				return ESC_CH;
			}else{
				GETCHAR();
				if( nch == '$' ){
					ONEW_INCHAR_NTH = 0;
					ONEW_INCHAR_WIDTH = 2;
					Onew_putmode(ONEW_mode_2Bchar,0);
				}else{
					ONEW_INCHAR_WIDTH = 1;
					Onew_putmode(0,0);
				}
				return OnewGetchar();
			}
		}
	    }
	    if( ONEW_INCHAR_WIDTH == 2 ){
		if( 0x20 < ch && ch < 0x7F ){
			ch |= 0x80;
			if( 1 < ++ONEW_INCHAR_NTH )
				ONEW_INCHAR_NTH = 0;
		}else{
			ONEW_INCHAR_WIDTH = 1;
			Onew_putmode(0,0);
			if( ONEW_INCHAR_NTH != 0 )
				ch = 0xA1; /* padding */
		}
	    }
	}
	return ch;
}

OM_get_thruchar( real_thru )
{	int omode;
	int kc;

	if( !ready_keyinQ() )
		Onew_disp_kanahalf('^');

	ONEW_THRU_MODE = 1;
	omode = Onew_RK_imode_set(0);
		if( real_thru ){
			enq_keyinQ(ONEW_I_SYNC_CHAR);
			Onew_asis_romkan_next();
			Onew_putmode(romkan_cmode(),ONEW_menu_thru1);
		}
	kc = Onew_asis_romkan_next();
	Onew_RK_imode_set(omode);
	ONEW_THRU_MODE = 0;
	return kc;
}

OnewThruGetchar()
{	int kc;

	ONEW_THRU_MODE = 1;
	kc = OnewGetchar();
	ONEW_THRU_MODE = 0;
	return kc;
}
