/* vi:ts=4:sw=4
 *
 * VIM - Vi IMitation Kanji version.
 *
 * Code Contributions By:	Atsushi Nakamura	ann@mrit.mei.co.jp
 */

/*
 * jp.h: definition of global variables for kanji
 *
 */

#ifdef JP
# define	JP_READ	*p_jp		/* file/key in code */
# define	JP_DISP	*(p_jp + 1)	/* terminal display code */
# define	JP_NEW	*(p_jp + 2)	/* write code for new file */
# define	JP_FCODE	*p_jc	/* write code for the current file */
# define	JP_EUC	'E'			/* EUC */
# define	JP_JIS	'J'			/* JIS */
# define	JP_NJIS	'N'			/* NewJIS */
# define	JP_SJIS	'S'			/* Shift-JIS */
# define	JP_ANY	'.'			/* automatic (for input: EUC) */
# define	JP_SANY	','			/* automatic (for input: SJIS) */
# define	JP_NONE	'X'			/* nothing (=E) */
# define 	JP_STR	"EJNS.,X"	/*	Shift-JIS is not checked yet. */
# define	IsKanji(c)	((c) & 0x80)	/* is Kanji-character */

#define JPC_ALNUM	3
#define JPC_HIRA	4
#define JPC_KATA	5
#define JPC_KIGOU	6
#define JPC_KANJI	7

#define JP1_ALNUM	'#'
#define JP1_HIRA	'$'
#define JP1_KATA	'%'
#define JP1_KIGOU	'!'

#define JPM_UPS 	0x80 /* Uppercase symbols */
#define JPM_LOS		0x40 /* Lowercase symbols */
#define JPM_PMS		0x20 /* Punctuation marks in symbols */
#define JPM_PMK		0x10 /* Punctuation marks in Kata/Hira-kana */
#define JPM_SPS		0x08 /* Space Kanji */
#define JPM_KJS		0x04 /* Kanji Symbols */
#define JPM_HRS		0x02 /* Hiragana Symbols */
#define JPM_KTS		0x01 /* Katakana Symbols */

#endif

#ifdef JPFEP
# define JP_ASCII	TRUE
# define JP_KANJI	FALSE
#endif

/*
 * param.h: definition of global variables for settable parameters
 *
 * EXTERN is only defined in main.c (and vim.h)
 */

#ifndef EXTERN
# define EXTERN extern
#endif

/*
 * The following are external functions
 */

EXTERN void		kanjito();

EXTERN char	*kanjiin();
EXTERN char	*kanjiout();

EXTERN int	kanjiconvsfrom();
EXTERN char	*kanjiconvsto();

EXTERN char	*guess_jiauto();
EXTERN void	kanji_align();
EXTERN int	jpcls();

