/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.retroweaver.runtime.java.lang.Class_;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enum<E extends Enum<E>>
implements Comparable<E>,
Serializable {
    private static final long serialVersionUID = -1689726118486609581L;
    private final transient int ordinal_;
    private final String name_;
    private static final Map<Class, Object[]> enumValues = new HashMap<Class, Object[]>();
    private static final /* synthetic */ Class class$net$sourceforge$retroweaver$runtime$java$lang$Enum;

    protected Enum(String name, int ordinal) {
        this.name_ = name;
        this.ordinal_ = ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void setEnumValues(Object[] values, Class c) {
        Map<Class, Object[]> map = enumValues;
        synchronized (map) {
            enumValues.put(c, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final <T> T[] getEnumValues(Class<T> class_) {
        Map<Class, Object[]> map = enumValues;
        synchronized (map) {
            Object[] values = enumValues.get(class_);
            if (values != null) {
                return values;
            }
        }
        if (!Class_.isEnum(class_)) {
            return null;
        }
        try {
            Class.forName(class_.getName(), true, class_.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        map = enumValues;
        synchronized (map) {
            return enumValues.get(class_);
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        Class<E> clazz = this.getDeclaringClass();
        try {
            return Enum.valueOf(clazz, this.name_);
        }
        catch (IllegalArgumentException iae) {
            InvalidObjectException ioe = new InvalidObjectException(new StringBuffer().append(this.name_).append(" is not a valid enum for ").append(clazz.getName()).toString());
            try {
                ioe.initCause(iae);
            }
            catch (NoSuchMethodError nsm) {
                // empty catch block
            }
            throw ioe;
        }
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        if (enumType == null) {
            throw new NullPointerException("enumType is null");
        }
        if (name == null) {
            throw new NullPointerException("name_ is null");
        }
        Enum[] enums = (Enum[])Enum.getEnumValues(enumType);
        if (enums != null) {
            for (Enum enum_ : enums) {
                if (!enum_.name_.equals(name)) continue;
                return (T)enum_;
            }
        }
        throw new IllegalArgumentException(new StringBuffer().append("No enum const ").append(enumType).append(".").append(name).toString());
    }

    public final boolean equals(Object other) {
        return other == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.name_;
    }

    @Override
    public final int compareTo(E e) {
        Class<E> c2;
        Class<E> c1 = this.getDeclaringClass();
        if (c1 == (c2 = ((Enum)e).getDeclaringClass())) {
            return this.ordinal_ - ((Enum)e).ordinal_;
        }
        throw new ClassCastException();
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final String name() {
        return this.name_;
    }

    public final int ordinal() {
        return this.ordinal_;
    }

    public final Class<E> getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> superClass = clazz.getSuperclass();
        Class<?> clazz2 = class$net$sourceforge$retroweaver$runtime$java$lang$Enum;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$retroweaver$runtime$java$lang$Enum = new Enum[0].getClass().getComponentType();
        }
        if (superClass == clazz2) {
            return clazz;
        }
        return superClass;
    }
}

