/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.optimizer;

import java.io.Serializable;
import java.util.Comparator;
import net.sourceforge.retroweaver.optimizer.Constant;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantComparator
implements Comparator<Constant>,
Serializable {
    @Override
    public int compare(Constant c1, Constant c2) {
        int d = this.getSort(c1) - this.getSort(c2);
        if (d == 0) {
            switch (c1.type) {
                case 'I': {
                    return new Integer(c1.intVal).compareTo(new Integer(c2.intVal));
                }
                case 'J': {
                    return new Long(c1.longVal).compareTo(new Long(c2.longVal));
                }
                case 'F': {
                    return new Float(c1.floatVal).compareTo(new Float(c2.floatVal));
                }
                case 'D': {
                    return new Double(c1.doubleVal).compareTo(new Double(c2.doubleVal));
                }
                case 'C': 
                case 'S': 
                case 's': {
                    return c1.strVal1.compareTo(c2.strVal1);
                }
                case 'T': {
                    d = c1.strVal1.compareTo(c2.strVal1);
                    if (d != 0) break;
                    d = c1.strVal2.compareTo(c2.strVal2);
                    break;
                }
                default: {
                    d = c1.strVal1.compareTo(c2.strVal1);
                    if (d != 0 || (d = c1.strVal2.compareTo(c2.strVal2)) != 0) break;
                    d = c1.strVal3.compareTo(c2.strVal3);
                }
            }
        }
        return d;
    }

    private int getSort(Constant c) {
        switch (c.type) {
            case 'I': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            case 's': {
                return 4;
            }
            case 'S': {
                return 5;
            }
            case 'C': {
                return 6;
            }
            case 'T': {
                return 7;
            }
            case 'G': {
                return 8;
            }
            case 'M': {
                return 9;
            }
        }
        return 10;
    }
}

