/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.Parser;
import org.jvyamlb.Scanner;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.DocumentEndEvent;
import org.jvyamlb.events.DocumentStartEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.exceptions.ParserException;
import org.jvyamlb.tokens.AliasToken;
import org.jvyamlb.tokens.AnchorToken;
import org.jvyamlb.tokens.BlockEndToken;
import org.jvyamlb.tokens.BlockEntryToken;
import org.jvyamlb.tokens.BlockMappingStartToken;
import org.jvyamlb.tokens.BlockSequenceStartToken;
import org.jvyamlb.tokens.DirectiveToken;
import org.jvyamlb.tokens.DocumentEndToken;
import org.jvyamlb.tokens.DocumentStartToken;
import org.jvyamlb.tokens.FlowEntryToken;
import org.jvyamlb.tokens.FlowMappingEndToken;
import org.jvyamlb.tokens.FlowMappingStartToken;
import org.jvyamlb.tokens.FlowSequenceEndToken;
import org.jvyamlb.tokens.FlowSequenceStartToken;
import org.jvyamlb.tokens.KeyToken;
import org.jvyamlb.tokens.ScalarToken;
import org.jvyamlb.tokens.StreamEndToken;
import org.jvyamlb.tokens.TagToken;
import org.jvyamlb.tokens.Token;
import org.jvyamlb.tokens.ValueToken;
import org.jvyamlb.util.IntStack;

public class ParserImpl
implements Parser {
    private static final int P_STREAM = 0;
    private static final int P_STREAM_START = 1;
    private static final int P_STREAM_END = 2;
    private static final int P_IMPLICIT_DOCUMENT = 3;
    private static final int P_EXPLICIT_DOCUMENT = 4;
    private static final int P_DOCUMENT_START = 5;
    private static final int P_DOCUMENT_START_IMPLICIT = 6;
    private static final int P_DOCUMENT_END = 7;
    private static final int P_BLOCK_NODE = 8;
    private static final int P_BLOCK_CONTENT = 9;
    private static final int P_PROPERTIES = 10;
    private static final int P_PROPERTIES_END = 11;
    private static final int P_FLOW_CONTENT = 12;
    private static final int P_BLOCK_SEQUENCE = 13;
    private static final int P_BLOCK_MAPPING = 14;
    private static final int P_FLOW_SEQUENCE = 15;
    private static final int P_FLOW_MAPPING = 16;
    private static final int P_SCALAR = 17;
    private static final int P_BLOCK_SEQUENCE_ENTRY = 18;
    private static final int P_BLOCK_MAPPING_ENTRY = 19;
    private static final int P_BLOCK_MAPPING_ENTRY_VALUE = 20;
    private static final int P_BLOCK_NODE_OR_INDENTLESS_SEQUENCE = 21;
    private static final int P_BLOCK_SEQUENCE_START = 22;
    private static final int P_BLOCK_SEQUENCE_END = 23;
    private static final int P_BLOCK_MAPPING_START = 24;
    private static final int P_BLOCK_MAPPING_END = 25;
    private static final int P_INDENTLESS_BLOCK_SEQUENCE = 26;
    private static final int P_BLOCK_INDENTLESS_SEQUENCE_START = 27;
    private static final int P_INDENTLESS_BLOCK_SEQUENCE_ENTRY = 28;
    private static final int P_BLOCK_INDENTLESS_SEQUENCE_END = 29;
    private static final int P_FLOW_SEQUENCE_START = 30;
    private static final int P_FLOW_SEQUENCE_ENTRY = 31;
    private static final int P_FLOW_SEQUENCE_END = 32;
    private static final int P_FLOW_MAPPING_START = 33;
    private static final int P_FLOW_MAPPING_ENTRY = 34;
    private static final int P_FLOW_MAPPING_END = 35;
    private static final int P_FLOW_INTERNAL_MAPPING_START = 36;
    private static final int P_FLOW_INTERNAL_CONTENT = 37;
    private static final int P_FLOW_INTERNAL_VALUE = 38;
    private static final int P_FLOW_INTERNAL_MAPPING_END = 39;
    private static final int P_FLOW_ENTRY_MARKER = 40;
    private static final int P_FLOW_NODE = 41;
    private static final int P_FLOW_MAPPING_INTERNAL_CONTENT = 42;
    private static final int P_FLOW_MAPPING_INTERNAL_VALUE = 43;
    private static final int P_ALIAS = 44;
    private static final int P_EMPTY_SCALAR = 45;
    private static final String[] productionNames = new String[46];
    private static final Event DOCUMENT_END_TRUE;
    private static final Event DOCUMENT_END_FALSE;
    private static final Event MAPPING_END;
    private static final Event SEQUENCE_END;
    private static final Event STREAM_END;
    private static final Event STREAM_START;
    private static final Map DEFAULT_TAGS_1_0;
    private static final Map DEFAULT_TAGS_1_1;
    private static final Pattern ONLY_WORD;
    private Scanner scanner = null;
    private YAMLConfig cfg = null;
    private Event currentEvent = null;
    private IntStack parseStack = null;
    private ProductionEnvironment pEnv = null;

    private static Event processEmptyScalar() {
        return new ScalarEvent(null, null, new boolean[]{true, false}, new ByteList(ByteList.NULL_ARRAY), '\u0000');
    }

    private static Object[] processDirectives(ProductionEnvironment env, Scanner scanner) {
        while (scanner.peekToken() instanceof DirectiveToken) {
            DirectiveToken tok = (DirectiveToken)scanner.getToken();
            if (tok.getName().equals("YAML")) {
                if (env.getYamlVersion() != null) {
                    throw new ParserException(null, "found duplicate YAML directive", null);
                }
                int major = Integer.parseInt(tok.getValue()[0]);
                int minor = Integer.parseInt(tok.getValue()[1]);
                if (major != 1) {
                    throw new ParserException(null, "found incompatible YAML document (version 1.* is required)", null);
                }
                env.setYamlVersion(new int[]{major, minor});
                continue;
            }
            if (!tok.getName().equals("TAG")) continue;
            String handle = tok.getValue()[0];
            String prefix = tok.getValue()[1];
            if (env.getTagHandles().containsKey(handle)) {
                throw new ParserException(null, "duplicate tag handle " + handle, null);
            }
            env.getTagHandles().put(handle, prefix);
        }
        Object[] value = new Object[2];
        value[0] = env.getFinalYamlVersion();
        if (!env.getTagHandles().isEmpty()) {
            value[1] = new HashMap(env.getTagHandles());
        }
        Map baseTags = ((int[])value[0])[1] == 0 ? DEFAULT_TAGS_1_0 : DEFAULT_TAGS_1_1;
        Iterator iter = baseTags.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (env.getTagHandles().containsKey(key)) continue;
            env.getTagHandles().put(key, baseTags.get(key));
        }
        return value;
    }

    public ParserImpl(Scanner scanner) {
        this(scanner, YAML.config());
    }

    public ParserImpl(Scanner scanner, YAMLConfig cfg) {
        this.scanner = scanner;
        this.cfg = cfg;
    }

    public boolean checkEvent(Class[] choices) {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        if (this.currentEvent != null) {
            if (choices.length == 0) {
                return true;
            }
            int j = choices.length;
            for (int i = 0; i < j; ++i) {
                if (!choices[i].isInstance(this.currentEvent)) continue;
                return true;
            }
        }
        return false;
    }

    public Event peekEvent() {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        return this.currentEvent;
    }

    public Event getEvent() {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        Event value = this.currentEvent;
        this.currentEvent = null;
        return value;
    }

    public Iterator eachEvent() {
        return new EventIterator();
    }

    public Iterator iterator() {
        return this.eachEvent();
    }

    public void parseStream() {
        if (null == this.parseStack) {
            this.parseStack = new IntStack();
            this.parseStack.push(0);
            this.pEnv = new ProductionEnvironment(this.cfg);
        }
    }

    public Event parseStreamNext() {
        while (!this.parseStack.isEmpty()) {
            Event value = this.pEnv.produce(this.parseStack.pop(), this.parseStack, this.scanner);
            if (null == value) continue;
            return value;
        }
        this.pEnv = null;
        return null;
    }

    public static void tmainx(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        ByteList input = new ByteList(1024);
        FileInputStream reader = new FileInputStream(filename);
        byte[] buff = new byte[1024];
        int read = 0;
        do {
            read = ((InputStream)reader).read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((InputStream)reader).close();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ParserImpl pars = new ParserImpl(new ScannerImpl(input));
            Iterator iter = pars.eachEvent();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the events for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    public static void tmain(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        FileInputStream reader = new FileInputStream(filename);
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ParserImpl pars = new ParserImpl(new ScannerImpl(reader));
            Iterator iter = pars.eachEvent();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        ((InputStream)reader).close();
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the events for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        ParserImpl pars = new ParserImpl(new ScannerImpl(new FileInputStream(filename)));
        Iterator iter = pars.eachEvent();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    static {
        ParserImpl.productionNames[0] = "P_STREAM";
        ParserImpl.productionNames[1] = "P_STREAM_START";
        ParserImpl.productionNames[2] = "P_STREAM_END";
        ParserImpl.productionNames[3] = "P_IMPLICIT_DOCUMENT";
        ParserImpl.productionNames[4] = "P_EXPLICIT_DOCUMENT";
        ParserImpl.productionNames[5] = "P_DOCUMENT_START";
        ParserImpl.productionNames[6] = "P_DOCUMENT_START_IMPLICIT";
        ParserImpl.productionNames[7] = "P_DOCUMENT_END";
        ParserImpl.productionNames[8] = "P_BLOCK_NODE";
        ParserImpl.productionNames[9] = "P_BLOCK_CONTENT";
        ParserImpl.productionNames[10] = "P_PROPERTIES";
        ParserImpl.productionNames[11] = "P_PROPERTIES_END";
        ParserImpl.productionNames[12] = "P_FLOW_CONTENT";
        ParserImpl.productionNames[13] = "P_BLOCK_SEQUENCE";
        ParserImpl.productionNames[14] = "P_BLOCK_MAPPING";
        ParserImpl.productionNames[15] = "P_FLOW_SEQUENCE";
        ParserImpl.productionNames[16] = "P_FLOW_MAPPING";
        ParserImpl.productionNames[17] = "P_SCALAR";
        ParserImpl.productionNames[18] = "P_BLOCK_SEQUENCE_ENTRY";
        ParserImpl.productionNames[19] = "P_BLOCK_MAPPING_ENTRY";
        ParserImpl.productionNames[20] = "P_BLOCK_MAPPING_ENTRY_VALUE";
        ParserImpl.productionNames[21] = "P_BLOCK_NODE_OR_INDENTLESS_SEQUENCE";
        ParserImpl.productionNames[22] = "P_BLOCK_SEQUENCE_START";
        ParserImpl.productionNames[23] = "P_BLOCK_SEQUENCE_END";
        ParserImpl.productionNames[24] = "P_BLOCK_MAPPING_START";
        ParserImpl.productionNames[25] = "P_BLOCK_MAPPING_END";
        ParserImpl.productionNames[26] = "P_INDENTLESS_BLOCK_SEQUENCE";
        ParserImpl.productionNames[27] = "P_BLOCK_INDENTLESS_SEQUENCE_START";
        ParserImpl.productionNames[28] = "P_INDENTLESS_BLOCK_SEQUENCE_ENTRY";
        ParserImpl.productionNames[29] = "P_BLOCK_INDENTLESS_SEQUENCE_END";
        ParserImpl.productionNames[30] = "P_FLOW_SEQUENCE_START";
        ParserImpl.productionNames[31] = "P_FLOW_SEQUENCE_ENTRY";
        ParserImpl.productionNames[32] = "P_FLOW_SEQUENCE_END";
        ParserImpl.productionNames[33] = "P_FLOW_MAPPING_START";
        ParserImpl.productionNames[34] = "P_FLOW_MAPPING_ENTRY";
        ParserImpl.productionNames[35] = "P_FLOW_MAPPING_END";
        ParserImpl.productionNames[36] = "P_FLOW_INTERNAL_MAPPING_START";
        ParserImpl.productionNames[37] = "P_FLOW_INTERNAL_CONTENT";
        ParserImpl.productionNames[38] = "P_FLOW_INTERNAL_VALUE";
        ParserImpl.productionNames[39] = "P_FLOW_INTERNAL_MAPPING_END";
        ParserImpl.productionNames[40] = "P_FLOW_ENTRY_MARKER";
        ParserImpl.productionNames[41] = "P_FLOW_NODE";
        ParserImpl.productionNames[42] = "P_FLOW_MAPPING_INTERNAL_CONTENT";
        ParserImpl.productionNames[43] = "P_FLOW_MAPPING_INTERNAL_VALUE";
        ParserImpl.productionNames[44] = "P_ALIAS";
        ParserImpl.productionNames[45] = "P_EMPTY_SCALAR";
        DOCUMENT_END_TRUE = new DocumentEndEvent(true);
        DOCUMENT_END_FALSE = new DocumentEndEvent(false);
        MAPPING_END = new MappingEndEvent();
        SEQUENCE_END = new SequenceEndEvent();
        STREAM_END = new StreamEndEvent();
        STREAM_START = new StreamStartEvent();
        DEFAULT_TAGS_1_0 = new HashMap();
        DEFAULT_TAGS_1_1 = new HashMap();
        DEFAULT_TAGS_1_0.put("!", "tag:yaml.org,2002:");
        DEFAULT_TAGS_1_0.put("!!", "");
        DEFAULT_TAGS_1_1.put("!", "!");
        DEFAULT_TAGS_1_1.put("!!", "tag:yaml.org,2002:");
        ONLY_WORD = Pattern.compile("^\\w+$");
    }

    private class EventIterator
    implements Iterator {
        private EventIterator() {
        }

        public boolean hasNext() {
            return null != ParserImpl.this.peekEvent();
        }

        public Object next() {
            return ParserImpl.this.getEvent();
        }

        public void remove() {
        }
    }

    private static class ProductionEnvironment {
        private List tags = new LinkedList();
        private List anchors = new LinkedList();
        private Map tagHandles = new HashMap();
        private int[] yamlVersion = null;
        private int[] defaultYamlVersion = new int[2];

        public ProductionEnvironment(YAMLConfig cfg) {
            this.defaultYamlVersion[0] = Integer.parseInt(cfg.version().substring(0, cfg.version().indexOf(46)));
            this.defaultYamlVersion[1] = Integer.parseInt(cfg.version().substring(cfg.version().indexOf(46) + 1));
        }

        public List getTags() {
            return this.tags;
        }

        public List getAnchors() {
            return this.anchors;
        }

        public Map getTagHandles() {
            return this.tagHandles;
        }

        public int[] getYamlVersion() {
            return this.yamlVersion;
        }

        public int[] getFinalYamlVersion() {
            if (null == this.yamlVersion) {
                return this.defaultYamlVersion;
            }
            return this.yamlVersion;
        }

        public void setYamlVersion(int[] yamlVersion) {
            this.yamlVersion = yamlVersion;
        }

        public Event produce(int current, IntStack parseStack, Scanner scanner) {
            switch (current) {
                case 0: {
                    parseStack.push(2);
                    parseStack.push(4);
                    parseStack.push(3);
                    parseStack.push(1);
                    return null;
                }
                case 1: {
                    scanner.getToken();
                    return STREAM_START;
                }
                case 2: {
                    scanner.getToken();
                    return STREAM_END;
                }
                case 3: {
                    Token curr = scanner.peekToken();
                    if (!(curr instanceof DirectiveToken || curr instanceof DocumentStartToken || curr instanceof StreamEndToken)) {
                        parseStack.push(7);
                        parseStack.push(8);
                        parseStack.push(6);
                    }
                    return null;
                }
                case 4: {
                    if (!(scanner.peekToken() instanceof StreamEndToken)) {
                        parseStack.push(4);
                        parseStack.push(7);
                        parseStack.push(8);
                        parseStack.push(5);
                    }
                    return null;
                }
                case 5: {
                    Token tok = scanner.peekToken();
                    Object[] directives = ParserImpl.processDirectives(this, scanner);
                    if (!(scanner.peekToken() instanceof DocumentStartToken)) {
                        throw new ParserException(null, "expected '<document start>', but found " + tok.getClass().getName(), null);
                    }
                    scanner.getToken();
                    return new DocumentStartEvent(true, (int[])directives[0], (Map)directives[1]);
                }
                case 6: {
                    Object[] directives = ParserImpl.processDirectives(this, scanner);
                    return new DocumentStartEvent(false, (int[])directives[0], (Map)directives[1]);
                }
                case 7: {
                    Token tok = scanner.peekToken();
                    boolean explicit = false;
                    while (scanner.peekToken() instanceof DocumentEndToken) {
                        scanner.getToken();
                        explicit = true;
                    }
                    return explicit ? DOCUMENT_END_TRUE : DOCUMENT_END_FALSE;
                }
                case 8: {
                    Token curr = scanner.peekToken();
                    if (curr instanceof DirectiveToken || curr instanceof DocumentStartToken || curr instanceof DocumentEndToken || curr instanceof StreamEndToken) {
                        parseStack.push(45);
                    } else if (curr instanceof AliasToken) {
                        parseStack.push(44);
                    } else {
                        parseStack.push(11);
                        parseStack.push(9);
                        parseStack.push(10);
                    }
                    return null;
                }
                case 9: {
                    Token tok = scanner.peekToken();
                    if (tok instanceof BlockSequenceStartToken) {
                        parseStack.push(13);
                    } else if (tok instanceof BlockMappingStartToken) {
                        parseStack.push(14);
                    } else if (tok instanceof FlowSequenceStartToken) {
                        parseStack.push(15);
                    } else if (tok instanceof FlowMappingStartToken) {
                        parseStack.push(16);
                    } else if (tok instanceof ScalarToken) {
                        parseStack.push(17);
                    } else {
                        boolean[] implicit = new boolean[]{false, false};
                        return new ScalarEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, new ByteList(new byte[0], false), '\'');
                    }
                    return null;
                }
                case 10: {
                    String anchor = null;
                    Object tag = null;
                    if (scanner.peekToken() instanceof AnchorToken) {
                        anchor = ((AnchorToken)scanner.getToken()).getValue();
                        if (scanner.peekToken() instanceof TagToken) {
                            tag = ((TagToken)scanner.getToken()).getValue();
                        }
                    } else if (scanner.peekToken() instanceof TagToken) {
                        tag = ((TagToken)scanner.getToken()).getValue();
                        if (scanner.peekToken() instanceof AnchorToken) {
                            anchor = ((AnchorToken)scanner.getToken()).getValue();
                        }
                    }
                    if (tag != null && !tag.equals("!")) {
                        String handle = ScannerImpl.into(tag[0]);
                        String suffix = ScannerImpl.into(tag[1]);
                        int ix = -1;
                        ix = suffix.indexOf("^");
                        if (ix != -1) {
                            suffix = suffix.substring(0, ix) + suffix.substring(ix + 1);
                        }
                        if (handle != null) {
                            if (!this.getTagHandles().containsKey(handle)) {
                                throw new ParserException("while parsing a node", "found undefined tag handle " + handle, null);
                            }
                            ix = suffix.indexOf("/");
                            if (ix != -1) {
                                String before = suffix.substring(0, ix);
                                String after = suffix.substring(ix + 1);
                                tag = ONLY_WORD.matcher(before).matches() ? "tag:" + before + ".yaml.org,2002:" + after : (before.startsWith("tag:") ? before + ":" + after : "tag:" + before + ":" + after);
                            } else {
                                tag = (String)this.getTagHandles().get(handle) + suffix;
                            }
                        } else {
                            tag = suffix;
                        }
                    }
                    this.getAnchors().add(0, anchor);
                    this.getTags().add(0, tag);
                    return null;
                }
                case 11: {
                    this.getAnchors().remove(0);
                    this.getTags().remove(0);
                    return null;
                }
                case 12: {
                    Token tok = scanner.peekToken();
                    if (tok instanceof FlowSequenceStartToken) {
                        parseStack.push(15);
                    } else if (tok instanceof FlowMappingStartToken) {
                        parseStack.push(16);
                    } else if (tok instanceof ScalarToken) {
                        parseStack.push(17);
                    } else {
                        throw new ParserException("while scanning a flow node", "expected the node content, but found " + tok.getClass().getName(), null);
                    }
                    return null;
                }
                case 13: {
                    parseStack.push(23);
                    parseStack.push(18);
                    parseStack.push(22);
                    return null;
                }
                case 14: {
                    parseStack.push(25);
                    parseStack.push(19);
                    parseStack.push(24);
                    return null;
                }
                case 15: {
                    parseStack.push(32);
                    parseStack.push(31);
                    parseStack.push(30);
                    return null;
                }
                case 16: {
                    parseStack.push(35);
                    parseStack.push(34);
                    parseStack.push(33);
                    return null;
                }
                case 17: {
                    ScalarToken tok = (ScalarToken)scanner.getToken();
                    boolean[] implicit = null;
                    implicit = tok.getPlain() && this.getTags().get(0) == null || "!".equals(this.getTags().get(0)) ? new boolean[]{true, false} : (this.getTags().get(0) == null ? new boolean[]{false, true} : new boolean[]{false, false});
                    return new ScalarEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, tok.getValue(), tok.getStyle());
                }
                case 18: {
                    if (scanner.peekToken() instanceof BlockEntryToken) {
                        scanner.getToken();
                        if (!(scanner.peekToken() instanceof BlockEntryToken) && !(scanner.peekToken() instanceof BlockEndToken)) {
                            parseStack.push(18);
                            parseStack.push(8);
                        } else {
                            parseStack.push(18);
                            parseStack.push(45);
                        }
                    }
                    return null;
                }
                case 19: {
                    if (scanner.peekToken() instanceof KeyToken || scanner.peekToken() instanceof ValueToken) {
                        if (scanner.peekToken() instanceof KeyToken) {
                            scanner.getToken();
                            Token curr = scanner.peekToken();
                            if (!(curr instanceof KeyToken || curr instanceof ValueToken || curr instanceof BlockEndToken)) {
                                parseStack.push(19);
                                parseStack.push(20);
                                parseStack.push(21);
                            } else {
                                parseStack.push(19);
                                parseStack.push(20);
                                parseStack.push(45);
                            }
                        } else {
                            parseStack.push(19);
                            parseStack.push(20);
                            parseStack.push(45);
                        }
                    }
                    return null;
                }
                case 20: {
                    if (scanner.peekToken() instanceof KeyToken || scanner.peekToken() instanceof ValueToken) {
                        if (scanner.peekToken() instanceof ValueToken) {
                            scanner.getToken();
                            Token curr = scanner.peekToken();
                            if (!(curr instanceof KeyToken || curr instanceof ValueToken || curr instanceof BlockEndToken)) {
                                if (curr instanceof ScalarToken && scanner.peekToken(1) instanceof BlockEntryToken) {
                                    scanner.getToken();
                                }
                                parseStack.push(21);
                            } else {
                                parseStack.push(45);
                            }
                        } else {
                            parseStack.push(45);
                        }
                    }
                    return null;
                }
                case 21: {
                    if (scanner.peekToken() instanceof AliasToken) {
                        parseStack.push(44);
                    } else if (scanner.peekToken() instanceof BlockEntryToken) {
                        parseStack.push(26);
                        parseStack.push(10);
                    } else {
                        parseStack.push(9);
                        parseStack.push(10);
                    }
                    return null;
                }
                case 22: {
                    boolean implicit = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new SequenceStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, false);
                }
                case 23: {
                    Token tok = null;
                    if (!(scanner.peekToken() instanceof BlockEndToken)) {
                        tok = scanner.peekToken();
                        throw new ParserException("while scanning a block collection", "expected <block end>, but found " + tok.getClass().getName(), null);
                    }
                    scanner.getToken();
                    return SEQUENCE_END;
                }
                case 24: {
                    boolean implicit = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new MappingStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, false);
                }
                case 25: {
                    Token tok = null;
                    if (!(scanner.peekToken() instanceof BlockEndToken)) {
                        tok = scanner.peekToken();
                        throw new ParserException("while scanning a block mapping", "expected <block end>, but found " + tok.getClass().getName(), null);
                    }
                    scanner.getToken();
                    return MAPPING_END;
                }
                case 26: {
                    parseStack.push(29);
                    parseStack.push(28);
                    parseStack.push(27);
                    return null;
                }
                case 27: {
                    boolean implicit = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    return new SequenceStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, false);
                }
                case 28: {
                    if (scanner.peekToken() instanceof BlockEntryToken) {
                        scanner.getToken();
                        Token curr = scanner.peekToken();
                        if (!(curr instanceof BlockEntryToken || curr instanceof KeyToken || curr instanceof ValueToken || curr instanceof BlockEndToken)) {
                            parseStack.push(28);
                            parseStack.push(8);
                        } else {
                            parseStack.push(28);
                            parseStack.push(45);
                        }
                    }
                    return null;
                }
                case 29: {
                    return SEQUENCE_END;
                }
                case 30: {
                    boolean implicit = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new SequenceStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, true);
                }
                case 31: {
                    if (!(scanner.peekToken() instanceof FlowSequenceEndToken)) {
                        if (scanner.peekToken() instanceof KeyToken) {
                            parseStack.push(31);
                            parseStack.push(40);
                            parseStack.push(39);
                            parseStack.push(38);
                            parseStack.push(37);
                            parseStack.push(36);
                        } else {
                            parseStack.push(31);
                            parseStack.push(41);
                            parseStack.push(40);
                        }
                    }
                    return null;
                }
                case 32: {
                    scanner.getToken();
                    return SEQUENCE_END;
                }
                case 33: {
                    boolean implicit = this.getTags().get(0) == null || this.getTags().get(0).equals("!");
                    scanner.getToken();
                    return new MappingStartEvent((String)this.getAnchors().get(0), (String)this.getTags().get(0), implicit, true);
                }
                case 34: {
                    if (!(scanner.peekToken() instanceof FlowMappingEndToken)) {
                        if (scanner.peekToken() instanceof KeyToken) {
                            parseStack.push(34);
                            parseStack.push(40);
                            parseStack.push(43);
                            parseStack.push(42);
                        } else {
                            parseStack.push(34);
                            parseStack.push(45);
                            parseStack.push(41);
                            parseStack.push(40);
                        }
                    }
                    return null;
                }
                case 35: {
                    scanner.getToken();
                    return MAPPING_END;
                }
                case 36: {
                    scanner.getToken();
                    return new MappingStartEvent(null, null, true, true);
                }
                case 37: {
                    Token curr = scanner.peekToken();
                    if (!(curr instanceof ValueToken || curr instanceof FlowEntryToken || curr instanceof FlowSequenceEndToken)) {
                        parseStack.push(41);
                    } else {
                        parseStack.push(45);
                    }
                    return null;
                }
                case 38: {
                    if (scanner.peekToken() instanceof ValueToken) {
                        scanner.getToken();
                        if (!(scanner.peekToken() instanceof FlowEntryToken) && !(scanner.peekToken() instanceof FlowSequenceEndToken)) {
                            parseStack.push(41);
                        } else {
                            parseStack.push(45);
                        }
                    } else {
                        parseStack.push(45);
                    }
                    return null;
                }
                case 39: {
                    return MAPPING_END;
                }
                case 40: {
                    if (scanner.peekToken() instanceof FlowEntryToken) {
                        scanner.getToken();
                    }
                    return null;
                }
                case 41: {
                    if (scanner.peekToken() instanceof AliasToken) {
                        parseStack.push(44);
                    } else {
                        parseStack.push(11);
                        parseStack.push(12);
                        parseStack.push(10);
                    }
                    return null;
                }
                case 42: {
                    Token curr = scanner.peekToken();
                    if (!(curr instanceof ValueToken || curr instanceof FlowEntryToken || curr instanceof FlowMappingEndToken)) {
                        scanner.getToken();
                        parseStack.push(41);
                    } else {
                        parseStack.push(45);
                    }
                    return null;
                }
                case 43: {
                    if (scanner.peekToken() instanceof ValueToken) {
                        scanner.getToken();
                        if (!(scanner.peekToken() instanceof FlowEntryToken) && !(scanner.peekToken() instanceof FlowMappingEndToken)) {
                            parseStack.push(41);
                        } else {
                            parseStack.push(45);
                        }
                    } else {
                        parseStack.push(45);
                    }
                    return null;
                }
                case 44: {
                    AliasToken tok = (AliasToken)scanner.getToken();
                    return new AliasEvent(tok.getValue());
                }
                case 45: {
                    return ParserImpl.processEmptyScalar();
                }
            }
            return null;
        }
    }
}

