/* dayview.c
 * A module of J-Pilot http://jpilot.org
 * 
 * Copyright (C) 2002-2003 by Judd Montgomery
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "config.h"
#include "i18n.h"
#include <gtk/gtk.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "datebook.h"
#include "dayview.h"
#include "prefs.h"
#include "password.h"

static GtkWidget *scrolled_window;
  
static GList *glob_dv_data_head=NULL;
static GList *glob_dv_data_tail=NULL;

static GtkWidget *glob_layout;

//undo
static int X_DRAW; /* Horizontal, needs to be read after GTK settles */
#define Y_DRAW 1440 /* Vertical drawing area size */
#define L_BORDER 10 /* Left border size */
#define R_BORDER 10 /* Right border size */
#define T_BORDER 10 /* Top border size */
#define B_BORDER 10 /* Bottom border size */
#define NUM_HOURS 24 /* Number of hours to show */
static int text_width;
static int y_inc;
static int rect_width;
//int dv_button_active;

void free_dv_data_list(GList **Plist)
{
   GList *list, *temp_list;
   struct dv_data *d;

   if (!Plist) return;
   list = *Plist;

   /* Go to first entry in the list */
   temp_list = g_list_first(*Plist);

   for (temp_list = list; temp_list; temp_list = temp_list->next) {
      if (temp_list->data) {
	 d=temp_list->data;
	 if (d->button) {
	    gtk_widget_destroy(d->button);
	 }
	 free(temp_list->data);
      }
   }
   g_list_free(list);
   *Plist=NULL;
}

int calc_text_width(GtkWidget *layout)
{
   struct tm t;
   int hour;
   int w;
   int text_width;
   char str[30];
   char datef[16];

   get_pref_hour_ampm(datef);

   text_width=w=0;
   for (hour=0; hour<24; hour++) {
      t.tm_hour=hour;
      strftime(str, sizeof(str), datef, &t);
      if (str[0]=='0') str[0]=' ';
#ifdef ENABLE_GTK2
      w=gdk_string_width(gtk_style_get_font(GTK_WIDGET(layout)->style), str);
#else
      w=gdk_string_width(GTK_WIDGET(layout)->style->font, str);
#endif
      if (w>text_width) text_width=w;
   }
   return text_width;
}

static gboolean cb_layout_destroy(GtkWidget *widget)
{
   //struct dialog_data *Pdata;
   printf("layout destroy\n");//undo
   //gtk_object_set_data(GTK_OBJECT(dialog), "dialog_data", Pdata);
   //Pdata = gtk_object_get_data(GTK_OBJECT(widget), "dialog_data");
   return FALSE;
}
   
/*
 * undo docu
 */
int layout_draw_appt(GtkWidget *layout,
		     char *str, int hour1, int min1, int hour2, int min2,
		     int depth, int position)
{
   int length_minutes;
   const int border=8;
   GtkWidget *button;
   int x,y,w,h;
   GtkWidget *label, *hbox;
   GtkWidget *pixmapwid;
   GdkPixmap *pixmap;
   GdkBitmap *mask;

   length_minutes = (hour2*60+min2) - (hour1*60+min1);
   h = y_inc*length_minutes/60;
   y = T_BORDER + y_inc*hour1 + y_inc * min1/60;
   w = (rect_width - border * 2)/depth;
   x = (L_BORDER + text_width + border) + (position - 1)*w;
   y = T_BORDER + y_inc*hour1 + y_inc * min1/60;

   //button = gtk_button_new_with_label(str);
   hbox=gtk_hbox_new(FALSE, 1);
   button = gtk_button_new();
   gtk_container_add(GTK_CONTAINER(button), hbox);

   get_pixmaps(scrolled_window, PIXMAP_NOTE, &pixmap, &mask);
   pixmapwid = gtk_pixmap_new(pixmap, mask);
   gtk_misc_set_alignment(GTK_MISC(pixmapwid), 0, 0);
   gtk_widget_show(pixmapwid);
   gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, 0);
   
   get_pixmaps(scrolled_window, PIXMAP_ALARM, &pixmap, &mask);
   pixmapwid = gtk_pixmap_new(pixmap, mask);
   gtk_misc_set_alignment(GTK_MISC(pixmapwid), 0, 0);
   gtk_widget_show(pixmapwid);
   gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, 0);   

   get_pixmaps(scrolled_window, PIXMAP_FLOAT_CHECKED, &pixmap, &mask);
   pixmapwid = gtk_pixmap_new(pixmap, mask);
   gtk_misc_set_alignment(GTK_MISC(pixmapwid), 0, 0);
   gtk_widget_show(pixmapwid);
   gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, 0);

   label=gtk_label_new(str);
   gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

   gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
   label=gtk_label_new("there");
   gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
   gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
   gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
   
   //gtk_misc_set_alignment(GTK_MISC(GTK_BIN(button)->child), 0, 0);
   //gtk_label_set_justify(GTK_LABEL(GTK_BIN(button)->child), GTK_JUSTIFY_LEFT);
   //gtk_label_set_line_wrap(GTK_LABEL(GTK_BIN(button)->child), TRUE);//undo test
   gtk_widget_set_usize(GTK_WIDGET(button), w, h);
   gtk_layout_put(GTK_LAYOUT(layout), button, x, y);

   gtk_adjustment_set_value(gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrolled_window)),
			    y_inc*2);

   gtk_widget_show_all(button);

   return 0;
}

void
layout_draw_grid(GtkWidget *layout)
{
   struct tm t;
   int y;
   int xp;
   int h;
   int hour;
   char str[30];
   char datef[16];
   int xoff, yoff;

   //printf("layout_draw_grid\n");
#ifdef ENABLE_GTK2
   /* Gtk2 takes care of the xoffset and yoffset for us
    * Gtk1 does not */
   yoff=xoff=0;
#else
   yoff=GTK_LAYOUT(layout)->yoffset;
   xoff=GTK_LAYOUT(layout)->xoffset;
#endif

   /* How many pixels in 1 hour */
   y_inc = (Y_DRAW - T_BORDER - B_BORDER) / NUM_HOURS;

   get_pref_hour_ampm(datef);

   for (y=T_BORDER, hour=0; y+y_inc < Y_DRAW; y+=y_inc, hour++) {
      t.tm_hour=hour;
      strftime(str, sizeof(str), datef, &t);
      if (str[0]=='0') str[0]=' ';

#ifdef ENABLE_GTK2
      h=gdk_string_height(gtk_style_get_font(GTK_WIDGET(layout)->style), str);
      gdk_draw_text(GTK_LAYOUT(layout)->bin_window,
		    gtk_style_get_font(GTK_WIDGET(layout)->style),
		    GTK_WIDGET(layout)->style->black_gc,
		    L_BORDER, y + h - yoff,
		    str, strlen(str));
#else
      h=gdk_string_height(GTK_WIDGET(layout)->style->font, str);
      gdk_draw_text(GTK_LAYOUT(layout)->bin_window,
		    GTK_WIDGET(layout)->style->font,
		    GTK_WIDGET(layout)->style->black_gc,
		    L_BORDER - xoff, y + h - yoff,
		    str, strlen(str));
#endif      
   }
      
   xp = L_BORDER + text_width - xoff;

   for (y=T_BORDER; y+y_inc < Y_DRAW; y+=y_inc) {
      gdk_draw_rectangle(GTK_LAYOUT(layout)->bin_window,
			 GTK_WIDGET(layout)->style->black_gc,
			 FALSE,
			 xp, y - yoff,
			 rect_width, y_inc);
      gdk_draw_line(GTK_LAYOUT(layout)->bin_window,
		    GTK_WIDGET(layout)->style->dark_gc[0],
		    xp + 1, y - yoff+y_inc/4,
		    xp + rect_width - 1, y - yoff+y_inc/4);
      gdk_draw_line(GTK_LAYOUT(layout)->bin_window,
		    GTK_WIDGET(layout)->style->dark_gc[0],
		    xp + 1, y - yoff+y_inc/4*2,
		    xp + rect_width - 1, y - yoff+y_inc/4*2);
      gdk_draw_line(GTK_LAYOUT(layout)->bin_window,
		    GTK_WIDGET(layout)->style->dark_gc[0],
		    xp + 1, y - yoff+y_inc/4*3,
		    xp + rect_width - 1, y - yoff+y_inc/4*3);
   }
}

/* Gets called whenever the drawing area needs drawn or redrawn */
gboolean
layout_expose_handler(GtkWidget *layout, GdkEventExpose *event)
{
//printf("event %d %d\n", event->area.x, event->area.y);//undo
   if (event->window != GTK_LAYOUT(layout)->bin_window) {
      return FALSE;
   }

#ifndef ENABLE_GTK2
   gdk_window_clear_area(layout->window,
			 event->area.x, event->area.y,
			 event->area.width, event->area.height);
#endif
   if (X_DRAW < 5) {
      X_DRAW=GTK_WIDGET(layout)->allocation.width;
   }
   if (text_width==0) {
      text_width = calc_text_width(layout);
      rect_width = X_DRAW-L_BORDER-R_BORDER-text_width;
   }
   //printf("expose text_width=%d\n", text_width);//undo

   layout_draw_grid(layout);
   
   return FALSE;
}

int update_daily_view_undo(AppointmentList *al)
{
   layout_draw_appt(glob_layout,
		    "4:11 - 4:58 This is a test appointment\nThis is line 2 longer than line 3\nthis is line 3",
		    4, 11, 4, 58, 1, 1);
   layout_draw_appt(glob_layout,
		    "This is an overlapping appt. from 1:00 to 2:00",
		    1, 0, 2, 0, 2, 1);
   layout_draw_appt(glob_layout,
		    "This is an overlapping appt. from 1:30 to 2:30",
		    1, 30, 2, 30, 2, 2);

   return 0;
}

int add_to_list(GList *list, struct dv_data *dvd)
{
   struct dv_data *temp_dvd;
   temp_dvd = malloc(sizeof(struct dv_data));
   memcpy(temp_dvd, dvd, sizeof(struct dv_data));
   if (glob_dv_data_head==NULL) {
      glob_dv_data_head=g_list_append(glob_dv_data_tail, temp_dvd);
      glob_dv_data_tail=glob_dv_data_head;
   } else {
      g_list_append(glob_dv_data_tail, temp_dvd);
      glob_dv_data_tail=glob_dv_data_tail->next;
   }
   return 0;
}
int update_daily_view(AppointmentList *al)
{
#if 0
   int num_entries, entries_shown, num, i;
   AppointmentList *temp_al;
   char datef[20];
   int has_note;
#ifdef ENABLE_DATEBK
   int ret;
   int cat_bit;
   int db3_type;
   long use_db3_tags;
   struct db4_struct db4;
   GdkPixmap *pixmap_float_check;
   GdkPixmap *pixmap_float_checked;
   GdkBitmap *mask_float_check;
   GdkBitmap *mask_float_checked;
#endif
   struct tm new_time;
   int show_priv;
   struct dv_data dvd;

   jp_logf(JP_LOG_DEBUG, "update_daily_view()\n");
   printf("update_daily_view()\n");//undo

#ifdef ENABLE_DATEBK
   get_pref(PREF_USE_DB3, &use_db3_tags, NULL);
#endif

   memset(&dvd, 0, sizeof(dvd));

   //memset(&new_time, 0, sizeof(new_time));
   //new_time.tm_hour=11;
   //new_time.tm_mday=current_day;
   //new_time.tm_mon=current_month;
   //new_time.tm_year=current_year;
   //new_time.tm_isdst=-1;

   //mktime(&new_time);

//   free_AppointmentList(&glob_al);

//   num = get_days_appointments2(&glob_al, &new_time, 2, 2, 1,
//					&num_entries);

   free_dv_data_list(&glob_dv_data_head);

   show_priv = show_privates(GET_PRIVATES);

   entries_shown=0;
   for (temp_al = glob_al, i=0; temp_al; temp_al=temp_al->next, i++) {
#ifdef ENABLE_DATEBK
      ret=0;
      if (use_db3_tags) {
	 ret = db3_parse_tag(temp_al->ma.a.note, &db3_type, &db4);
	 jp_logf(JP_LOG_DEBUG, "category = 0x%x\n", db4.category);
	 cat_bit=1<<db4.category;
	 if (!(cat_bit & datebook_category)) {
	    i--;
	    jp_logf(JP_LOG_DEBUG, "skipping rec not in this category\n");
	    continue;
	 }
      }
#endif
      /* Do masking like Palm OS 3.5 */
      if ((show_priv == MASK_PRIVATES) && 
	  (temp_al->ma.attrib & dlpRecAttrSecret)) {
	 //mark_private=TRUE;
	 clear_myappointment(&temp_al->ma);
	 add_to_list(dvd);
	 //put up appt
	 entries_shown++;
	 continue;
      }
      /* End Masking */
      if ((show_priv != SHOW_PRIVATES) && 
	  (temp_al->ma.attrib & dlpRecAttrSecret)) {
	 i--;
	 continue;
      }

      entries_shown++;
      if (temp_al->ma.a.event) {
	 /* This is a timeless event */
      } else {
      }
//put up appt
      add_to_list(dvd);
      printf("adding\n");

/*      switch (temp_al->ma.rt) {
       case NEW_PC_REC:
       case REPLACEMENT_PALM_REC:
	 set_bg_rbg_clist(clist, i,
			  CLIST_NEW_RED, CLIST_NEW_GREEN, CLIST_NEW_BLUE);
	 break;
       case DELETED_PALM_REC:
	 set_bg_rbg_clist(clist, i,
			  CLIST_DEL_RED, CLIST_DEL_GREEN, CLIST_DEL_BLUE);
	 break;
       case MODIFIED_PALM_REC:
	 set_bg_rbg_clist(clist, i,
			  CLIST_MOD_RED, CLIST_MOD_GREEN, CLIST_MOD_BLUE);
	 break;
       default:
	 if (temp_al->ma.attrib & dlpRecAttrSecret) {
	    set_bg_rbg_clist(clist, i, 
			     CLIST_PRIVATE_RED, CLIST_PRIVATE_GREEN, CLIST_PRIVATE_BLUE);
	 } else {
	    gtk_clist_set_background(GTK_CLIST(clist), i, NULL);
	 }
      }
*/
#ifdef ENABLE_DATEBK
      if (use_db3_tags) {
	 if (db4.floating_event==DB3_FLOAT) {
	    get_pixmaps(scrolled_window, PIXMAP_FLOAT_CHECK, 
			&pixmap_float_check, &mask_float_check);
	    gtk_clist_set_pixmap(GTK_CLIST(clist), i, DB_FLOAT_COLUMN, pixmap_float_check, 
				 mask_float_check);
	 }
	 if (db4.floating_event==DB3_FLOAT_COMPLETE) {
	    get_pixmaps(scrolled_window, PIXMAP_FLOAT_CHECKED, 
			&pixmap_float_checked, &mask_float_checked);
	    gtk_clist_set_pixmap(GTK_CLIST(clist), i, DB_FLOAT_COLUMN, pixmap_float_checked, 
				 mask_float_checked);
	 }
      }
#endif

      has_note=0;
#ifdef ENABLE_DATEBK
      if (use_db3_tags) {
	 if (db3_type!=DB3_TAG_TYPE_NONE) {
	    if (db4.note) {
	       if (db4.note[0]!='\0') {
		  has_note = 1;
	       }
	    }
	 } else {
	    if (temp_al->ma.a.note) {
	       if (temp_al->ma.a.note[0]!='\0') {
		  has_note=1;
	       }
	    }
	 }
      } else {
	 if (temp_al->ma.a.note) {
	    if (temp_al->ma.a.note[0]!='\0') {
	       has_note=1;
	    }
	 }
      }
#else
      if (temp_al->ma.a.note) {
	 if (temp_al->ma.a.note[0]!='\0') {
	    has_note=1;
	 }
      }
#endif
      if (has_note) {
	 /*Put a note pixmap up */
	 get_pixmaps(scrolled_window, PIXMAP_NOTE, &pixmap_note, &mask_note);
	 gtk_clist_set_pixmap(GTK_CLIST(clist), i, DB_NOTE_COLUMN, pixmap_note, mask_note);
      }

      if (temp_al->ma.a.alarm) {
	 /*Put an alarm pixmap up */
	 get_pixmaps(scrolled_window, PIXMAP_ALARM,&pixmap_alarm, &mask_alarm);
	 gtk_clist_set_pixmap(GTK_CLIST(clist), i, DB_ALARM_COLUMN, pixmap_alarm, mask_alarm);
      }
   }

   /*If there is an item in the list, select the first one */
   if (i>0) {
      gtk_clist_select_row(GTK_CLIST(clist), 0, 1);
      cb_clist_selection(clist, 0, 1, (GdkEventButton *)455, "");
   } else {
      set_new_button_to(CLEAR_FLAG);
      clear_details();
   }

     {
	extern GtkTooltips *glob_tooltips;
	char str[82];
	g_snprintf(str, sizeof(str), _("%d of %d records"), entries_shown, num_entries);
	gtk_tooltips_set_tip(glob_tooltips, GTK_CLIST(clist)->column[DB_APPT_COLUMN].button, str, NULL);
     }
#endif
   return 0;
}
static gint cb_output_idle(gpointer data)
{
   GtkWidget *layout;

   layout=data;
   //printf("IDLE X_DRAW=%d\n", GTK_WIDGET(data)->allocation.width);//undo
   X_DRAW=GTK_WIDGET(data)->allocation.width; //undo
   /* Resize the drawing area */
   layout_draw_grid(layout);
   text_width = calc_text_width(layout);

   y_inc = (Y_DRAW - T_BORDER - B_BORDER) / NUM_HOURS;
   rect_width = X_DRAW-L_BORDER-R_BORDER-text_width;
   //printf("IDLE y_inc = %d\n", y_inc);//undo

   //gtk_layout_set_size(GTK_LAYOUT(layout), X_DRAW, Y_DRAW);

   layout_draw_grid(layout);

   /* returning false removes this handler from being called again */
   return FALSE;
}
gint button_press_event(GtkWidget      *widget,
			GdkEventButton *event,
			gpointer        data)
{
   gdouble x, y;
   int hour;
   x=event->x + gtk_scrolled_window_get_hadjustment(GTK_SCROLLED_WINDOW(scrolled_window))->value;
   y=event->y + gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrolled_window))->value;
   hour=(y-T_BORDER)/y_inc;
   printf("button press event %g %g\n", x, y);//undo
   printf("hour=%d\n", hour);
   return TRUE;
}

int create_daily_view(GtkWidget *scrolled_window_in, GtkWidget *vbox_no_time_appts)
{
   GtkWidget *layout;
   GtkStyle *style1;
   GtkStyle *style2;
   GdkColor color1;
   GdkColormap *colormap;
   GtkWidget *button;

   X_DRAW=text_width=y_inc=rect_width=0;
   scrolled_window = scrolled_window_in;

#ifdef ENABLE_GTK2
   gtk_window_set_screen(GTK_WINDOW(scrolled_window),
			 gtk_widget_get_screen(scrolled_window));
#endif

   layout = gtk_layout_new(NULL, NULL);
   glob_layout = layout;
   gtk_container_add(GTK_CONTAINER(scrolled_window), layout);

   GTK_LAYOUT(layout)->hadjustment->step_increment = 5.0;
   GTK_LAYOUT(layout)->vadjustment->step_increment = 5.0;

   gtk_signal_connect(GTK_OBJECT(layout), "destroy",
		      GTK_SIGNAL_FUNC(cb_layout_destroy), layout);
   
   gtk_widget_set_events(layout, GDK_EXPOSURE_MASK|GDK_BUTTON_PRESS_MASK);

   gtk_signal_connect(GTK_OBJECT(layout), "button_press_event",
		      GTK_SIGNAL_FUNC(button_press_event), layout);

#ifdef ENABLE_GTK2
   g_signal_connect(layout, "expose_event",
		    G_CALLBACK(layout_expose_handler), NULL);
#else
   gtk_signal_connect(GTK_OBJECT(layout), "expose_event",
		      GTK_SIGNAL_FUNC(layout_expose_handler), NULL);
#endif

   /* Make a background color and allocate it (white) */
   colormap = gtk_widget_get_colormap(layout);
   color1.red=0xFFFF;
   color1.green=0xFFFF;
   color1.blue=0xFFFF;
   gdk_color_alloc(colormap, &color1);

   /* Make a new style with a white background */
   style1 = gtk_widget_get_style(GTK_WIDGET(layout));
   style2 = gtk_style_copy(style1);
   style2->bg[0] = color1;
   gtk_widget_set_style(GTK_WIDGET(layout), style2);

   /* It should expand to fill in the X direction
    * (we don't know the proper width yet) */
   gtk_layout_set_size(GTK_LAYOUT(layout), 10, Y_DRAW);
   
   /* Because the scrolled window isn't drawn yet we can't see what size
    * it is.  So, we do it after it's drawn by doing this.
    */
   gtk_idle_add(cb_output_idle, layout);

   button = gtk_button_new_with_label("No Time Appt 1");
   gtk_box_pack_start(GTK_BOX(vbox_no_time_appts), button, FALSE, FALSE, 0);

   button = gtk_button_new_with_label("No Time Appt 2");
   gtk_box_pack_start(GTK_BOX(vbox_no_time_appts), button, FALSE, FALSE, 0);

   return 0;
}
