#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static int nonetrc = 0;

#define SUCCEED do {printf("found user %s\n", user); fclose(fp); return 0;} while (0)
#define BADFILE do {nonetrc = -1; fclose(fp); return -1;} while (0)
#define NOMATCH do {fclose(fp); return -1;} while (0)


static int
readtoken(FILE *fp, char *token, int tlen) {
	int c;
	int n = 0;

	token[0] = 0;
	while (n < tlen) {
		c = fgetc(fp);
		if (c == EOF) {
			if (token[0] == 0)
				return 0;
			else
				break;
		}
		if (c == ' ' || c == '\t' || c == '\n') {
			if (token[0] == 0)
				continue;
			else
				break;
		}
		token[n++] = (char) c;
	}
	token[n] = 0;
	return 1;
}

/*
 * netrc can contain the following keywords.  Here's what we do with them:
 *	machine: look at the next token, see if it matches <host>
 *	default: ignore, since there is no anonymous sftp
 *	login: return the next token if machine matches
 *	password: ignore for now, maybe use later
 *	account: ignore
 *	macdef: ignore
 */
int
netrc_user(char *host, char *user, int ulen) {
	char *home, path[256], token[100];
	FILE *fp;
	int inmatch = 0, ret;

	if (nonetrc)
		return -1;
	home = getenv("HOME");
	if (home == NULL || strlen(home) + strlen("/.netrc") > sizeof(path)) {
		nonetrc = 1;
		return -1;
	}
	sprintf(path, "%s/.netrc", home);
	fp = fopen(path, "r");
	if (fp == NULL) {
		nonetrc = 1;
		return -1;
	}
	while (!feof(fp)) {
		ret = readtoken(fp, token, sizeof(token));
		if (ret < 0)
			BADFILE;
		if (ret == 0)
			NOMATCH;
		if (strcasecmp(token, "machine") == 0) {
			ret = readtoken(fp, token, sizeof(token));
			if (ret <= 0)
				BADFILE;
			if (strcasecmp(host, token) == 0)
				inmatch = 1;
			else
				inmatch = 0;
		}
		else if (strcasecmp(token, "default") == 0) {
			/*
			 * must be after all machine statements, so we didn't
			 * find a match.
			 */
			NOMATCH;
		}
		else if (strcasecmp(token, "login") == 0) {
			ret = readtoken(fp, token, sizeof(token));
			if (ret <= 0)
				BADFILE;
			if (inmatch) {
				if (strlen(token) >= ulen)
					BADFILE;
				strcpy(user, token);
				SUCCEED;
			}
		}
		else if (strcasecmp(token, "password") == 0) {
			ret = readtoken(fp, token, sizeof(token));
			if (ret <= 0)
				BADFILE;
		}
		else if (strcasecmp(token, "account") == 0) {
			ret = readtoken(fp, token, sizeof(token));
			if (ret <= 0)
				BADFILE;
		}
		else if (strcasecmp(token, "macdef") == 0) {
			char line[80], *s;
			ret = readtoken(fp, token, sizeof(token));
			if (ret <= 0)
				BADFILE;
			s = fgets(line, sizeof(line), fp);
			if (s == NULL)
				BADFILE;
			while (1) {
				s = fgets(line, sizeof(line), fp);
				if (s == NULL)
					NOMATCH;
				if (s[0] == '\n')
					break;
			}
		}
		else
			BADFILE;
	}
	NOMATCH;
}
