%define name jftpgw
%define version 0.0.11
%define release 1
%define prefix /usr

Summary: An FTP proxy/gateway server
Summary(de): Ein FTP Proxy Server
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Network/Proxies
Source: http://www.mcknight.de/%{name}/%{name}-%{version}.tar.gz
URL: http://www.mcknight.de/%name/
Packager: Joachim Wieland <joe@mcknight.de>
Buildroot: /var/tmp/%{name}-%{version}-%{release}-root

%description

jftpgw is a proxy server for the FTP protocol. If it is running on a
machine, you can use a standard FTP client to connect to that machine. You
log in with remoteuser@destination with the password of the user on the
destination FTP server and the FTP session is forwarded from the `real' FTP
server to the jftpgw proxy and from there to your client. You can also
specify the destination port on the login string. jftpgw supports
passive/active FTP, access restrictions (based on source IP, target IP and
the user name), user rewriting and tries to drop its privileges as often as
possible. You can run jftpgw as a normal user as well.


%description -l de

jftpgw ist ein FTP proxy Server, der Verbindungen zwischen einem FTP Server
und einem FTP Client weiterleitet. Der FTP Client verbindet sich zu dem
jftpgw Rechner auf dessen Port und sendet den Usernamen im Format
"user@zielrechner", damit der Proxy sich als "user" auf dem Rechner
"zielrechner" einloggt und auch das Passwort weiterleitet. jftpgw
untersttzt aktive/passives FTP, Zugangsbeschrnkungen (basierend auf
Herkunfts-IP, Ziel-IP und Username), Ersetzung von Usernamen sowie das
Wechseln auf weniger berechtigte Benutzer. jftpgw kann auch von "normalen"
Benutzern ausgefhrt werden.


%prep
%setup
	
%build
CFLAGS=$RPM_OPT_FLAGS ./configure --prefix=%{prefix}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT
install jftpgw $RPM_BUILD_ROOT/usr/bin/jftpgw
cp jftpgw.access.sample /etc/jftpgw.access
cp jftpgw.conf.sample /etc/jftpgw.conf

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc COPYING README
/usr/bin/jftpgw

