#include "jftpgw.h"

const int tcp_proto = 6;

int openportiaddr(unsigned long addr, unsigned int port,
		  unsigned int localport, struct clientinfo* clntinfo) {
	struct sockaddr_in sin;
	memset((void*)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = addr;
	sin.sin_port = htons(port);
	return openport(sin, localport);
}

int openportaddr(char* addr, unsigned int port,
		 unsigned int localport, struct clientinfo* clntinfo) {
	int cs = clntinfo->clientsocket;
	struct sockaddr_in sin;
	unsigned long int iaddr = inet_addr(addr);

	if (iaddr == (unsigned long int) UINT_MAX
			&& strcmp(addr, BROADCAST)) {
		say(cs, "500 Invalid address to open");
		log(3, "The address %s is invalid", addr);
		return -1;
	}
	memset((void*)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = iaddr;
	sin.sin_port = htons(port);
	return openport(sin, localport);
}

int openportname(char* hostname, unsigned int port,
		 unsigned int localport, struct clientinfo* clntinfo) {
	struct hostent *host;
	char sendbuf[MAX_LINE_SIZE];
	int cs = clntinfo->clientsocket;
	struct sockaddr_in sin;
	memset((void*)&sin, 0, sizeof(sin));
	host = gethostbyname(hostname);
	if (!host) {
		log(3, "Could not look up %s", hostname);
		sprintf(sendbuf, "500 Could not look up %s\r\n", hostname);
		say(cs, sendbuf);
		return -1;
	}
	sin.sin_family = AF_INET;
	memcpy((void*)&sin.sin_addr.s_addr, (void*) host->h_addr,
			host->h_length);
	sin.sin_port = htons(port);
	return openport(sin, localport);
}

/* openport() connects to HOST on port PORT */

int openport(struct sockaddr_in sin,
	     unsigned int localport /*, struct clientinfo *clntinfo */) {
	int handle;
	int one = 1;
	struct sockaddr_in dp;
	
	if (localport && localport <= 1024 && getuid() == 0) {
		log(8, "Changing ID to root (bind to priv port)");
		changeid("root", UID);
	}

	handle = socket(AF_INET, SOCK_STREAM, tcp_proto);
	if (handle < 0) {
		log(2, "Error opening the socket: %s", strerror(errno));
		return -1;
	}
	
	if (localport) {
		setsockopt(handle, SOL_SOCKET, SO_REUSEADDR,
				(void*)&one, sizeof(one));
		memset((void*)&dp, 0, sizeof(dp));
		dp.sin_family = AF_INET;
		dp.sin_addr.s_addr = 0;
		dp.sin_port = htons(localport);

		if (bind(handle, (struct sockaddr*)&dp, sizeof(dp)) < 0) {
			int err = errno;
			if (getuid() == 0) {
				log(5, "Could not bind to the data port %d as root",
					localport);
				log(5, "Reason: %s", strerror(err));
			}
		}
		if (getuid() == 0) {
			log(8, "Changing back (bind to priv port)");
			changeid(get_option("runasuser"), EUID);
		}
	}
	
	if (connect(handle, (struct sockaddr*) &sin, sizeof(sin)) < 0) {
		log(1, "Error connecting: %s", strerror(errno));
	/*	say(cs, "500 Could not connect to the peer\r\n"); */
		return -1;
	}

	return handle;
}
	
/* openownport() binds to a free port on the own machine */

int openownport(struct sockaddr_in *sin, struct clientinfo* clntinfo,
		int whichaddr) {
#ifdef HAVE_SOCKLEN_T
	socklen_t slen;
#else
	int slen;
#endif
	int cs = clntinfo->clientsocket;
	int sd;

	if ((sd = socket(AF_INET, SOCK_STREAM, tcp_proto)) < 0) {
		log(1, "Could not create socket to bind to a free port: %s",
				strerror(errno));
		say(cs, "500 Could not create socket to bind to a free port\r\n");
		return -1;
	}
	memset((void*)sin, 0, sizeof(*sin));

	switch(whichaddr) {
		case SERVERADDR:
			sin->sin_addr.s_addr = clntinfo->serveraddr;
			break;
		case CLIENTADDR:
			sin->sin_addr.s_addr = clntinfo->clientaddr;
	}
	sin->sin_family = AF_INET;
	sin->sin_port = 0;

	if (bind(sd, (struct sockaddr*)sin, sizeof(struct sockaddr)) < 0) {
		log(2, "Could not bind to a free port: %s", strerror(errno));
		say(cs, "500 Could not bind to a free port\r\n");
		return -1;
	}
	if (listen(sd, 1) < 0) {
		log(2, "Could not listen on a free port: %s", strerror(errno));
		say(cs, "500 Could not listen on a free port\r\n");
		return -1;
	}

	/* re-read the socket data to get the actual port */
	
	slen = sizeof(struct sockaddr);
	if (getsockname(sd, (struct sockaddr*) sin, &slen) < 0) {
		log(2, "getsockname failed after binding to a free port: %s",
				strerror(errno));
		say(cs, "500 getsockname() failed after binding to a free port\r\n");
		return -1;
	}

	return sd;
}


unsigned long int get_our_addr_to(unsigned long int to_addr, unsigned int port) {

	int i;
	int sd;
	struct sockaddr_in sin;

	if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		log(3, "Cannot create socket to send UDP packet to the transparent proxy client");
		return -1;
	}
	sin.sin_family = AF_INET;
	sin.sin_port = port;
	sin.sin_addr.s_addr = to_addr;
	if (connect(sd, (struct sockaddr*) &sin, sizeof(sin)) < 0) {
		log(5, "Cannot connect to the transparent proxy client");
		return -1;
	}
	if (send(sd, "Hi", 2, 0) < 0) {
		log(5, "Cannot send sample text to the transparent proxy client");
		return -1;
	}
	i = sizeof(sin);
	if (getsockname(sd, (struct sockaddr*) &sin, &i) < 0) {
		log(2, "getsockname() failed to determine our IP (transparent proxy -> udp)");
		return -1;
	}
	close(sd);
	return sin.sin_addr.s_addr;
}

