% -*- mode: SLang -*-
%   file     : php.sl
%   author   : Mikael hultgren <micke@yeah.nu>
%   version  : 1.3
%
%   $Id: php.sl,v 1.175 2001/02/08 11:54:43 child Exp $
%
%   D e s c r i p t i o n %{{{
%   =-=-=-=-=-=-=-=-=-=-=
%   
%   This is a mode for editing php files in jed, hence the name phpmode :)
%    
%   The reason for this mode is that the only mode i
%   could find for editing php files under jed was one 
%   i found on dotfiles made by Eric Thelin. 
%   But it didn't work as i wanted, so i grabbed what i
%   could from it, and started from cmode as a template.
%   
%   At the moment it does keyword highlighting and proper
%   indenting, plus a slew of other functionality.
%
%   H o w  t o  u s e  t h i s  m o d e
%   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
%   
%   For private use:
%   Create a dir in you're home where you can store sl files for jed
%   myself i have ${HOME}/jed/lib
%
%   Then add this line to you're .jedrc somewhere at the top, prolly right after _debug_info=1;
%   ${HOME} = You're home dir.
%    
%      set_jed_library_path (strcat ("${HOME}/jed/lib",",", get_jed_library_path ()));
%      
%   remember to exchange the path above to where you put php.sl
% 
%   also  add these lines somewhere somewhere inside the if (BATCH == 0) block to avoid extra
%   parsing during batch jobs.
%   
%      autoload("php_mode", "php");
%      add_mode_for_extension("php","php");
%      add_mode_for_extension("php","php3");
%      add_mode_for_extension("php","inc");
%
%   You should also add the following lines to customize phpmode to you're .jedrc, but
%   it is not necessary since I've put in some reasonable defaults(TM) to start with.
%   
%   -------------------------------------------------------------------------------------------
%   PHP-mode variables:
%   -------------------------------------------------------------------------------------------
%   variable PHP_INDENT      = 4;       % Amount of space to indent within block.
%   variable PHP_BRACE       = 0;       % Amount of space to indent brace
%   variable PHP_BRA_NEWLINE = 0;       % If non-zero, insert a newline first before inserting 
%                                       % a '{'.
%   variable PHP_KET_NEWLINE = 0;       % If non-zero, insert a newline first before inserting 
%                                       % a '}'.
%   variable PHP_Colon_Offset = 1;      % Controls the indentation of case statements.
%   variable PHP_CONTINUED_OFFSET = 2;  % This variable controls the indentation of statements
%                                       % that are continued onto the next line.
%   variable PHP_Autoinsert_Comments = 1;
%   variable PHP_Class_Offset = 4;      % Controls the amount of indenting inside the class,
%                                       % doesn't apply to the braces
%   variable PHP_Switch_Offset = 0      % Controls the ammount of indention of switch statements.                                    
%  --------------------------------------------------------------------------------------------
%      
%   You should also consider byte compiling this file for better performance.
%
%   To do this go to the dir where you have php.sl, start up an empty buffer in jed, and
%   in there type this
%
%      byte_compile_file("php.sl", 0);
%
%   and then type 'evalbuffer' in the mini_buffer to the 'M-x' prompt.
%   Remember though that you need to be in the same dir as php.sl when you do this.
%   
%   D F A  h i g h l i g h t i n g
%   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
%   
%   DFA highlighting, works IMHO better now for phpmode than the standard mode,
%   but to make it work you need at least version 0.99.12 of jed and have it 
%   compiled into the binary.
%   
%   DFA highlighting wants to write it's cache file
%   into the standard jed library, which usually requires root
%   access, but you can set this to a alternative library with
%     
%     set_highlight_cache_dir("/path/to/some/place");
%     
%   this makes jed write ALL dfa cache files into this place instead,
%   pretty nice if you don't have root access.
%   If you for some reason can't write the DFA cache file to any dir, just comment out
%   this line
%   
%     dfa_enable_highlight_cache("php.dfa", "PHP");
%   
%   and phpmode will reparse the dfa syntax table each time it loads, can be
%   time consuming on lower end computers, but then you shouldn't use DFA syntax mode
%   anyway.
%
%     
%   T h a n k s  g o  o u t  t o
%   =-=-=-=-=-=-=-=-=-=-=-=-=-=-
%   
%    o Eric thelin <eric at thelin.org> for his phpmode that got me started.
%    o David <dstegbauer at post.cz>  who pointed out that php isn't in fact a
%      case sensitive language when it comes to
%      functions ;)
%    o Abraham vd Merwe <abz at blio.net> for his relentless bug-reporting,
%      feature suggestions and beta-tester.
%      Without him my to-do list would be
%      considerable shorter ;)
%    o cmode.sl in jed, without that this mode wouldn't be
%      nearly as feature rich as it is now.
%    o latex.sl for tips on how to do things.
%
%   N o n  r e p r o d u c i b l e
%   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
%   
%}}}

% Set all variables to a default value so people who forget to add
% them to their .jedrc doesnt get a error.
custom_variable ("PHP_Autoinsert_Comments", 0);
custom_variable ("PHP_INDENT", 4);
custom_variable ("PHP_BRA_NEWLINE", 0);
custom_variable ("PHP_KET_NEWLINE", 0);
custom_variable ("PHP_Colon_Offset", 1);
custom_variable ("PHP_CONTINUED_OFFSET", 2);
custom_variable ("PHP_Class_Offset", 4);
custom_variable ("PHP_BRACE", 0);
custom_variable ("PHP_Switch_Offset", 0);

#iftrue
% Return true if the spot is inside of a class definition
% Takes the opening brace of the enclosing block as an
% argument.
static define inside_class (bra) %{{{
{
	push_spot ();
	EXIT_BLOCK
	{
		pop_spot ();
	}
	
	goto_user_mark (bra);
	
	% Assume that class is at the beginning of a line.  We may want to
	% change this assumption later.
	while (re_bsearch ("^\\c[ \t]*\\<class\\>"))
	{
		if (0 == parse_to_point ())
		{
			while (fsearch ("{"))
			{
				if (0 != parse_to_point ())
				{
					go_right_1 ();
					continue;
				}
				
				if (bra == create_user_mark ())
				  return 1;
				break;
			}
			return 0;
		}
		
		!if (left(1))
		  break;
	}
	
	return 0;
} %}}}
#endif		  
static define php_is_comment () %{{{
{
	push_spot ();
	bol_skip_white ();
	0;
	if (looking_at ("//") or looking_at("#"))
	{
		pop ();
		what_column ();
	}
	pop_spot ();
}
%}}}
static define php_parse_to_point () %{{{
{
	parse_to_point ()
	  or php_is_comment ();
}
%}}}
static variable PHPmode_Fill_Chars = "";
define php_paragraph_sep () %{{{
{
	if (strlen (PHPmode_Fill_Chars)) return 0;
	push_spot ();
	bol_skip_white ();
	if (looking_at ("* ") or looking_at ("// ") or looking_at("# "))
	{
		go_right (2);
		skip_white ();
		if (looking_at ("@ ")) eol ();
	}
	
	eolp () or (-2 != parse_to_point ());
	pop_spot ();
}
%}}}
define php_format_paragraph () %{{{
{
	variable n, dwrap;
	
	PHPmode_Fill_Chars = "";
	if (php_paragraph_sep ()) return;
	push_spot (); push_spot (); push_spot ();
	while (not(php_paragraph_sep ()))
	{
		!if (up_1 ()) break;
	}
	if (php_paragraph_sep ()) go_down_1 ();
	push_mark ();
	pop_spot ();
	
	while (not(php_paragraph_sep ()))
	{
		!if (down_1 ()) break;
	}
	if (php_paragraph_sep ()) go_up_1 ();
	narrow ();
	pop_spot ();
	bol ();
	push_mark ();
	skip_white ();
	if (looking_at ("* ")) go_right (2);
	else if (looking_at ("// ")) go_right (3);
	else if (looking_at ("# ")) go_right (2);
	
	PHPmode_Fill_Chars = bufsubstr ();
	dwrap = what_column ();
	bob ();
	do 
	{
		bol_trim ();
		if (looking_at ("* ")) deln (2);
		else if (looking_at ("// ")) deln (3);
		else if (looking_at ("# ")) deln (2);
	}
	while (down_1 ());
	WRAP -= dwrap;
	call ("format_paragraph");
	WRAP += dwrap;
	bob ();
	do 
	{
		insert (PHPmode_Fill_Chars);
	}
	while (down_1 ());
	
	bol ();
	go_right (strlen (PHPmode_Fill_Chars));
	
	skip_white ();
	if (looking_at ("*/"))
	{
		push_mark ();
		bol_skip_white ();
		del_region ();
	}
	
	PHPmode_Fill_Chars = "";
	widen ();
	pop_spot ();
}
%}}}
define php_in_block () %{{{
{
	variable begin = 0, end = 0;	
	variable delim_start = "<?";
	variable delim_end   = "?>";
	variable delim_ASP_start = "<%";
	variable delim_ASP_end   = "%>";
	variable test;
	
	push_spot ();
	if (bolp())
	{
		if (looking_at(delim_start) or looking_at(delim_end) or looking_at(delim_ASP_start) or looking_at(delim_ASP_end))
		{
			pop_spot();
			return(1);
		}
	}
	
	if (looking_at(">"))
	{
		go_left (1);
		if (looking_at("?") or looking_at("%"))
		{
			pop_spot();
			return(1);
		}
	}
	
	forever
	{
		if (bsearch(delim_start) or bsearch(delim_ASP_start))
		{
			if (php_parse_to_point() == 0)
			{
				begin = what_line ();
				break;
			}
			continue;
		} else {
			break;
		}
	}
	
	pop_spot ();
	
	push_spot ();
	forever
	{
		if (bsearch(delim_end) or bsearch(delim_ASP_end))
		{
			if (php_parse_to_point() == 0)
			{
				end = what_line ();
				break;
			}
			continue;
		} else {
			break;
		}
	}
	
	pop_spot ();
	
	if (end < begin)
	{
		return(1);
	}
	return(0);
}
%}}}

%
% The comment functions have been superceded by those in comments.sl --JED
%
% define php_comment_uncomment_line () %{{{
% {
% 	push_spot ();
% 	bol ();
% 	if (looking_at ("//"))
% 	{
% 		deln (2);
% 		if (looking_at (" "))
% 		  del ();
% 	} else {
% 		insert ("// ");
% 	}
% 	pop_spot ();
% }
% %}}}

% define php_uncomment_region () %{{{
% {
% 	variable c = "//";
% 	variable len_c;
% 	len_c = strlen (c);

% 	narrow ();
% 	push_spot_bob ();
% 	bol_skip_white ();
% 	if (looking_at(c)) deln(len_c);
% 	if (looking_at (" "))
% 	  del ();
% 	while (1 == down (1))
% 	{
% 		bol_skip_white ();
% 		if (looking_at(c))
% 		  deln(len_c);
% 		if (looking_at (" "))
% 		  del ();
% 	}
% 	pop_spot ();
% 	widen ();
% }
% %}}}

% define php_comment_region () %{{{
% {
% 	variable c = "// ";
	
% 	push_spot ();
% 	ERROR_BLOCK
% 	{
% 		widen_region;
% 		pop_spot ();
% 	}
		
% 	narrow_to_region ();
% 	bob ();
% 	insert (c);

% 	while (down_1 ())
% 	{
% 		bol ();
% 		insert (c);
% 	}

% 	skip_white ();
% 	if (eolp)
% 	{
% 		delete_line ();
% 	}
% 	eob;
% 	insert (c);
% 	EXECUTE_ERROR_BLOCK;
% }
% %}}}


define php_top_of_function () %{{{
{
	push_spot ();
	variable current,end,start_brace;
	current = what_line;
	!if (re_bsearch("function[ \t]+[a-zA-Z_0-9]+[ \t]?\(.*\)"))
	{
		error ("Cant find top of function");
	}
	
	% Check to see if were in a comment
	if (php_parse_to_point())
	{
		pop_spot();
		error ("Cant find top of function");
	}
	
	!if (fsearch ("{"))
	{
		error ("Missing beginning brace of function.");
	}
	start_brace = what_line;
	if (start_brace > current)
	{
		pop_spot ();
		error ("Missing beginning brace of function.");
	}
	find_matching_delimiter('{');
	end = what_line;
	if (end < current)
	{
		pop_spot ();
		error ("Not in function");
	}
	find_matching_delimiter('}');
}
%}}}
define php_end_of_function () %{{{
{
	!if (bolp () and looking_at_char ('{'))
	  php_top_of_function ();
	call ("goto_match");
}
%}}}
define php_mark_function () %{{{
{
	php_end_of_function ();
	push_visible_mark ();
	eol ();
	exchange_point_and_mark ();
	php_top_of_function ();
	bol_skip_white ();
	if (looking_at ("{"))
	{
		go_up(1);
	}
	bol ();
}
%}}}
define php_mark_matching () %{{{
{
	push_spot ();
	if ( find_matching_delimiter (0) )
	{
		% Found one
		pop_spot ();
		push_visible_mark ();
		find_matching_delimiter (0);		
		exchange_point_and_mark ();
	} else {
		pop_spot ();
	}
}
%}}}
define php_bskip_over_comment () %{{{
{
	forever 
	{	
		bskip_chars (" \t\n");
		if (bobp ())
		  return;
		
		push_mark ();
		while (up_1 ())
		{	
			go_down_1 ();
			break;
		}
		
		bol_skip_white ();
		
		if (looking_at ("<?") or looking_at ("?>") or looking_at("<%") or looking_at("%>"))
		{
			pop_mark_0 ();
			continue;
		}
		pop_mark_1 ();
		
		!if (blooking_at ("*/"))
		{
			push_mark ();
			variable dooh = what_line();
			variable dooh2 = what_column();
			variable found = 0;
			forever
			{
				if (bfind ("//") or bfind("#"))
				{
					found = 1;
				} else {
					break;
				}
			}
			if (0 == parse_to_point () and found != 0)
			{
				% Not in a comment or string
				pop_mark_0 ();
				continue;
			}
			
			bol ();
			!if (bobp ())
			{
				if (looking_at ("<?") or looking_at ("?>") or looking_at("<%") or looking_at("%>"))
				{
					pop_mark_0 ();
					continue;
				}
			}			
			pop_mark_1 ();
			break;
		}
		!if (bsearch ("/*")) break;
	}
}
%}}}
static define php_looking_at (token) %{{{
{
	CASE_SEARCH = 0;
	variable cse = CASE_SEARCH, ret = 0;
	
	if (looking_at(token))
	{
		push_spot ();
		go_right(strlen(token));
		_get_point ();
		skip_chars ("\t :({");
		ret = (_get_point () - ()) or eolp();
		pop_spot ();
	}
	CASE_SEARCH = cse;
	ret;
}
%}}}
static define php_indent_to (n) %{{{
{
	bol ();
	% Force a reindent if the line does not contain tabs followed by spaces.
	skip_chars ("\t");
	skip_chars (" ");
	
	if ((what_column != n)
		or (_get_point () != (skip_white (), _get_point ())))
	{
		bol_trim ();
		n--;
		whitespace (n);
	}
}
%}}}
static define php_indent_continued_comment (col) %{{{
{
	push_spot ();
	col++;			       %  add 1 so the we indent under * in /*
	php_indent_to (col);
	
	if (looking_at ("*")
		or not (eolp ()))
	  pop_spot ();
	else
	{
		insert ("* ");
		pop_spot ();
		if (what_column () <= col)
		{
			goto_column (col + 2);
		}
	}
}
%}}}
static define php_mode_if_bol_skip_white () %{{{
{
	push_mark ();
	bskip_white ();
	1;
	if (bolp ())
	{
		pop ();
		skip_white ();
		0;
	}
	pop_mark (());		       %  take argument from stack
}
%}}}
define php_indent_line () %{{{
{	
	variable val, col, extra_indent = 0;
	variable prep_indent = 0, prep_line = 0;
	variable match_char, match_indent, this_char, match_line;
	variable match_mark;
	variable is_continuation = 0;
	
	% Check whetever we are in a php block or not
	if (php_in_block())
	{
		push_spot ();
		bol_skip_white ();
		
		% Store the character we are standing on
		this_char = what_char ();
		if (-2 == parse_to_point ())
		{
			% In a c comment.  Indent it at level of matching /* string
			() = bsearch ("/*");
			col = what_column ();
			pop_spot ();
			php_indent_continued_comment (col);
			php_mode_if_bol_skip_white ();
			return;
		}
		
		EXIT_BLOCK
		{
			php_mode_if_bol_skip_white ();
		}
		
		if (orelse
		  { php_looking_at("case") }
			{ php_looking_at("default") }
			)
		{
			if (ffind_char (':'))
			{
				extra_indent -= PHP_INDENT;
				% NOTE: This needs work.
				extra_indent += PHP_Colon_Offset;
			}
			bol ();
		} else {
			forever
			{
				php_bskip_over_comment ();
				!if (orelse
				   { blooking_at (";") }
					 { blooking_at ("{") }
					 { blooking_at ("}") }
					 { blooking_at ("),") }
					 { blooking_at ("},") }
					 { blooking_at (":") }
					 { bobp () }
					 )
				{	
					% This needs to be here to make sure were still in the phpblock
					if (php_in_block())
					{
						extra_indent += PHP_CONTINUED_OFFSET;					
						is_continuation++;
					}
				}
				
				!if (blooking_at (")"))
				  break;
				push_mark ();
				go_left_1 ();
				if (1 != find_matching_delimiter (')'))
				{
					pop_mark_1 ();
					break;
				}
				
				php_bskip_over_comment ();
				
				push_spot ();
				if ((1 == find_matching_delimiter (')')), pop_spot ())
				{
					pop_mark_1 ();
					break;
				}
				
				pop_mark_0 ();
				bol ();
			}
		}
		
		val = find_matching_delimiter (')');
		match_mark = create_user_mark ();
		
		match_char = what_char();
		match_line = what_line ();
		
		if ((val < 0) and looking_at ("/*"))
		  val = -2;
		else if (val == 1)
		{
			go_right (1);
			skip_white ();
		}
		
		col = what_column ();

		bol_skip_white ();
		match_indent = what_column ();
		if (what_line () < prep_line)
		{
			match_char = 0;
		}
		
		pop_spot ();
		
		switch (val)
		{
		 case 0:			       %  mismatch
			if (match_char == '{')
			{
				push_spot ();
				goto_user_mark (match_mark);
				
				bskip_chars ("\n\t ");				
				if (blooking_at (")"))
				{
					variable same_line = (what_line == match_line);
					
					go_left_1 ();
					if (1 == find_matching_delimiter (')'))
					{
						bol_skip_white ();
						
						if (same_line)
						  match_indent = what_column ();
						
						% NOTE: This needs work.
						if ((this_char != '}')
							and looking_at("switch"))
						  match_indent += PHP_Switch_Offset;
					}
				}
				
				pop_spot ();
				col = match_indent;
#ifexists PHP_Class_Offset
				if (this_char == '}')
				  col += PHP_INDENT;
				else if (inside_class (match_mark))
				  col += PHP_Class_Offset;
				else
				  col += PHP_INDENT;
#else
				col += PHP_INDENT;
#endif
				prep_indent = 0;
			} else if (match_char == '[') {
				php_indent_to (col + 1);
				return;
			} else {
				push_spot ();
				bol_skip_white ();
				if (looking_at_char ('{'))
				  extra_indent = PHP_BRACE;
				extra_indent++;
				php_indent_to (extra_indent + prep_indent);
				pop_spot ();				
				return;
			}
		}
		{
		case 1:
			extra_indent = 0;	       %  match found
		}
		{
		case -2:			       %  inside comment
			if (this_char != '\\') col++;
			php_indent_continued_comment (col);
			return;
		}
		{
		 case 2:
			push_spot_bol ();
			trim ();
			pop_spot ();
			return;
		}
		switch (this_char)
		{
			case '}':
				col -= PHP_INDENT;
		}
		{
		case '{':			
			col += PHP_BRACE;
			if (is_continuation)
			  col -= PHP_CONTINUED_OFFSET;
			col += extra_indent;
		}
		{
			col += extra_indent;
		}
		
		push_spot ();
		php_indent_to (col + prep_indent);
		pop_spot ();
	} else {
		% Not in PHP block
		insert("\t");
	}
	
}
%}}}
define php_indent_region () %{{{
{
	variable now,start,stop;
	check_region (1);
	stop = what_line ();
	pop_mark_1 ();
	start = what_line ();
	push_mark ();
	forever
	{
		now = what_line ();
		if (now >= stop)
		  break;
		php_indent_line();
		down_1 ();
	}
	pop_spot ();
}
%}}}
define php_indent_buffer () %{{{
{
	variable col, max_line;
	push_spot ();
	eob ();
	max_line = what_line ();
	bob ();
	do
	{
		bol_skip_white ();
		indent_line ();
	} while (down_1 ());
	
	trim_buffer ();
	flush (sprintf ("processed %d/%d lines.", what_line (), max_line));
	pop_spot ();
}
%}}}
define php_newline_and_indent () %{{{
{	
	variable PhpCcComment = "//";
	variable PhpBashComment = "#";
	
	if (bolp ())
	{
		newline ();
		php_indent_line ();
		return;
	}
	
	variable col;
	variable PhpCcComment_len = strlen (PhpCcComment);
	variable PhpBashComment_len = strlen (PhpBashComment);
	
	if (PHP_Autoinsert_Comments)
	{
		col = what_column ();
		push_spot_bol();
		if (looking_at(PhpCcComment))
		{
			push_mark ();
			go_right (PhpCcComment_len);
			skip_white ();
			PhpCcComment = bufsubstr ();
			pop_spot ();
			newline();
			if (col > PhpCcComment_len) insert(PhpCcComment);
			return;
		} else if (looking_at(PhpBashComment)) {
			push_mark ();
			go_right (PhpBashComment_len);
			skip_white ();
			PhpBashComment = bufsubstr ();
			pop_spot ();
			newline();
			if (col > PhpBashComment_len) insert(PhpBashComment);
			return;
		}		  
		pop_spot();
	}
	
	col = php_is_comment ();
	newline ();
	if (col)
	{
		php_indent_to (col);
		insert ("");
	}
	else php_indent_line ();
}
%}}}
define php_insert_bra () %{{{
{
	if (php_parse_to_point ())
	  insert_char ('{');
	else {
		push_spot ();
		php_bskip_over_comment (0);
		if (blooking_at (","), pop_spot ())
		{
			insert_char ('{');
		} else { 
			push_spot ();
			skip_white ();
			if (eolp ())
			{
				bskip_white ();
				if (not (bolp ()) and PHP_BRA_NEWLINE, pop_spot ()) newline ();
				push_spot ();
				bskip_white ();
				bolp ();	       %  on stack
				pop_spot ();
				insert_char ('{');
				if ( () ) php_indent_line ();   %  off stack
				eol ();
				if (PHP_BRA_NEWLINE) php_newline_and_indent ();
			} else  {
				pop_spot ();
				insert_char ('{');
			}
		}
	}
}
%}}}
define php_insert_ket () %{{{
{
	variable status = php_parse_to_point ();
	
	push_spot ();
	skip_white ();
	push_spot ();
	if (status 
		or not (eolp ())
		or (bol_skip_white (), looking_at_char ('{')), pop_spot ())
	{
		pop_spot ();
		if (PHP_KET_NEWLINE)
		{
			insert ("\n}");
			php_indent_line ();
		}
		else
		  insert ("}");
		blink_match ();
		return;
	}
	
	bskip_white ();
	if (bolp (), pop_spot ())
	{
		insert_char ('}');
		trim ();
	} else {
		eol ();
		if (PHP_KET_NEWLINE)
		  insert ("\n}");
		else
		  insert ("}");
	}
	php_indent_line ();
	eol (); 
	blink_match ();
	if (PHP_BRA_NEWLINE)
	  php_newline_and_indent ();
}
%}}}
define php_insert_colon () %{{{
{
	insert_char (':');
	!if (php_parse_to_point ())
	  php_indent_line ();
}
%}}}
define php_getname(tellstring) %{{{
{
	variable gname = read_mini(tellstring, Null_String, Null_String);
	return gname;
}
%}}}
define php_ins_tn (str) %{{{
{
	insert(str);
	php_indent_line();
	insert("\n");
}
%}}}
define php_insert_function () %{{{
{
	variable name = php_getname("function:");
	php_ins_tn(sprintf("function %s ()", name));
	php_ins_tn("{");
	php_ins_tn("");	
	php_ins_tn("}");
	bsearch(")");	
}
%}}}
define php_insert_class () %{{{
{
	variable name = php_getname("class:");
	php_ins_tn(sprintf("class %s", name));
	php_ins_tn("{");
	php_ins_tn("");	
	php_ins_tn("}");	
}
%}}}
define php_insert_tab () %{{{
{
	insert("\t");
}
%}}}
static define php_init_menu (menu) %{{{
{
	% menu_append_item (menu, "&Comment Region", "php_comment_region");
	% menu_append_item (menu, "&Uncomment Region", "php_uncomment_region");
	% menu_append_item (menu, "&Comment/Uncomment line", "php_comment_uncomment_line");
	% menu_append_separator (menu);
	menu_append_item (menu, "&Top of function", "php_top_of_function");
	menu_append_item (menu, "&End of function", "php_end_of_function");
	menu_append_item (menu, "&Mark function", "php_mark_function");
	menu_append_item (menu, "&Mark matching", "php_mark_matching");
	menu_append_separator (menu);
	menu_append_item (menu, "&Indent region", "php_indent_region");
	menu_append_item (menu, "&Indent buffer", "php_indent_buffer");
	menu_append_separator (menu);
	menu_append_item (menu, "&Insert class", "php_insert_class");
	menu_append_item (menu, "&Insert function", "php_insert_function");
	menu_append_item (menu, "&Insert brace", "php_insert_bra");
	menu_append_item (menu, "&Insert ket", "php_insert_ket");
	menu_append_item (menu, "&Insert colon", "php_insert_colon");
	menu_append_separator (menu);
	menu_append_item (menu, "&Format paragraph", "php_format_paragraph");
	menu_append_item (menu, "&Goto Match", "goto_match");
	menu_append_item (menu, "&Insert TAB", "php_insert_tab");
}
%}}}
$1 = "PHP";
!if (keymap_p ($1)) make_keymap ($1); %{{{
definekey ("indent_line", "\t", $1);
%definekey ("php_comment_region", "^X;", $1);
%definekey ("php_uncomment_region", "^X:", $1);
%definekey ("php_comment_uncomment_line", "\e;", $1);
definekey ("php_top_of_function", "\e^A", $1);
definekey ("php_end_of_function", "\e^E", $1);
definekey ("php_mark_function", "\e^H", $1);
definekey ("php_mark_matching", "\e^M", $1);
definekey ("php_insert_bra", "{", $1);
definekey ("php_insert_ket", "}", $1);
definekey ("php_insert_colon", ":", $1);
definekey ("php_format_paragraph", "\eq", $1);
definekey ("php_newline_and_indent", "\r", $1);

definekey_reserved ("php_indent_region", "^R", $1);
definekey_reserved ("php_indent_buffer", "^B", $1);
definekey_reserved ("php_insert_class", "^C", $1);
definekey_reserved ("php_insert_function", "^F", $1);
definekey_reserved ("php_insert_tab","^I", $1);
%}}}

% Now create and initialize the syntax tables. %{{{
create_syntax_table ($1);
define_syntax ("/*", "*/", '%', $1);          % comments
define_syntax ("#", "", '%', $1);             % comments
define_syntax ("//", "", '%', $1);            % comments
%define_syntax ("<>", '<', $1);
define_syntax ("([{", ")]}", '(', $1);        % parentheses
define_syntax ('"', '"', $1);                 % strings
define_syntax ('\'', '\'', $1);               % strings
define_syntax ('\\', '\\', $1);               % escape character
define_syntax ("0-9a-zA-Z_", 'w', $1);        % words
define_syntax ("-+0-9a-fA-F.xXL", '0', $1);   % numbers
define_syntax (",;.:", ',', $1);              % delimiters
define_syntax ("+-*/%=.&|^~<>!?@`", '+', $1); % operators
set_syntax_flags ($1, 0x05);
%}}}

#ifdef HAS_DFA_SYNTAX %{{{
% This table is the fist attempt to implement
% a good dfa syntax in phpmode, it is a first try
% so bear with me.

%%% DFA_CACHE_BEGIN %%%
static define setup_dfa_callback (name)
{
   dfa_enable_highlight_cache("php.dfa", name);
   dfa_define_highlight_rule("<%", "Qpreprocess", name);  % Asp style tags
   dfa_define_highlight_rule("%>", "Qpreprocess", name);  % Asp style tags
   dfa_define_highlight_rule("<\\?|<\\?php", "preprocess", name);
   dfa_define_highlight_rule("\\?>", "Qpreprocess", name);
   dfa_define_highlight_rule ("<!\\-\\-.*\\-\\-[ \t]*>", "Qcomment", name); % HTML comments
   dfa_define_highlight_rule ("<!\\-\\-", "comment", name); % HTML comments
   dfa_define_highlight_rule ("\\-\\-[ \t]*>", "comment", name); % HTML comments
   dfa_define_highlight_rule("//.*", "comment", name);
   dfa_define_highlight_rule("#.*", "comment", name);
   dfa_define_highlight_rule("/\\*.*\\*/", "Qcomment", name);
   dfa_define_highlight_rule("^([^/]|/[^\\*])*\\*/", "Qcomment", name);
   dfa_define_highlight_rule("/\\*.*", "comment", name);
   dfa_define_highlight_rule("^[ \t]*\\*+([ \t].*)?$", "comment", name);
   dfa_define_highlight_rule("[A-Za-z_\\$][A-Za-z_0-9\\$]*", "Knormal", name);
   dfa_define_highlight_rule("[ \t]+", "normal", name);
   dfa_define_highlight_rule("[0-9]+(\\.[0-9][LlUu]*)?([Ee][\\+\\-]?[0-9]*)?","number", name);
   dfa_define_highlight_rule("0[xX][0-9A-Fa-f]*[LlUu]*", "number", name);
   dfa_define_highlight_rule("[\\(\\[{}\\]\\),;\\.:]", "delimiter", name);
   dfa_define_highlight_rule("[%@\\?\\.\\-\\+/&\\*=<>\\|!~\\^]", "operator", name);
   dfa_define_highlight_rule("\"([^\"\\\\]|\\\\.)*\"", "string", name);
   dfa_define_highlight_rule("\"([^\"\\\\]|\\\\.)*\\\\?$", "string", name);
   dfa_define_highlight_rule("'([^'\\\\]|\\\\.)*'", "string", name);
   dfa_define_highlight_rule("'([^'\\\\]|\\\\.)*\\\\?$", "string", name);
   dfa_build_highlight_table(name);
}
dfa_set_init_callback (&setup_dfa_callback, "PHP");
%%% DFA_CACHE_END %%%
#endif
%}}}

% Type 0 keywords (keywords and constants) %{{{
() = define_keywords_n ($1,
"doifor",
2,0);

() = define_keywords_n ($1,
"andfornewvarxor",
3,0);

() = define_keywords_n ($1,
"argcargvcaseelsetrue",
4,0);

() = define_keywords_n ($1,
"breakclassfalsewhile",
5,0);

() = define_keywords_n ($1,
"elseifglobalphp_osswitch",
6,0);

() = define_keywords_n ($1,
"defaulte_errore_parseforeachglobals",
7,0);

() = define_keywords_n ($1,
"__file____line__continuee_noticefunctionphp_self",
8,0);

() = define_keywords_n ($1,
"e_warning",
9,0);

() = define_keywords_n ($1,
"php_version",
11,0);

() = define_keywords_n ($1,
"php_errormsg",
12,0);

() = define_keywords_n ($1,
"http_get_vars",
13,0);

() = define_keywords_n ($1,
"http_post_vars",
14,0);

() = define_keywords_n ($1,
"http_cookie_vars",
16,0);
%}}}

% Type 1 keywords (functions) %{{{
() = define_keywords_n ($1,
"dlpi",
2,1);

() = define_keywords_n ($1,
"abschrcosdiedirendexpkeylogmaxmd5minord"
+ "pospowsintan",
3,1);

() = define_keywords_n ($1,
"acosasinatanceilchopcopydateeachecho"
+ "eregevalexecexitfeoffilejoinleaklinklist"
+ "mailmsqlnextpackprevrandsortsqrtstattime"
+ "trim",
4,1);

() = define_keywords_n ($1,
"arrayasortatan2bcaddbcdivbcmodbcmul"
+ "bcpowbcsubchdirchgrpchmodchowncountcrypt"
+ "emptyeregifgetcfgetsflockfloorflushfopen"
+ "fputsfreadfseekftellgzeofhw_cphw_mvisset"
+ "ksortlog10lstatltrimmhashmkdirnl2brpopen"
+ "printrangeresetrmdirroundrsortsleepsplit"
+ "srandstrtrtouchumaskunsetusort",
5,1);

() = define_keywords_n ($1,
"arsortbccompbcsqrtbindecdblistdecbin"
+ "dechexdecoctdefinedeletefclosefflushfgetss"
+ "fwritegetenvgmdategzfilegzgetcgzgetsgzopen"
+ "gzputsgzreadgzseekgztellheaderhexdechw_who"
+ "ifx_dointvalis_diris_intkrsortmktimeoctdec"
+ "pclosepg_ttyprintfputenvrenamereturnrewind"
+ "sizeofsplitistrchrstrcmpstrlenstrposstrrev"
+ "strspnstrstrstrtokstrvalsubstrsyslogsystem"
+ "uasortuksortuniqidunlinkunpackusleep",
6,1);

() = define_keywords_n ($1,
"bcscalebin2hexcompactcurrentdbmopen"
+ "defineddirnameexplodeextractfgetcsvfilepro"
+ "ftp_getftp_putftp_pwdgetdategetmxrrgettype"
+ "gzclosegzgetssgzwritehw_infohw_rootimagesx"
+ "imagesyimplodeincludeis_fileis_linkis_long"
+ "is_nullis_realmt_randodbc_doopendiropenlog"
+ "pdf_arcpg_execpg_hostpg_portphpinforeaddir"
+ "requiresem_getsettypeshufflesnmpgetsnmpset"
+ "soundexsprintfstr_padstrcspnstristrstrrchr"
+ "strrpossymlinktempnamucfirstucwordsvirtual"
+ "yp_next",
7,1);

() = define_keywords_n ($1,
"ada_execbasenameclosedircloselog"
+ "constantcpdf_arcdba_opendba_syncdbmclose"
+ "dbmfetchfdf_openfdf_savefilesizefiletype"
+ "ftp_cdupftp_execftp_fgetftp_fputftp_mdtm"
+ "ftp_pasvftp_quitftp_sizegetmypidgetmyuid"
+ "gmmktimegzrewindhw_closehw_errorhw_mapid"
+ "imagearcimagegifimap_uidin_arrayis_array"
+ "is_floatldap_addlinkinfomt_srandob_start"
+ "ocierrorocifetchocilogonociparseora_bind"
+ "ora_execora_openpassthrupathinfopdf_clip"
+ "pdf_fillpdf_openpdf_rectpdf_savepdf_show"
+ "pg_closepg_tracereadfilereadlinksnmpwalk"
+ "strftimewordwrapyp_errnoyp_firstyp_match"
+ "yp_order",
8,1);

() = define_keywords_n ($1,
"ada_closearray_padarray_poparray_sum"
+ "checkdatecpdf_clipcpdf_fillcpdf_opencpdf_rect"
+ "cpdf_savecpdf_showcpdf_textdba_closedba_fetch"
+ "dba_popendbmdeletedbmexistsdbminsertdoubleval"
+ "error_logfdf_closefileatimefilectimefilegroup"
+ "fileinodefilemtimefileownerfilepermsfpassthru"
+ "fsockopenftp_chdirftp_loginftp_mkdirftp_nlist"
+ "ftp_rmdirgetrusagehw_insdochw_unlockicap_open"
+ "ifx_closeifx_errorifx_queryimagecharimagefill"
+ "imagelineimagewbmpimap_8bitimap_bodyimap_open"
+ "imap_pingimap_sortiptcparseis_doubleis_object"
+ "is_stringldap_bindldap_listldap_readmcal_open"
+ "metaphonemicrotimeocicommitocilogoffocinlogon"
+ "ociplogonociresultodbc_execora_closeora_error"
+ "ora_fetchora_logonora_parseparse_strparse_url"
+ "pdf_closepdf_scalepg_dbnamepg_loopenpg_loread"
+ "pg_resultphp_unamepreg_grepquotemetarewinddir"
+ "serializesetcookiesetlocaleswf_orthourldecode"
+ "urlencodevm_passwdxml_parseyp_master",
9,1);

() = define_keywords_n ($1,
"ada_afetchada_commitada_result"
+ "addslashesarray_diffarray_fliparray_keys"
+ "array_pusharray_randarray_walkaspell_new"
+ "checkdnsrrcpdf_closecpdf_scalecurl_errno"
+ "curl_errordba_deletedba_existsdba_insert"
+ "dbase_opendbase_packdbmnextkeydbmreplace"
+ "fdf_createfdf_set_apfrenchtojdftp_delete"
+ "ftp_renamegetlastmodgetmyinodegetrandmax"
+ "gmstrftimegzpassthruhw_connecthw_gettext"
+ "hw_inscollibase_bindicap_closeimagetypes"
+ "imap_checkimap_closeimap_msgnois_integer"
+ "jdtofrenchjdtojewishjdtojulianjewishtojd"
+ "juliantojdldap_closeldap_errnoldap_error"
+ "mcal_closemcrypt_cbcmcrypt_cfbmcrypt_ecb"
+ "mcrypt_ofbmsql_closemsql_errormsql_query"
+ "ociexecuteocinumcolsocinumrowsodbc_close"
+ "ora_commitora_logoffpdf_circlepdf_lineto"
+ "pdf_movetopdf_rotatepdf_strokepfsockopen"
+ "pg_connectpg_loclosepg_lowritepg_numrows"
+ "pg_optionspg_untracephpversionposix_kill"
+ "preg_matchpreg_quotepreg_splitreadgzfile"
+ "session_idsolid_execstr_repeatstrcasecmpstrip_tags"
+ "strtolowerstrtouppervm_adduser"
+ "vm_deluser",
10,1);

() = define_keywords_n ($1,
"ada_connectada_numrowsaddcslashes"
+ "apache_notearray_mergearray_shiftarray_slice"
+ "chunk_splitcpdf_circlecpdf_linetocpdf_moveto"
+ "cpdf_rotatecpdf_strokedba_nextkeydba_replace"
+ "dbase_closedbmfirstkeydebugger_oneaster_date"
+ "easter_daysfile_existsftp_connectftp_rawlist"
+ "ftp_systypeget_browserget_cfg_varhw_children"
+ "hw_edittexthw_errormsghw_identifyhw_pconnect"
+ "ibase_closeibase_queryicap_snoozeifx_connect"
+ "ifx_prepareimagecharupimagecreateimagepsbbox"
+ "imagepstextimagestringimap_alertsimap_append"
+ "imap_base64imap_binaryimap_deleteimap_errors"
+ "imap_headerimap_qprintimap_reopenimap_search"
+ "imap_statusis_readablejddayofweekjdmonthname"
+ "ldap_deleteldap_dn2ufnldap_get_dnldap_modify"
+ "ldap_searchldap_unbindmcal_snoozemhash_count"
+ "msql_dbnamemsql_dropdbmsql_resultmssql_close"
+ "mssql_querymysql_closemysql_errnomysql_error"
+ "mysql_queryocirollbackocirowcountodbc_commit"
+ "odbc_cursorodbc_resultpdf_curvetopdf_endpath"
+ "pdf_restorepdf_setdashpdf_setflatpdf_setgray"
+ "pdf_show_xypg_end_copypg_fieldnumpg_locreate"
+ "pg_loexportpg_loimportpg_lounlinkpg_pconnect"
+ "pg_put_lineposix_timesposix_unamerecode_file"
+ "sem_acquiresem_releasesnmpwalkoidsolid_close"
+ "sql_regcasestr_replacestrncasecmpunserialize"
+ "utf8_decodeutf8_encodevm_addaliasvm_delalias",
11,1);

() = define_keywords_n ($1,
"ada_fetchrowada_fieldnumada_rollback"
+ "array_splicearray_uniquearray_valuesaspell_check"
+ "base_convertcpdf_curvetocpdf_endpathcpdf_restore"
+ "cpdf_rlinetocpdf_rmovetocpdf_setdashcpdf_setflat"
+ "cpdf_setgraycpdf_show_xycurl_getinfodba_firstkey"
+ "dba_optimizedbase_createdebugger_offereg_replace"
+ "fdf_get_filefdf_set_filefunc_get_arggetimagesize"
+ "gettimeofdayhtmlentitieshw_getobjecthw_getremote"
+ "ifx_errormsgifx_get_blobifx_get_charifx_getsqlca"
+ "ifx_num_rowsifx_pconnectimagecoloratimagedestroy"
+ "imagepolygonimagettfbboximagettftextimap_expunge"
+ "imap_headersimap_num_msginclude_onceis_writeable"
+ "ldap_compareldap_connectldap_err2strldap_mod_add"
+ "ldap_mod_delmsql_connectmsql_drop_dbmsql_listdbs"
+ "msql_numrowsmsql_regcasemssql_resultmysql_result"
+ "ob_end_cleanob_end_flushocifetchintoocinewcursor"
+ "odbc_binmodeodbc_connectodbc_executeodbc_prepare"
+ "ora_commitonora_rollbackpdf_end_pagepdf_get_info"
+ "pdf_open_gifpdf_set_fontpg_cmdtuplespg_fetch_row"
+ "pg_fieldnamepg_fieldsizepg_fieldtypepg_loreadall"
+ "pg_numfieldsposix_getcwdposix_getgidposix_getpid"
+ "posix_getsidposix_getuidposix_isattyposix_mkfifo"
+ "posix_setgidposix_setsidposix_setuidpreg_replace"
+ "rawurldecoderawurlencoderequire_oncesession_name"
+ "shmop_attachshmop_detachshmop_removesimilar_text"
+ "solid_resultstripslashessybase_closesybase_query",
12,1);

() = define_keywords_n ($1,
"ada_fieldnameada_fieldtypeada_numfields"
+ "ada_resultallarray_reversearray_unshiftbase64_decode"
+ "base64_encodecpdf_end_textcpdf_finalizecpdf_set_font"
+ "diskfreespaceeregi_replacefdf_get_valuefdf_set_value"
+ "func_get_argsfunc_num_argsget_meta_tagsgetallheaders"
+ "gethostbyaddrgethostbynamegetservbynamegetservbyport"
+ "gregoriantojdhw_getanchorshw_getandlockhw_getparents"
+ "ibase_connectibase_executeibase_prepareibase_timefmt"
+ "ifx_copy_blobifx_fetch_rowifx_free_blobifx_free_char"
+ "imagecolorsetimageloadfontimagesetpixelimagestringup"
+ "imap_undeleteis_executablejdtogregorianmsql_createdb"
+ "msql_fieldlenmsql_list_dbsmsql_num_rowsmsql_pconnect"
+ "msql_selectdbmssql_connectmt_getrandmaxmysql_connect"
+ "mysql_drop_dbnumber_formatob_get_lengthocibindbyname"
+ "ocicolumnnameocicolumnsizeocicolumntypeocifreecursor"
+ "odbc_num_rowsodbc_pconnectodbc_rollbackora_commitoff"
+ "ora_errorcodeora_getcolumnpdf_closepathpdf_open_jpeg"
+ "pdf_put_imagepdf_translatepg_freeresultpg_getlastoid"
+ "posix_ctermidposix_getegidposix_geteuidposix_getpgid"
+ "posix_getpgrpposix_getppidposix_setpgidposix_ttyname"
+ "recode_stringsession_startshmop_get_varshmop_put_var"
+ "solid_connectsolid_numrowsstripcslashessybase_result"
+ "wddx_add_varsyp_err_string",
13,1);

() = define_keywords_n ($1,
"ada_autocommitada_freeresult"
+ "aspell_suggestclearstatcachecpdf_closepath"
+ "cpdf_page_initcpdf_set_titlecpdf_translate"
+ "escapeshellargescapeshellcmdfdf_get_status"
+ "fdf_set_statusgethostbynamelgetprotobyname"
+ "hw_childrenobjhw_docbyanchorhw_getusername"
+ "ibase_pconnectifx_fieldtypesifx_nullformat"
+ "ifx_num_fieldsimagecopymergeimagefontwidth"
+ "imageinterlaceimagerectangleimap_fetchbody"
+ "imap_mail_copyimap_mail_moveimap_subscribe"
+ "msql_create_dbmsql_data_seekmsql_fetch_row"
+ "msql_fieldnamemsql_fieldtypemsql_numfields"
+ "msql_select_dbmsql_tablenamemssql_num_rows"
+ "mssql_pconnectmysql_db_querymysql_list_dbs"
+ "mysql_num_rowsmysql_pconnectodbc_close_all"
+ "odbc_fetch_rowodbc_field_lenodbc_setoption"
+ "ora_columnnameora_columntypepdf_begin_page"
+ "pdf_setlinecappg_fetch_arraypg_fieldisnull"
+ "pg_fieldprtlenposix_getgrgidposix_getgrnam"
+ "posix_getloginposix_getpwnamposix_getpwuid"
+ "preg_match_allsession_decodesession_encode"
+ "set_time_limitsolid_fetchrowsolid_fieldnum"
+ "substr_replaceswf_definepolysybase_connect"
+ "xml_set_object",
14,1);

() = define_keywords_n ($1,
"array_intersectcpdf_begin_text"
+ "cpdf_setlinecapcreate_functiondbase_numfields"
+ "error_reportingfunction_existshw_array2objrec"
+ "hw_deleteobjecthw_documentsizehw_getchildcoll"
+ "hw_insertobjecthw_modifyobjecthw_new_document"
+ "hw_objrec2arrayhw_pipedocumentibase_fetch_row"
+ "ifx_create_blobifx_create_charifx_free_result"
+ "ifx_update_blobifx_update_charifxus_free_slob"
+ "ifxus_open_slobifxus_read_slobifxus_seek_slob"
+ "ifxus_tell_slobimagecolorexactimagedashedline"
+ "imagefontheightimagepsfreefontimagepsloadfont"
+ "imap_last_errorimap_num_recentldap_explode_dn"
+ "ldap_get_valuesldap_next_entrymcal_date_valid"
+ "mcal_event_initmcal_time_validmsql_field_seek"
+ "msql_fieldflagsmsql_fieldtablemsql_freeresult"
+ "msql_listfieldsmsql_listtablesmsql_num_fields"
+ "mssql_data_seekmssql_fetch_rowmssql_select_db"
+ "mysql_create_dbmysql_data_seekmysql_fetch_row"
+ "mysql_field_lenmysql_insert_idmysql_select_db"
+ "mysql_tablenameob_get_contentsocicolumnisnull"
+ "ocidefinebynameodbc_autocommitodbc_fetch_into"
+ "odbc_field_nameodbc_field_typeodbc_num_fields"
+ "odbc_result_allpdf_add_outlinepdf_close_image"
+ "pdf_fill_strokepdf_place_imagepdf_set_leading"
+ "pdf_setlinejoinpdf_setrgbcolorpdf_stringwidth"
+ "pg_errormessagepg_fetch_objectposix_getgroups"
+ "posix_getrlimitsession_destroyset_file_buffer"
+ "solid_fieldnamesolid_numfieldssybase_num_rows"
+ "sybase_pconnectwddx_packet_endxml_parser_free",
15,1);

() = define_keywords_n ($1,
"aspell_check_rawcpdf_add_outline"
+ "cpdf_fill_strokecpdf_import_jpegcpdf_set_creator"
+ "cpdf_set_leadingcpdf_set_subjectcpdf_setlinejoin"
+ "cpdf_setrgbcolorcpdf_stringwidthdbase_add_record"
+ "dbase_get_recorddbase_numrecordsextension_loaded"
+ "filepro_retrievefilepro_rowcountget_current_user"
+ "get_defined_varsgetprotobynumberhtmlspecialchars"
+ "hw_free_documenthw_getanchorsobjhw_getparentsobj"
+ "hw_incollectionsibase_free_queryicap_fetch_event"
+ "icap_list_alarmsicap_list_eventsicap_store_event"
+ "ifxus_close_slobifxus_write_slobimagecolorstotal"
+ "imagecopyresizedimagepalettecopyimap_fetchheader"
+ "imap_listmailboximap_scanmailboximap_unsubscribe"
+ "is_uploaded_fileldap_first_entryldap_free_result"
+ "ldap_get_entriesldap_mod_replacemcal_day_of_week"
+ "mcal_day_of_yearmcal_fetch_eventmcal_list_alarms"
+ "mcal_list_eventsmcal_store_eventmcrypt_create_iv"
+ "msql_fetch_arraymsql_fetch_fieldmsql_free_result"
+ "msql_list_fieldsmsql_list_tablesmssql_field_seek"
+ "mssql_num_fieldsmysql_field_namemysql_field_seek"
+ "mysql_field_typemysql_num_fieldsocifreestatement"
+ "ociinternaldebugocinewdescriptorociserverversion"
+ "ocistatementtypeodbc_free_resultodbc_longreadlen"
+ "pdf_set_durationpdf_set_text_pospdf_setgray_fill"
+ "pdf_setlinewidthsession_registershmop_remove_var"
+ "solid_freeresultsybase_data_seeksybase_fetch_row"
+ "sybase_select_dbwddx_deserializexml_error_string",
16,1);

() = define_keywords_n ($1,
"apache_lookup_uriconnection_status"
+ "cpdf_save_to_filecpdf_set_keywordscpdf_set_text_pos"
+ "cpdf_setgray_fillcpdf_setlinewidthfilepro_fieldname"
+ "filepro_fieldtypehw_docbyanchorobjhw_insertdocument"
+ "hw_outputdocumentibase_free_resulticap_delete_event"
+ "ifx_affected_rowsifx_byteasvarcharifx_textasvarchar"
+ "ifxus_create_slobignore_user_abortimagecolorclosest"
+ "imagecolorresolveimagefilltoborderimagegammacorrect"
+ "imagepsencodefontimap_getmailboxesimap_setflag_full"
+ "mcal_date_comparemcal_delete_eventmcal_is_leap_year"
+ "msql_fetch_objectmssql_fetch_arraymssql_fetch_field"
+ "mssql_free_resultmysql_change_usermysql_fetch_array"
+ "mysql_fetch_fieldmysql_field_flagsmysql_field_table"
+ "mysql_free_resultmysql_list_fieldsmysql_list_tables"
+ "ocifetchstatementpdf_continue_textpdf_execute_image"
+ "pdf_set_text_risepdf_setmiterlimitsession_save_path"
+ "set_error_handlersybase_field_seeksybase_num_fields"
+ "wddx_packet_startxml_parser_create",
17,1);

() = define_keywords_n ($1,
"array_count_valuesconnection_aborted"
+ "connection_timeoutconvert_cyr_stringcpdf_continue_text"
+ "cpdf_finalize_pagecpdf_output_buffercpdf_set_text_rise"
+ "cpdf_setmiterlimitfilepro_fieldcountfilepro_fieldwidth"
+ "hw_documentbodytaghw_documentcontenthw_getchildcollobj"
+ "hw_getchilddoccollhw_getsrcbydestobjifx_htmltbl_result"
+ "imagecolorallocateimagecreatefromgifimagecreatefromxbm"
+ "imagefilledpolygonimap_createmailboximap_deletemailbox"
+ "imap_getsubscribedimap_renamemailboxldap_count_entries"
+ "mcal_days_in_monthmcal_event_set_endmove_uploaded_file"
+ "msql_affected_rowsmssql_fetch_objectmysql_fetch_object"
+ "pdf_add_annotationpdf_set_info_titlepdf_set_transition"
+ "pdf_setgray_strokesession_unregistersybase_fetch_array"
+ "sybase_fetch_fieldsybase_free_resultxml_get_error_code",
18,1);

() = define_keywords_n ($1,
"cpdf_add_annotationcpdf_setgray_stroke"
+ "dbase_delete_recordfdf_next_field_namehw_getobjectbyquery"
+ "ifx_blobinfile_modeifx_fieldpropertiesimagecolorsforindex"
+ "imagecreatefromwbmpimap_clearflag_fullimap_fetchstructure"
+ "imap_listsubscribedimap_mailboxmsginfoldap_get_attributes"
+ "ldap_get_values_lenldap_next_attributemcrypt_get_key_size"
+ "mhash_get_hash_namemysql_affected_rowsmysql_escape_string"
+ "mysql_fetch_lengthspdf_set_info_authorpdf_set_text_matrix"
+ "session_module_nameset_socket_blockingsybase_fetch_object"
+ "wddx_serialize_vars",
19,1);

() = define_keywords_n ($1,
"call_user_func_array"
+ "cpdf_set_text_matrixdbase_replace_record"
+ "get_magic_quotes_gpchw_getremotechildren"
+ "imagecolorclosesthwbimagefilledrectangle"
+ "ldap_first_attributemcal_event_set_alarm"
+ "mcal_event_set_classmcal_event_set_start"
+ "mcal_event_set_titlemcal_next_recurrence"
+ "mhash_get_block_sizepdf_closepath_stroke"
+ "pdf_set_char_spacingpdf_set_info_creator"
+ "pdf_set_info_subjectpdf_set_word_spacing"
+ "pdf_setrgbcolor_fillsnmp_get_quick_print"
+ "snmp_set_quick_printsybase_affected_rows"
+ "wddx_serialize_value",
20,1);

() = define_keywords_n ($1,
"array_merge_recursive"
+ "cpdf_closepath_strokecpdf_set_char_spacing"
+ "cpdf_set_current_pagecpdf_set_word_spacing"
+ "cpdf_setrgbcolor_fillget_defined_functions"
+ "hw_documentattributeshw_documentsetcontent"
+ "hw_getchilddoccollobjimagecolortransparent"
+ "imagecreatefromstringmcrypt_get_block_size"
+ "pdf_open_memory_imagepdf_set_horiz_scaling"
+ "pdf_set_info_keywordsrestore_error_handler"
+ "session_cache_limitersession_is_registered"
+ "xml_parser_get_optionxml_parser_set_option"
+ "yp_get_default_domain",
21,1);

() = define_keywords_n ($1,
"cpdf_set_horiz_scaling"
+ "hw_getobjectbyqueryobjmcrypt_get_cipher_name"
+ "pdf_set_text_renderingpdf_setrgbcolor_stroke",
22,1);

() = define_keywords_n ($1,
"cpdf_place_inline_image"
+ "cpdf_set_page_animationcpdf_set_text_rendering"
+ "cpdf_setrgbcolor_strokehw_getobjectbyquerycoll"
+ "mcal_event_set_categoryquoted_printable_decode"
+ "xml_set_default_handlerxml_set_element_handler",
23,1);

() = define_keywords_n ($1,
"get_magic_quotes_runtime"
+ "set_magic_quotes_runtime",
24,1);

() = define_keywords_n ($1,
"imap_rfc822_parse_adrlist"
+ "imap_rfc822_write_addresspdf_closepath_fill_stroke",
25,1);

() = define_keywords_n ($1,
"cpdf_closepath_fill_stroke"
+ "get_html_translation_tablehw_getobjectbyquerycollobj"
+ "mcal_event_set_descriptionmcal_event_set_recur_daily"
+ "register_shutdown_functionxml_get_current_byte_index",
26,1);

() = define_keywords_n ($1,
"dbase_get_record_with_names"
+ "mcal_event_set_recur_weeklymcal_event_set_recur_yearly"
+ "xml_get_current_line_number",
27,1);

() = define_keywords_n ($1,
"xml_get_current_column_number"
+ "xml_set_notation_decl_handler",
29,1);

() = define_keywords_n ($1,
"xml_set_character_data_handler",
30,1);

() = define_keywords_n ($1,
"mcal_fetch_current_stream_event",
31,1);

() = define_keywords_n ($1,
"mcal_event_set_recur_monthly_mday"
+ "mcal_event_set_recur_monthly_wday",
33,1);

() = define_keywords_n ($1,
"xml_set_external_entity_ref_handler",
35,1);

() = define_keywords_n ($1,
"xml_set_unparsed_entity_decl_handler",
36,1);

() = define_keywords_n ($1,
"xml_set_processing_instruction_handler",
38,1);

%}}}

%!%+
%\function{php_mode}
%\synopsis{php_mode}
%\usage{Void php_mode ();}
%\description
% This is a mode that is dedicated to faciliate the editing of PHP language files.
% It calls the function \var{php_mode_hook} if it is defined. It also manages
% to recognice whetever it is in a php block or in a html block, for those people
% that doesnt seperate function from form ;)
%
% Functions that affect this mode include:
%#v+
%  function:             default binding:
%  php_comment_uncomment_line ESC ;
%  php_top_of_function        ESC Ctrl-A
%  php_end_of_function        ESC Ctrl-E
%  php_mark_function          ESC Ctrl-H
%  php_mark_matching          ESC Ctrl-M
%  php_indent_region          Ctrl-C Ctrl-R
%  php_indent_buffer          Ctrl-C Ctrl-B
%  php_insert_class           Ctrl-C Ctrl-C
%  php_insert_function        Ctrl-C Ctrl-F
%  php_insert_bra             {
%  php_insert_ket             }
%  php_insert_colon           :
%  php_format_paragraph       ESC q
%  indent_line                TAB
%  newline_and_indent         RETURN
%  goto_match                 Ctrl-\
%  php_insert_tab             Ctrl-C Ctrl-I
%#v-
% Variables affecting indentation include:
%#v+
% PHP_INDENT
% PHP_BRACE
% PHP_BRA_NEWLINE
% PHP_KET_NEWLINE
% PHP_Colon_Offset
% PHP_CONTINUED_OFFSET
% PHP_Class_Offset
% PHP_Autoinsert_Comments
% PHP_Switch_Offset
%#v-
% Hooks: \var{php_mode_hook}
%!%-
define php_mode ()
{
	variable kmap = "PHP";
	set_mode(kmap, 2);
	use_keymap(kmap);
	use_syntax_table (kmap);
	set_buffer_hook ("par_sep", "php_paragraph_sep");
	set_buffer_hook ("indent_hook", "php_indent_line");
	set_buffer_hook ("newline_indent_hook", "php_newline_and_indent"); 
	
	mode_set_mode_info ("PHP", "fold_info", "//{{{\r//}}}\r\r");
	mode_set_mode_info ("PHP", "init_mode_menu", &php_init_menu);	
	run_mode_hooks("php_mode_hook");
}
