%
%  Recall previous commands in MiniBuffer
%


static variable Max_Num_Lines = 32;
static variable Mini_Previous_Lines = String_Type [Max_Num_Lines];
% For 1.3.6+ use: Mini_Previous_Lines[*] = "";
Mini_Previous_Lines[[:]] = "";
static variable Mini_Last_Line = 0;
static variable Mini_First_Line = 0;
static variable Mini_Next_Line = 0;

static define mini_use_this_line ()
{
   erase_buffer ();
   insert (Mini_Previous_Lines[Mini_Next_Line]);
}


define next_mini_command ()
{
   variable line;

   if (Mini_Next_Line == Mini_Last_Line) 
     {
	error ("End of list!");
     }
   Mini_Next_Line++;
   % if (Mini_Next_Line == Max_Num_Lines)  Mini_Next_Line = 0;
   Mini_Next_Line = Mini_Next_Line mod Max_Num_Lines;
   mini_use_this_line ();
}

define prev_mini_command ()
{
   variable line;
   
   line = Mini_Next_Line;
   if (Mini_First_Line == Mini_Next_Line)
     error ("Top of list!");

   %Mini_Next_Line--;
   % if (Mini_Next_Line < 0)  Mini_Next_Line = 11;
   Mini_Next_Line = (Mini_Next_Line + Max_Num_Lines - 1) mod Max_Num_Lines;
   mini_use_this_line ();
}

define mini_exit_minibuffer ()
{
   bol_skip_white ();
   !if (eolp ())
     {
	Mini_Previous_Lines[Mini_Last_Line] = line_as_string ();
	Mini_Last_Line++;
	% if (Mini_Last_Line == Max_Num_Lines) Mini_Last_Line = 0;
	Mini_Last_Line = Mini_Last_Line mod Max_Num_Lines;
	if (Mini_Last_Line == Mini_First_Line)
	  {
	     Mini_First_Line++;
	     % if (Mini_First_Line == Max_Num_Lines) Mini_First_Line = 0;
	     Mini_First_Line = Mini_First_Line mod Max_Num_Lines;
	  }
     } 
   Mini_Next_Line = Mini_Last_Line;
   Mini_Previous_Lines[Mini_Last_Line] = "";
   call ("exit_mini");
}
