/*
 * @(#)MultipleMaster.java	1.13 98/10/19
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package java.awt.font;

import java.awt.Font;

/**
 * The <code>MultipleMaster</code> interface represents Type 1
 * Multiple Master fonts.
 * A particular {@link Font} object can implement this interface.
 * @version 10 Feb 1997    
 */
public interface MultipleMaster {

  /**
   * Returns the number of multiple master design controls.
   * Design axes include things like width, weight and optical scaling.
   * @return the number of multiple master design controls
   */
  public  int getNumDesignAxes();

  /**
   * Returns an array of design limits interleaved in the form [from->to]
   * for each axis.  For example,
   * design limits for weight could be from 0.1 to 1.0. The values are
   * returned in the same order returned by
   * <code>getDesignAxisNames</code>.
   * @return an array of design limits for each axis.
   */
  public  float[]  getDesignAxisRanges();

  /**
   * Returns an array of default design values for each axis.  For example,
   * the default value for weight could be 1.6. The values are returned
   * in the same order returned by <code>getDesignAxisNames</code>.
   * @return an array of default design values for each axis.
   */
  public  float[]  getDesignAxisDefaults();

  /**
   * Returns the name for each design axis. This also determines the order in
   * which the values for each axis are returned.
   * @return an array containing the names of each design axis.
   */
  public  String[] getDesignAxisNames();

  /**
   * Creates a new instance of a multiple master font based on the design
   * axis values contained in the specified array. The size of the array
   * must correspond to the value returned from 
   * <code>getNumDesignAxes</code> and the values of the array elements
   * must fall within limits specified by 
   * <code>getDesignAxesLimits</code>. In case of an error,
   * <code>null</code> is returned.
   * @param axes an array containing axis values
   * @return a {@link Font} object that is an instance of
   * <code>MultipleMaster</code> and is based on the design axis values
   * provided by <code>axes</code>.
   */
  public Font deriveMMFont(float[] axes);

  /**
   * Creates a new instance of a multiple master font based on detailed metric
   * information. In case of an error, <code>null</code> is returned.
   * @param glyphWidths an array of floats representing the desired width
   * of each glyph in font space
   * @param avgStemWidth the average stem width for the overall font in
   * font space
   * @param typicalCapHeight the height of a typical upper case char
   * @param typicalXHeight the height of a typical lower case char
   * @param italicAngle the angle at which the italics lean, in degrees
   * counterclockwise from vertical
   * @return a <code>Font</code> object that is an instance of 
   * <code>MultipleMaster</code> and is based on the specified metric
   * information.
   */
  public Font deriveMMFont(
				   float[] glyphWidths,
				   float avgStemWidth,
				   float typicalCapHeight,
				   float typicalXHeight,
				   float italicAngle);
 

}
