/*
 * @(#)ContainerEvent.java	1.8 98/09/21
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Component;

/**
 * A low-level event which indicates that a container's contents
 * changed because a component was added or removed.
 * <P>
 * Container events are provided for notification purposes ONLY;
 * The AWT will automatically handle changes to the containers
 * contents internally so that the program works properly regardless of
 * whether the program is receiving these events or not.
 * <P>
 * This low-level event is generated by a container object (such as a 
 * Panel) when a component is added to it or removed from it. 
 * The event is passed to every <code>ContainerListener</code>
 * or <code>ContainerAdapter</code> object which registered to receive such
 * events using the component's <code>addContainerListener</code> method.
 * (<code>ContainerAdapter</code> objects implement the 
 * <code>ContainerListener</code> interface.) Each such listener object 
 * gets this <code>ContainerEvent</code> when the event occurs.
 *
 * @see ContainerAdapter
 * @see ContainerListener
 * @see <a href="http://java.sun.com/docs/books/tutorial/post1.0/ui/containerlistener.html">Tutorial: Writing a Container Listener</a>
 * @see <a href="http://www.awl.com/cp/javaseries/jcl1_2.html">Reference: The Java Class Libraries (update file)</a>
 *
 * @version 1.8 09/21/98
 * @author Tim Prinzing
 * @author Amy Fowler
 */
public class ContainerEvent extends ComponentEvent {

    /**
     * The first number in the range of ids used for container events.
     */
    public static final int CONTAINER_FIRST		= 300;

    /**
     * The last number in the range of ids used for container events.
     */
    public static final int CONTAINER_LAST		= 301;

   /**
     * This event indicates that a component was added to the container.
     */
    public static final int COMPONENT_ADDED	= CONTAINER_FIRST;

    /**
     * This event indicates that a component was removed from the container.
     */
    public static final int COMPONENT_REMOVED = 1 + CONTAINER_FIRST;

    /**
     * The non-null component that is being added or
     * removed from the Container.
     *
     * @serial
     * @see getChild
     */
    Component child;

    /*
     * JDK 1.1 serialVersionUID 
     */
    private static final long serialVersionUID = -4114942250539772041L;

    /**
     * Constructs a ContainerEvent object.
     * 
     * @param source the Component object (container) that originated the event
     * @param id     an integer indicating the type of event
     * @param child  the component that was added or removed
     */
    public ContainerEvent(Component source, int id, Component child) {
        super(source, id);
        this.child = child;
    }

    /**
     * Returns the originator of the event.
     *
     * @return the Container object that originated the event
     */
    public Container getContainer() {
        return (Container)source; // cast should always be OK, type was checked in constructor
    }

    /**
     * Returns the component that was affected by the event.
     *
     * @return the Component object that was added or removed
     */
    public Component getChild() {
        return child;
    }

    /**
     * Returns a parameter string identifying this event.
     * This method is useful for event-logging and for debugging.
     *
     * @return a string identifying the event and its attributes
     */
    public String paramString() {
        String typeStr;
        switch(id) {
          case COMPONENT_ADDED:
              typeStr = "COMPONENT_ADDED";
              break;
          case COMPONENT_REMOVED:
              typeStr = "COMPONENT_REMOVED";
              break;
          default:
              typeStr = "unknown type";
        }
        return typeStr + ",child="+child.getName();
    }
}
