/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import sun.awt.im.iiimp.IIIMPWindow;
import sun.awt.im.iiimp.InputMethod;
import sun.awt.im.iiimp.InputMethodText;
import sun.awt.im.iiimp.StatusEvent;

class StatusWindow
extends IIIMPWindow {
    private static final int xMargin = 15;
    private static final int bottomMargin = 5;
    private static final int windowW = 80;
    private static final int windowH = 20;
    private StatusPane pane = null;
    private boolean isRoot = false;

    StatusWindow() {
    }

    Point calculatePopupPosition() {
        if (this.source == null) {
            return new Point(0, 0);
        }
        Container container = this.source instanceof Container ? (Container)this.source : this.source.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container == null) {
            return new Point(0, 0);
        }
        Container container2 = container;
        if (!container2.isVisible()) {
            return new Point(0, 0);
        }
        int n = container2.getBounds().width;
        int n2 = container2.getBounds().height;
        Point point = container2.getLocationOnScreen();
        Rectangle rectangle = this.win.getBounds();
        int n3 = rectangle.height;
        int n4 = rectangle.width;
        point.translate(0, n2);
        int n5 = point.y + n3 - IIIMPWindow.screenHeight;
        if (n5 > 0) {
            point.translate(0, n5 * -1);
        }
        point.translate(n - n4, 0);
        if (point.x < 0) {
            point.translate(point.x * -1, 0);
        }
        if ((n5 = point.x + n4 - IIIMPWindow.screenWidth) > 0) {
            point.translate(n5 * -1, 0);
        }
        return point;
    }

    void init() {
        String string = InputMethod.getProperty("iiimp.status.style");
        if (string.equals("root")) {
            this.isRoot = true;
        }
        this.win = new Window(new Frame());
        this.win.setForeground(Color.black);
        ((Component)this.win).setBackground(Color.lightGray);
        this.pane = new StatusPane();
        this.win.add(this.pane);
        ((Component)this.win).setBounds(15, IIIMPWindow.screenHeight - 20 - 5, 80, 20);
        ((Component)this.win).setVisible(true);
        this.win.pack();
    }

    synchronized void show(StatusEvent statusEvent) {
        Point point;
        if (this.source == null) {
            return;
        }
        if (this.win == null) {
            this.init();
        }
        this.pane.setData(statusEvent);
        this.pane.repaint();
        if (!this.isRoot && !(point = this.calculatePopupPosition()).equals(this.win.getLocation())) {
            ((Component)this.win).setLocation(point.x, point.y);
        }
        this.win.show();
    }

    class StatusPane
    extends Canvas {
        private StatusEvent event;

        StatusPane() {
            this.enableInputMethods(false);
        }

        public void paint(Graphics graphics) {
            if (this.event == null) {
                return;
            }
            String string = null;
            if (this.event.getType() == 0) {
                string = this.event.getString();
            } else if (this.event.getType() == 1) {
                InputMethodText inputMethodText = this.event.getText();
                string = inputMethodText.toString();
            }
            if (string == null) {
                return;
            }
            int n = graphics.getFontMetrics().stringWidth(string);
            Rectangle rectangle = StatusWindow.this.win.getBounds();
            if (n > rectangle.width) {
                ((Component)StatusWindow.this.win).setBounds(rectangle.x, rectangle.y, 30 + n, rectangle.height);
            }
            graphics.setColor(Color.darkGray);
            graphics.fillRect(rectangle.width - 2, 0, 2, rectangle.height);
            graphics.fillRect(0, rectangle.height - 2, rectangle.width, 2);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 2, rectangle.height);
            graphics.fillRect(0, 0, rectangle.width, 2);
            graphics.setColor(Color.black);
            graphics.drawString(string, 15, 14);
        }

        void setData(StatusEvent statusEvent) {
            this.event = statusEvent;
        }
    }
}

