/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.event.KeyEvent;
import java.io.IOException;
import sun.awt.im.iiimp.Data;
import sun.awt.im.iiimp.IIIMPKeyEvent;

class KeyEventData
extends Data {
    KeyEventData(KeyEvent keyEvent) throws IOException {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        long l = keyEvent.getWhen();
        this.write4(n);
        this.write4(c);
        this.write4(n2);
        this.write4((int)l);
    }

    KeyEventData(Data data) {
        super(data);
    }

    KeyEventData(byte[] byArray, int n) {
        super(byArray, n);
    }

    byte[] toByteStream() throws IOException {
        int n = 4;
        if (this.count == 0) {
            return null;
        }
        int n2 = Data.paddings(this.count);
        int n3 = this.count + n2;
        int n4 = 4 + this.count + n2;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.buf, 0, byArray, 4, this.count);
        byArray[0] = (byte)(this.count >>> 24 & 0xFF);
        byArray[1] = (byte)(this.count >>> 16 & 0xFF);
        byArray[2] = (byte)(this.count >>> 8 & 0xFF);
        byArray[3] = (byte)(this.count & 0xFF);
        int n5 = 4 + this.count;
        while (n5 < n4) {
            byArray[n5] = 0;
            ++n5;
        }
        this.pos = this.count;
        return byArray;
    }

    IIIMPKeyEvent[] toKeyEvents() throws IOException {
        IIIMPKeyEvent[] iIIMPKeyEventArray = null;
        int n = this.count / 16;
        if (n > 0) {
            iIIMPKeyEventArray = new IIIMPKeyEvent[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.read4();
                char c = (char)this.read4();
                int n4 = this.read4();
                int n5 = this.read4();
                iIIMPKeyEventArray[n2] = new IIIMPKeyEvent(n3, c, n4);
                ++n2;
            }
        }
        return iIIMPKeyEventArray;
    }
}

