/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import sun.awt.im.iiimp.IIIMPClient;
import sun.awt.im.iiimp.IIIMPIMValues;
import sun.awt.im.iiimp.IIIMPKeyEvent;
import sun.awt.im.iiimp.InputContext;
import sun.awt.im.iiimp.Util;

class InputMethod {
    private Vector ichList = new Vector();
    private Locale locale = null;
    private int id = -1;
    private Locale[] localeList = null;
    private IIIMPKeyEvent[] onKey = null;
    private IIIMPKeyEvent[] offKey = null;
    private boolean dynamic_event_flow = false;
    private boolean connected = false;
    private IIIMPClient client = IIIMPClient.getInstance();
    private static InputMethod im = null;
    private static InputMethod[] imList = null;
    private static Properties props = null;

    static {
        InputMethod.initializeProps();
    }

    InputMethod() {
        InputMethod.addInputMethod(this);
    }

    void addInputContextHandler(InputContext inputContext) {
        this.ichList.addElement(inputContext);
    }

    static void addInputMethod(InputMethod inputMethod) {
        InputMethod[] inputMethodArray;
        if (imList == null) {
            imList = new InputMethod[1];
            InputMethod.imList[0] = inputMethod;
            return;
        }
        int n = 0;
        while (n < imList.length) {
            inputMethodArray = imList[n];
            if (inputMethodArray == inputMethod) {
                return;
            }
            ++n;
        }
        inputMethodArray = new InputMethod[imList.length + 1];
        System.arraycopy(imList, 0, inputMethodArray, 0, imList.length);
        inputMethodArray[InputMethod.imList.length] = inputMethod;
        imList = inputMethodArray;
    }

    public void dispose() {
        try {
            this.client.closeIM(this.id);
            this.client = null;
        }
        catch (Exception exception) {}
        this.connected = false;
        InputMethod.removeInputMethod(this);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public Locale[] getAvailableLocales() {
        if (this.localeList == null) {
            return null;
        }
        Locale[] localeArray = new Locale[this.localeList.length];
        System.arraycopy(this.localeList, 0, localeArray, 0, this.localeList.length);
        return localeArray;
    }

    int getID() {
        return this.id;
    }

    public InputContext[] getInputContext() {
        if (this.ichList.size() == 0) {
            return null;
        }
        Object[] objectArray = new InputContext[this.ichList.size()];
        this.ichList.copyInto(objectArray);
        return objectArray;
    }

    InputContext getInputContext(int n) {
        int n2 = 0;
        while (n2 < this.ichList.size()) {
            InputContext inputContext = (InputContext)this.ichList.elementAt(n2);
            if (inputContext.getID() == n) {
                return inputContext;
            }
            ++n2;
        }
        return null;
    }

    static InputMethod[] getInputMethod() {
        InputMethod[] inputMethodArray = new InputMethod[imList.length];
        System.arraycopy(imList, 0, inputMethodArray, 0, imList.length);
        return inputMethodArray;
    }

    static InputMethod getInputMethod(int n) {
        if (InputMethod.imList[0].id == n) {
            return imList[0];
        }
        int n2 = 0;
        while (n2 < imList.length) {
            if (InputMethod.imList[n2].id == n) {
                return imList[n2];
            }
            ++n2;
        }
        return null;
    }

    public static InputMethod getInstance() {
        if (im == null) {
            im = new InputMethod();
        }
        return im;
    }

    static String getProperty(String string) {
        return props.getProperty(string);
    }

    static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    private static void initializeProps() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("iiimp.status.style", "client");
        props = new Properties(properties);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.home");
                String string2 = System.getProperty("user.home");
                try {
                    BufferedInputStream bufferedInputStream;
                    File file = new File(String.valueOf(string) + File.separator + "lib" + File.separator + "iiimp.properties");
                    if (file != null && file.canRead()) {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                        props.load(bufferedInputStream);
                        ((InputStream)bufferedInputStream).close();
                    }
                    if ((file = new File(String.valueOf(string2) + File.separator + ".iiimp")) != null && file.canRead()) {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                        props.load(bufferedInputStream);
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (Exception exception) {}
                return null;
            }
        });
    }

    boolean isConnected() {
        return this.connected;
    }

    boolean isConversionOffKey(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (this.offKey != null) {
            int n3 = 0;
            while (n3 < this.offKey.length) {
                if ((n & this.offKey[n3].modifier) != 0 && n2 == this.offKey[n3].keycode) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    boolean isConversionOnKey(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (this.onKey != null) {
            int n3 = 0;
            while (n3 < this.onKey.length) {
                if ((n & this.onKey[n3].modifier) != 0 && n2 == this.onKey[n3].keycode) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    boolean isDynamicEventFlow() {
        return this.dynamic_event_flow;
    }

    boolean isLocaleSupported(Locale locale) {
        if (this.localeList != null && this.localeList.length > 0) {
            int n = 0;
            while (n < this.localeList.length) {
                if (Util.localeEquals(locale, this.localeList[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    void lostConnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        InputContext[] inputContextArray = this.getInputContext();
        int n = 0;
        while (n < inputContextArray.length) {
            inputContextArray[n].lostConnect();
            ++n;
        }
    }

    boolean open(Locale locale) {
        if (!this.connected) {
            try {
                this.openIM();
            }
            catch (IOException iOException) {}
        }
        if (this.isLocaleSupported(locale)) {
            this.locale = locale;
            return true;
        }
        return false;
    }

    boolean openIM() throws IOException {
        if (this.connected) {
            return true;
        }
        IIIMPIMValues iIIMPIMValues = this.client.connectIM();
        if (iIIMPIMValues == null) {
            return false;
        }
        this.connected = true;
        this.id = iIIMPIMValues.id;
        this.dynamic_event_flow = iIIMPIMValues.dynamic_event_flow;
        this.onKey = iIIMPIMValues.onKey;
        this.offKey = iIIMPIMValues.offKey;
        this.localeList = iIIMPIMValues.localeList;
        return true;
    }

    void removeInputContextHandler(InputContext inputContext) {
        this.ichList.removeElement(inputContext);
    }

    static void removeInputMethod(InputMethod inputMethod) {
        InputMethod[] inputMethodArray;
        if (imList == null) {
            return;
        }
        int n = 0;
        while (n < imList.length) {
            inputMethodArray = imList[n];
            if (inputMethodArray == inputMethod) break;
            ++n;
        }
        if (n == imList.length) {
            return;
        }
        inputMethodArray = new InputMethod[imList.length - 1];
        int n2 = 0;
        n = 0;
        while (n < imList.length) {
            if (imList[n] != inputMethod) {
                inputMethodArray[n2++] = imList[n];
            }
            ++n;
        }
        imList = inputMethodArray;
    }

    boolean reopen(Locale locale) {
        if (!this.connected) {
            try {
                this.openIM();
            }
            catch (IOException iOException) {}
        }
        if (this.connected) {
            if (this.isLocaleSupported(locale)) {
                this.locale = locale;
                return true;
            }
            return false;
        }
        return false;
    }

    static String setProperty(String string, String string2) {
        return ((Hashtable)props).put(string, string2);
    }
}

