/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Locale;
import sun.awt.im.iiimp.AuxEvent;
import sun.awt.im.iiimp.AuxListener;
import sun.awt.im.iiimp.CommitEvent;
import sun.awt.im.iiimp.CommitListener;
import sun.awt.im.iiimp.ForwardEvent;
import sun.awt.im.iiimp.ForwardListener;
import sun.awt.im.iiimp.IIIMPClient;
import sun.awt.im.iiimp.IIIMPEvent;
import sun.awt.im.iiimp.IIIMPICValues;
import sun.awt.im.iiimp.InputMethod;
import sun.awt.im.iiimp.LocaleNotSupportedException;
import sun.awt.im.iiimp.LookupEvent;
import sun.awt.im.iiimp.LookupListener;
import sun.awt.im.iiimp.PreeditEvent;
import sun.awt.im.iiimp.PreeditListener;
import sun.awt.im.iiimp.StatusEvent;
import sun.awt.im.iiimp.StatusListener;
import sun.awt.im.iiimp.TriggerEvent;
import sun.awt.im.iiimp.TriggerListener;

class InputContext {
    private int id = 0;
    private Locale locale = null;
    private boolean active = false;
    private boolean convMode = false;
    private boolean isForwardEvent = false;
    private boolean connected = false;
    private InputMethod im = null;
    private static IIIMPClient client = IIIMPClient.getInstance();
    private boolean beingProcessed = false;
    CommitListener commitListener = null;
    int preeditBufferSize = 512;
    int preeditCaretPosition = 0;
    PreeditListener preeditListener = null;
    StatusListener statusListener = null;
    LookupListener lookupListener = null;
    AuxListener auxListener = null;
    ForwardListener forwardListener = null;
    TriggerListener triggerListener = null;

    InputContext() {
    }

    static /* synthetic */ boolean access$4(InputContext inputContext) {
        return inputContext.convMode;
    }

    public void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.setFocus(true);
    }

    void addAuxListener(AuxListener auxListener) {
        this.auxListener = auxListener;
    }

    public void addCommitStringListener(CommitListener commitListener) {
        this.commitListener = commitListener;
    }

    void addForwardListener(ForwardListener forwardListener) {
        this.forwardListener = forwardListener;
    }

    public void addLookupListener(LookupListener lookupListener) {
        this.lookupListener = lookupListener;
    }

    public void addPreeditListener(PreeditListener preeditListener) {
        this.preeditListener = preeditListener;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    void addTriggerListener(TriggerListener triggerListener) {
        this.triggerListener = triggerListener;
    }

    private void create(InputMethod inputMethod, Locale locale) {
        this.im = inputMethod;
        this.locale = locale;
        this.active = false;
        try {
            this.id = client.createIC(inputMethod.getID(), this.locale);
        }
        catch (Exception exception) {}
        this.connected = this.id != -1;
        this.addForwardListener(new ForwardPerform());
        this.addTriggerListener(new TriggerPerform());
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.setFocus(false);
    }

    private boolean deliverKeyEvent(KeyEvent keyEvent) {
        try {
            boolean bl = client.processKeyEvent(this.im.getID(), this.id, keyEvent);
            if (this.isForwardEvent) {
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.beingProcessed && (keyEvent.getID() == 400 || keyEvent.getID() == 402)) {
            keyEvent.consume();
            return;
        }
        this.beingProcessed = this.dispatchKeyEventImpl(keyEvent);
        if (this.beingProcessed) {
            keyEvent.consume();
        }
    }

    private boolean dispatchKeyEventImpl(KeyEvent keyEvent) {
        if (this.isConversionMode()) {
            if (this.isUninterestingModifiers(keyEvent)) {
                return true;
            }
            if (keyEvent.getID() == 400) {
                return !this.isForwardEvent;
            }
            if (keyEvent.getID() == 402) {
                return !this.isForwardEvent;
            }
        } else if (this.isUninterestingModifiers(keyEvent)) {
            return false;
        }
        if (!this.connected) {
            if (this.im.isConversionOnKey(keyEvent)) {
                if (this.im.reopen(this.locale) && this.reconnect()) {
                    this.activate();
                    this.setConversionMode(true);
                }
                return true;
            }
            return false;
        }
        if (this.isForwardEvent) {
            this.isForwardEvent = false;
        }
        if (this.im.isDynamicEventFlow()) {
            if (this.isConversionMode()) {
                if (this.im.isConversionOffKey(keyEvent)) {
                    this.setConversionMode(false);
                    return true;
                }
                return this.deliverKeyEvent(keyEvent);
            }
            if (this.im.isConversionOnKey(keyEvent)) {
                this.setConversionMode(true);
                return true;
            }
            return false;
        }
        return this.deliverKeyEvent(keyEvent);
    }

    public void dispose() {
        this.done();
        try {
            client.destroyIC(this.im.getID(), this.id);
        }
        catch (Exception exception) {}
        this.im.removeInputContextHandler(this);
    }

    private void done() {
        IIIMPEvent iIIMPEvent;
        if (!this.connected) {
            return;
        }
        if (this.lookupListener != null) {
            iIIMPEvent = new LookupEvent(this, 74);
            this.lookupListener.lookupDone((LookupEvent)iIIMPEvent);
        }
        if (this.preeditListener != null) {
            iIIMPEvent = new PreeditEvent(this, 46);
            this.preeditListener.preeditDone((PreeditEvent)iIIMPEvent);
        }
        if (this.commitListener != null) {
            iIIMPEvent = new CommitEvent(this, new String(""));
            this.commitListener.commitPerformed((CommitEvent)iIIMPEvent);
        }
        if (this.statusListener != null) {
            iIIMPEvent = new StatusEvent(this, 54, new String(""));
            this.statusListener.statusDraw((StatusEvent)iIIMPEvent);
            iIIMPEvent = new StatusEvent(this, 54);
            this.statusListener.statusDone((StatusEvent)iIIMPEvent);
        }
        this.active = false;
    }

    int getID() {
        return this.id;
    }

    public InputMethod getInputMethod() {
        return this.im;
    }

    public static InputContext getInstance(InputMethod inputMethod) throws LocaleNotSupportedException, IOException {
        return InputContext.getInstance(inputMethod, Locale.getDefault());
    }

    public static InputContext getInstance(InputMethod inputMethod, Locale locale) throws LocaleNotSupportedException, IOException {
        if (!inputMethod.isConnected()) {
            if (!inputMethod.open(locale)) {
                if (inputMethod.isConnected()) {
                    throw new LocaleNotSupportedException();
                }
                throw new IOException();
            }
        } else if (!inputMethod.isLocaleSupported(locale)) {
            throw new LocaleNotSupportedException();
        }
        InputContext inputContext = new InputContext();
        inputContext.create(inputMethod, locale);
        inputMethod.addInputContextHandler(inputContext);
        return inputContext;
    }

    private boolean isConversionMode() {
        return !this.connected ? false : this.convMode;
    }

    private boolean isUninterestingModifiers(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 157: {
                return true;
            }
        }
        return false;
    }

    void lostConnect() {
        if (this.connected) {
            this.done();
            this.connected = false;
            this.id *= -1;
        }
    }

    void processAuxEvent(AuxEvent auxEvent) {
        if (this.auxListener != null) {
            int n = auxEvent.getID();
            switch (n) {
                case 90: {
                    this.auxListener.auxStart(auxEvent);
                    break;
                }
                case 92: {
                    this.auxListener.auxDraw(auxEvent);
                    break;
                }
                case 94: {
                    this.auxListener.auxDone(auxEvent);
                    break;
                }
            }
        }
    }

    void processCommitEvent(CommitEvent commitEvent) {
        if (this.commitListener != null) {
            this.commitListener.commitPerformed(commitEvent);
        }
    }

    void processEvent(IIIMPEvent iIIMPEvent) {
        if (iIIMPEvent instanceof CommitEvent) {
            this.processCommitEvent((CommitEvent)iIIMPEvent);
            return;
        }
        if (iIIMPEvent instanceof PreeditEvent) {
            this.processPreeditEvent((PreeditEvent)iIIMPEvent);
            return;
        }
        if (iIIMPEvent instanceof StatusEvent) {
            this.processStatusEvent((StatusEvent)iIIMPEvent);
            return;
        }
        if (iIIMPEvent instanceof LookupEvent) {
            this.processLookupEvent((LookupEvent)iIIMPEvent);
            return;
        }
        if (iIIMPEvent instanceof AuxEvent) {
            this.processAuxEvent((AuxEvent)iIIMPEvent);
            return;
        }
        if (iIIMPEvent instanceof ForwardEvent) {
            this.processForwardEvent((ForwardEvent)iIIMPEvent);
            return;
        }
        if (iIIMPEvent instanceof TriggerEvent) {
            this.processTriggerEvent((TriggerEvent)iIIMPEvent);
            return;
        }
    }

    void processForwardEvent(ForwardEvent forwardEvent) {
        if (this.forwardListener != null) {
            this.forwardListener.forwardPerformed(forwardEvent);
        }
    }

    void processLookupEvent(LookupEvent lookupEvent) {
        if (this.lookupListener != null) {
            int n = lookupEvent.getID();
            switch (n) {
                case 70: {
                    this.lookupListener.lookupStart(lookupEvent);
                    break;
                }
                case 72: {
                    this.lookupListener.lookupDraw(lookupEvent);
                    break;
                }
                case 74: {
                    this.lookupListener.lookupDone(lookupEvent);
                    break;
                }
                case 76: {
                    this.lookupListener.lookupProcess(lookupEvent);
                    break;
                }
            }
        }
    }

    void processPreeditEvent(PreeditEvent preeditEvent) {
        if (this.preeditListener != null) {
            int n = preeditEvent.getID();
            switch (n) {
                case 40: {
                    this.preeditBufferSize = this.preeditListener.preeditStart(preeditEvent);
                    break;
                }
                case 42: {
                    this.preeditListener.preeditDraw(preeditEvent);
                    break;
                }
                case 44: {
                    this.preeditCaretPosition = this.preeditListener.preeditCaret(preeditEvent);
                    break;
                }
                case 46: {
                    this.preeditListener.preeditDone(preeditEvent);
                    break;
                }
            }
        }
    }

    void processStatusEvent(StatusEvent statusEvent) {
        if (this.statusListener != null) {
            int n = statusEvent.getID();
            switch (n) {
                case 50: {
                    this.statusListener.statusStart(statusEvent);
                    break;
                }
                case 52: {
                    this.statusListener.statusDraw(statusEvent);
                    break;
                }
                case 54: {
                    this.statusListener.statusDone(statusEvent);
                    break;
                }
            }
        }
    }

    void processTriggerEvent(TriggerEvent triggerEvent) {
        if (this.triggerListener != null) {
            this.triggerListener.triggerPerformed(triggerEvent);
        }
    }

    private boolean reconnect() {
        if (this.connected) {
            return true;
        }
        try {
            this.id = client.createIC(this.im.getID(), this.locale);
        }
        catch (Exception exception) {
            return false;
        }
        this.connected = true;
        return true;
    }

    void removeAuxListener() {
        this.auxListener = null;
    }

    public void removeCommitStringListener() {
        this.commitListener = null;
    }

    void removeForwardListener() {
        this.forwardListener = null;
    }

    public void removeLookupListener() {
        this.lookupListener = null;
    }

    public void removePreeditListener() {
        this.preeditListener = null;
    }

    public void removeStatusListener() {
        this.statusListener = null;
    }

    void removeTriggerListener(TriggerListener triggerListener) {
        this.triggerListener = null;
    }

    public void reset(boolean bl) {
        try {
            client.resetIC(this.im.getID(), this.id);
        }
        catch (Exception exception) {}
        if (!bl) {
            this.setConversionMode(false);
        }
    }

    void sendAuxData(int n, String string, int[] nArray, String[] stringArray) {
        try {
            client.sendAuxData(this.im.getID(), this.id, n, string, nArray, stringArray);
        }
        catch (Exception exception) {}
    }

    private void setConversionMode(boolean bl) {
        try {
            client.notifyTrigger(this.im.getID(), this.id, bl);
        }
        catch (Exception exception) {}
        this.convMode = bl;
    }

    private void setFocus(boolean bl) {
        try {
            client.setFocus(this.im.getID(), this.id, bl);
        }
        catch (Exception exception) {}
    }

    public boolean setLocale(Locale locale) {
        if (this.im.isLocaleSupported(locale)) {
            try {
                IIIMPICValues iIIMPICValues = new IIIMPICValues(locale);
                return client.setICValues(this.im.getID(), this.id, iIIMPICValues);
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    class ForwardPerform
    implements ForwardListener {
        ForwardPerform() {
        }

        public void forwardPerformed(ForwardEvent forwardEvent) {
            InputContext.this.isForwardEvent = true;
        }
    }

    class TriggerPerform
    implements TriggerListener {
        TriggerPerform() {
        }

        public void triggerPerformed(TriggerEvent triggerEvent) {
            if (!InputContext.this.connected || InputContext.this.isForwardEvent) {
                return;
            }
            if (InputContext.this.isConversionMode() == triggerEvent.status) {
                return;
            }
            InputContext.this.convMode = triggerEvent.status;
        }
    }
}

