/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.net.NetworkClient;

class IIIMPURLConnection
extends URLConnection {
    NetworkClient nc = new NetworkClient();

    protected IIIMPURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            final URL uRL = this.url;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, UnknownHostException {
                    IIIMPURLConnection.this.nc.openServer(uRL.getHost(), uRL.getPort());
                    return null;
                }
            });
            this.connected = true;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        this.nc.closeServer();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.nc.serverInput;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.nc.serverOutput;
    }

    public boolean isConnected() {
        return this.nc.serverIsOpen();
    }
}

