/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.IOException;
import sun.awt.im.iiimp.Data;
import sun.awt.im.iiimp.IIIMPInputMethodChar;
import sun.awt.im.iiimp.InputMethodChar;
import sun.awt.im.iiimp.InputMethodText;

class IIIMPInputMethodText
extends InputMethodText {
    IIIMPInputMethodText() {
        this.count = 0;
        this.value = new InputMethodChar[8];
    }

    void append(InputMethodChar inputMethodChar) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = inputMethodChar;
    }

    void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            InputMethodChar[] inputMethodCharArray = new InputMethodChar[n3];
            System.arraycopy(this.value, 0, inputMethodCharArray, 0, this.count);
            this.value = inputMethodCharArray;
        }
    }

    static InputMethodText toInputMethodText(Data data) throws IOException {
        int n = data.read4();
        if (n == 0) {
            return null;
        }
        return IIIMPInputMethodText.toInputMethodTextImpl(data, n);
    }

    private static InputMethodText toInputMethodTextImpl(Data data, int n) throws IOException {
        IIIMPInputMethodText iIIMPInputMethodText = new IIIMPInputMethodText();
        int n2 = data.pos + n;
        while (data.pos < n2) {
            IIIMPInputMethodChar iIIMPInputMethodChar = new IIIMPInputMethodChar();
            iIIMPInputMethodChar.c = (char)data.read2();
            int n3 = data.read2();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = data.read4();
                int n6 = data.read4();
                iIIMPInputMethodChar.addInputMethodFeedback(n5, n6);
                n4 += 8;
            }
            iIIMPInputMethodText.append(iIIMPInputMethodChar);
        }
        return iIIMPInputMethodText;
    }

    static InputMethodText[] toListOfInputMethodText(Data data) throws IOException {
        int n;
        int n2 = 26;
        int n3 = 26;
        InputMethodText[] inputMethodTextArray = new InputMethodText[26];
        int n4 = 0;
        while (data.available() != 0 && (n = data.read4()) != 0) {
            if (n4 == n3) {
                InputMethodText[] inputMethodTextArray2 = new InputMethodText[n3 + 26];
                System.arraycopy(inputMethodTextArray, 0, inputMethodTextArray2, 0, n3);
                inputMethodTextArray = inputMethodTextArray2;
                n3 += 26;
            }
            inputMethodTextArray[n4] = IIIMPInputMethodText.toInputMethodTextImpl(data, n);
            n = data.read4();
            if (n > 0) {
                data.skipBytes(n);
            }
            ++n4;
        }
        if (n4 > 0) {
            InputMethodText[] inputMethodTextArray3 = new InputMethodText[n4];
            System.arraycopy(inputMethodTextArray, 0, inputMethodTextArray3, 0, n4);
            return inputMethodTextArray3;
        }
        return null;
    }
}

