/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Locale;
import java.util.Vector;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodContext;
import sun.awt.im.iiimp.CommitEvent;
import sun.awt.im.iiimp.CommitListener;
import sun.awt.im.iiimp.InputContext;
import sun.awt.im.iiimp.InputMethod;
import sun.awt.im.iiimp.InputMethodCaret;
import sun.awt.im.iiimp.InputMethodChar;
import sun.awt.im.iiimp.InputMethodLookupStart;
import sun.awt.im.iiimp.InputMethodPreeditText;
import sun.awt.im.iiimp.InputMethodText;
import sun.awt.im.iiimp.LookupEvent;
import sun.awt.im.iiimp.LookupListener;
import sun.awt.im.iiimp.LookupWindow;
import sun.awt.im.iiimp.PreeditEvent;
import sun.awt.im.iiimp.PreeditListener;
import sun.awt.im.iiimp.StatusEvent;
import sun.awt.im.iiimp.StatusListener;
import sun.awt.im.iiimp.StatusWindow;

public class IIIMPAdapter
extends InputMethodAdapter {
    private static final Object LOCK = new Object();
    private static InputMethod im = null;
    private static LookupWindow lookup = null;
    private static StatusWindow status = null;
    private InputContext ic = null;
    private boolean createICFailed = false;
    private Component client = null;
    private String committedText = null;
    private Vector composedText = new Vector();

    public IIIMPAdapter() throws AWTException {
        Object object = LOCK;
        synchronized (object) {
            if (im == null) {
                im = InputMethod.getInstance();
            }
            if (lookup == null) {
                lookup = new LookupWindow();
            }
            if (status == null) {
                status = new StatusWindow();
            }
        }
        boolean bl = false;
        try {
            bl = im.openIM();
        }
        catch (Exception exception) {
            Object object2 = LOCK;
            synchronized (object2) {
                im.dispose();
                im = null;
                lookup = null;
                status = null;
            }
            throw new AWTException("can't find the IIIMP server");
        }
        if (!bl) {
            throw new AWTException("can't connect the IIIMP server");
        }
    }

    public synchronized void activate() {
        InputContext inputContext;
        if (this.createICFailed) {
            return;
        }
        this.client = this.getClientComponent();
        if (this.ic == null && !this.createIC(Locale.getDefault())) {
            return;
        }
        if (lookup.isShowing() && this.client != lookup.getComponent() && (inputContext = lookup.getInputContext()) != null) {
            inputContext.reset(false);
        }
        this.ic.activate();
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n) {
        InputMethodHighlight inputMethodHighlight;
        switch (n) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    private boolean createIC(Locale locale) {
        try {
            this.ic = InputContext.getInstance(im, locale);
            this.ic.addCommitStringListener(new Commit());
            this.ic.addLookupListener(new Lookup());
            this.ic.addStatusListener(new Status());
            this.ic.addPreeditListener(new Preedit());
        }
        catch (Exception exception) {
            this.createICFailed = true;
            return false;
        }
        return true;
    }

    public synchronized void deactivate(boolean bl) {
        if (this.ic != null) {
            this.ic.deactivate();
        }
        status.hide();
    }

    private synchronized void dispatchCommittedText(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.composedText.isEmpty()) {
            AttributedString attributedString = new AttributedString(string);
            this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null);
        } else {
            this.committedText = string;
        }
    }

    public synchronized void dispatchEvent(AWTEvent aWTEvent) {
        if (this.ic == null || !(aWTEvent instanceof KeyEvent)) {
            return;
        }
        this.ic.dispatchKeyEvent((KeyEvent)aWTEvent);
    }

    public synchronized void dispose() {
        if (this.ic != null) {
            this.ic.dispose();
            this.ic = null;
            im.getInputContext();
        }
        status.hide();
        status.done();
        lookup.hide();
        lookup.done();
    }

    public void endComposition() {
        if (this.ic != null) {
            this.ic.reset(false);
        }
    }

    public void finalize() {
        if (this.ic != null) {
            this.ic.dispose();
            this.ic = null;
            im.getInputContext();
        }
    }

    private AttributedString getAttributedString() {
        if (this.composedText.isEmpty()) {
            return new AttributedString("");
        }
        Object[] objectArray = new ComposedChar[this.composedText.size()];
        this.composedText.copyInto(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(((ComposedChar)objectArray[n]).c);
            ++n;
        }
        AttributedString attributedString = new AttributedString(stringBuffer.toString());
        int n2 = 0;
        int n3 = 0;
        InputMethodHighlight inputMethodHighlight = ((ComposedChar)objectArray[0]).attr;
        while (n3 < objectArray.length) {
            InputMethodHighlight inputMethodHighlight2 = ((ComposedChar)objectArray[n3]).attr;
            if (inputMethodHighlight2 != inputMethodHighlight) {
                if (inputMethodHighlight != null) {
                    attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n2, n3);
                }
                inputMethodHighlight = inputMethodHighlight2;
                n2 = n3;
            }
            ++n3;
        }
        if (inputMethodHighlight != null) {
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n2, n3);
        }
        return attributedString;
    }

    public static Locale[] getAvailableLocales() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (im == null) {
                im = InputMethod.getInstance();
            }
        }
        try {
            if (!im.openIM()) {
                return null;
            }
            return im.getAvailableLocales();
        }
        catch (IOException iOException) {
            Object object2 = LOCK;
            synchronized (object2) {
                im.dispose();
                im = null;
            }
            throw iOException;
        }
    }

    public Object getControlObject() {
        return null;
    }

    private InputMethodContext getInputContext() {
        return ((sun.awt.im.InputMethod)this).inputContext;
    }

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        ((sun.awt.im.InputMethod)this).inputContext.dispatchInputMethodEvent(n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
    }

    public synchronized void removeNotify() {
        if (this.composedText != null) {
            this.composedText.setSize(0);
        }
        this.dispose();
        this.client = null;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public synchronized boolean setLocale(Locale locale) {
        if (locale == null) {
            return false;
        }
        if (this.ic == null) {
            return this.createIC(locale);
        }
        return this.ic.setLocale(locale);
    }

    private class ComposedChar {
        char c;
        InputMethodHighlight attr;

        ComposedChar() {
        }
    }

    class Commit
    implements CommitListener {
        Commit() {
        }

        public void commitPerformed(CommitEvent commitEvent) {
            String string = null;
            if (commitEvent.getType() == 0) {
                string = commitEvent.getString();
            } else if (commitEvent.getType() == 1) {
                InputMethodText inputMethodText = commitEvent.getText();
                string = inputMethodText.toString();
            }
            IIIMPAdapter.this.dispatchCommittedText(string);
        }
    }

    class Lookup
    implements LookupListener {
        Lookup() {
        }

        public void lookupDone(LookupEvent lookupEvent) {
            lookup.hide();
            lookup.done();
            Component component = lookup.getComponent();
            if (component != null) {
                component.requestFocus();
            }
        }

        public void lookupDraw(LookupEvent lookupEvent) {
            lookup.setComponent(IIIMPAdapter.this.client);
            lookup.setInputContext(lookupEvent.getInputContext());
            InputMethodContext inputMethodContext = IIIMPAdapter.this.getInputContext();
            if (inputMethodContext != null && !IIIMPAdapter.this.composedText.isEmpty()) {
                Rectangle rectangle = inputMethodContext.getTextLocation(TextHitInfo.leading(0));
                int n = rectangle.x;
                int n2 = rectangle.y;
                int n3 = 0;
                int n4 = 0;
                int n5 = IIIMPAdapter.this.composedText.size();
                if (n5 > 0) {
                    rectangle = inputMethodContext.getTextLocation(TextHitInfo.leading(n5));
                    n3 = rectangle.x;
                    n4 = rectangle.y;
                }
                if (n4 > n2) {
                    n = n3;
                    n2 = n4;
                }
                lookup.setLocation(n, n2);
            }
            lookup.show(lookupEvent);
        }

        public void lookupProcess(LookupEvent lookupEvent) {
        }

        public void lookupStart(LookupEvent lookupEvent) {
            InputMethodLookupStart inputMethodLookupStart = lookupEvent.getStart();
            lookup.setRowCol(inputMethodLookupStart.getRows(), inputMethodLookupStart.getColumns());
        }
    }

    class Status
    implements StatusListener {
        Status() {
        }

        public void statusDone(StatusEvent statusEvent) {
            status.done();
            if (!im.isConnected()) {
                status.hide();
            }
        }

        public void statusDraw(StatusEvent statusEvent) {
            status.show(statusEvent);
        }

        public void statusStart(StatusEvent statusEvent) {
            status.setComponent(IIIMPAdapter.this.client);
            status.setInputContext(statusEvent.getInputContext());
        }
    }

    class Preedit
    implements PreeditListener {
        int caretPos = 0;

        Preedit() {
        }

        int dispatchCaretPosition(int n) {
            this.caretPos = n;
            IIIMPAdapter.this.postInputMethodEvent(1101, null, 0, TextHitInfo.leading(this.caretPos), null);
            return this.caretPos;
        }

        synchronized void dispatchComposedText(PreeditEvent preeditEvent) {
            int n;
            int n2;
            InputMethodPreeditText inputMethodPreeditText = preeditEvent.getPreeditText();
            InputMethodText inputMethodText = inputMethodPreeditText.getText();
            int n3 = inputMethodPreeditText.getPosition();
            int n4 = inputMethodPreeditText.getFirstChangedPosition();
            int n5 = inputMethodPreeditText.getTextChangedLength();
            if (inputMethodText == null) {
                n2 = n4 + n5 - 1;
                while (n2 >= n4) {
                    if (!IIIMPAdapter.this.composedText.isEmpty()) {
                        IIIMPAdapter.this.composedText.removeElementAt(n2);
                    }
                    --n2;
                }
            } else {
                if (n5 > 0) {
                    n2 = n4 + n5 - 1;
                    while (n2 >= n4) {
                        if (!IIIMPAdapter.this.composedText.isEmpty()) {
                            IIIMPAdapter.this.composedText.removeElementAt(n2);
                        }
                        --n2;
                    }
                }
                n2 = inputMethodText.count;
                n = n4;
                int n6 = 0;
                while (n < n4 + n2) {
                    InputMethodChar inputMethodChar = inputMethodText.value[n6];
                    ComposedChar composedChar = new ComposedChar();
                    composedChar.c = inputMethodChar.c;
                    composedChar.attr = IIIMPAdapter.this.convertVisualFeedbackToHighlight(inputMethodChar.fd[0].value);
                    IIIMPAdapter.this.composedText.insertElementAt(composedChar, n);
                    ++n;
                    ++n6;
                }
            }
            if (IIIMPAdapter.this.composedText.isEmpty()) {
                if (IIIMPAdapter.this.committedText == null) {
                    IIIMPAdapter.this.postInputMethodEvent(1100, null, 0, null, null);
                } else {
                    IIIMPAdapter.this.dispatchCommittedText(IIIMPAdapter.this.committedText);
                    IIIMPAdapter.this.committedText = null;
                }
                return;
            }
            n2 = 0;
            if (IIIMPAdapter.this.committedText != null) {
                n = 0;
                while (n < IIIMPAdapter.this.committedText.length()) {
                    ComposedChar composedChar = new ComposedChar();
                    composedChar.c = IIIMPAdapter.this.committedText.charAt(n);
                    composedChar.attr = null;
                    IIIMPAdapter.this.composedText.insertElementAt(composedChar, n);
                    ++n;
                }
                n2 = IIIMPAdapter.this.committedText.length();
                IIIMPAdapter.this.committedText = null;
            }
            AttributedString attributedString = IIIMPAdapter.this.getAttributedString();
            IIIMPAdapter.this.postInputMethodEvent(1100, attributedString.getIterator(), n2, TextHitInfo.leading(n3), null);
        }

        public int preeditCaret(PreeditEvent preeditEvent) {
            InputMethodCaret inputMethodCaret = preeditEvent.getCaret();
            return this.dispatchCaretPosition(inputMethodCaret.getPosition());
        }

        public void preeditDone(PreeditEvent preeditEvent) {
            this.caretPos = 0;
            IIIMPAdapter.this.composedText.setSize(0);
        }

        public void preeditDraw(PreeditEvent preeditEvent) {
            this.dispatchComposedText(preeditEvent);
        }

        public int preeditStart(PreeditEvent preeditEvent) {
            this.caretPos = 0;
            IIIMPAdapter.this.composedText.setSize(0);
            return 1024;
        }
    }
}

