/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.EOFException;
import java.io.IOException;

class Data {
    int pos;
    int count;
    byte[] buf;
    private static final int DATA_BOUNDARY = 4;

    Data() {
        this.buf = new byte[32];
        this.count = 0;
        this.pos = 0;
    }

    Data(Data data) {
        int n = data.count - data.pos;
        if (n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(data.buf, data.pos, byArray, 0, n);
            this.buf = byArray;
        }
        this.count = n;
        this.pos = 0;
    }

    Data(byte[] byArray, int n) {
        this.pos = 0;
        this.count = n;
        if (n > 0) {
            this.buf = new byte[n];
            System.arraycopy(byArray, 0, this.buf, 0, n);
        }
    }

    int available() {
        return this.count > this.pos ? this.count - this.pos : 0;
    }

    void ensureCapacity(int n) {
        int n2 = this.buf.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    void pad() throws IOException {
        int n = Data.paddings(this.count);
        int n2 = this.count + n;
        int n3 = this.count;
        while (n3 < n2) {
            this.write(0);
            ++n3;
        }
    }

    static final int paddings(int n) {
        return (4 - n % 4) % 4;
    }

    int read() throws IOException {
        int n;
        if (this.pos >= this.count) {
            throw new EOFException();
        }
        if ((n = this.buf[this.pos++] & 0xFF) < 0) {
            throw new EOFException();
        }
        return n;
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        try {
            while (n4 < n2) {
                n3 = this.read();
                if (n3 != -1) {
                    if (byArray != null) {
                        byArray[n + n4] = (byte)n3;
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return n4;
    }

    int read2() throws IOException {
        int n = this.read();
        int n2 = this.read();
        return (n << 8) + n2;
    }

    int read4() throws IOException {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    String readString() throws IOException {
        int n;
        int n2;
        int n3 = this.read2();
        if (n3 == 0) {
            this.read2();
            return null;
        }
        int n4 = n3 / 2;
        char[] cArray = new char[n4];
        int n5 = 0;
        while (n5 < n4) {
            n2 = this.read();
            n = this.read();
            cArray[n5++] = (char)((n2 << 8) + n);
        }
        n2 = Data.paddings(n3 + 2);
        n = 0;
        while (n < n2) {
            this.read();
            ++n;
        }
        return new String(cArray, 0, n4);
    }

    void skipBytes(int n) {
        int n2 = this.count < this.pos + n ? this.count - this.pos : n;
        this.pos += n2;
    }

    void write(int n) throws IOException {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)(n & 0xFF);
    }

    void write2(int n) throws IOException {
        this.ensureCapacity(this.count + 2);
        this.buf[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.count++] = (byte)(n & 0xFF);
    }

    void write4(int n) throws IOException {
        this.ensureCapacity(this.count + 4);
        this.buf[this.count++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.count++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.count++] = (byte)(n & 0xFF);
    }

    void writeBytes(byte[] byArray) throws IOException {
        this.ensureCapacity(this.count + byArray.length);
        System.arraycopy(byArray, 0, this.buf, this.count, byArray.length);
        this.count += byArray.length;
    }

    void writeBytes(byte[] byArray, int n) throws IOException {
        this.ensureCapacity(this.count + n);
        System.arraycopy(byArray, 0, this.buf, this.count, n);
        this.count += n;
    }

    void writeString(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = n2 * 2;
        this.write2(n3);
        int n4 = Data.paddings(n3 + 2);
        this.ensureCapacity(this.count + n3 + n4);
        int n5 = 0;
        while (n5 < n2) {
            n = string.charAt(n5);
            this.buf[this.count++] = (byte)(n >> 8 & 0xFF);
            this.buf[this.count++] = (byte)(n & 0xFF);
            ++n5;
        }
        n = 0;
        while (n < n4) {
            this.buf[this.count++] = 0;
            ++n;
        }
    }
}

