/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificatePolicyMap;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class PolicyMappingsExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.PolicyMappings";
    public static final String NAME = "PolicyMappings";
    public static final String MAP = "map";
    private Vector maps = null;

    public PolicyMappingsExtension() {
        this.extensionId = PKIXExtensions.KeyUsage_Id;
        this.critical = false;
        this.maps = new Vector(1, 1);
    }

    public PolicyMappingsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = Array.getByte(object, n2);
            ++n2;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for PolicyMappingsExtension.");
        }
        this.maps = new Vector(1, 1);
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            CertificatePolicyMap certificatePolicyMap = new CertificatePolicyMap(derValue2);
            this.maps.addElement(certificatePolicyMap);
        }
    }

    public PolicyMappingsExtension(Vector vector) throws IOException {
        this.maps = vector;
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = false;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(MAP)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = null;
        this.encodeThis();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyMappings_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    private void encodeThis() throws IOException {
        if (this.maps == null || this.maps.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.maps.size()) {
            ((CertificatePolicyMap)this.maps.elementAt(n)).encode(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(MAP)) {
            return this.maps;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(MAP);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(MAP)) {
            if (!(object instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = (Vector)object;
        this.encodeThis();
    }

    public String toString() {
        if (this.maps == null) {
            return "";
        }
        String string = String.valueOf(super.toString()) + "PolicyMappings [\n" + this.maps.toString() + "]\n";
        return string;
    }
}

