/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.security.util.ObjectIdentifier;

public class OIDMap {
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReasonCode";
    private static final String NETSCAPE_CERT = "x509.info.extensions.NetscapeCertType";
    private static final Hashtable oid2Name = new Hashtable(15);
    private static final Hashtable name2OID = new Hashtable(15);
    private static final Hashtable name2Class = new Hashtable(15);

    static {
        OIDMap.loadNames();
        OIDMap.loadClasses();
    }

    public static void addAttribute(String string, String string2, String string3) throws CertificateException {
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
        if (oid2Name.get(objectIdentifier) != null) {
            throw new CertificateException("Object identifier already exists");
        }
        if (name2OID.get(string3) != null) {
            throw new CertificateException("Name already exists");
        }
        if (name2Class.get(string) != null) {
            throw new CertificateException("Class already exists");
        }
        oid2Name.put(objectIdentifier, string3);
        name2OID.put(string3, objectIdentifier);
        name2Class.put(string3, string);
    }

    public static Class getClass(String string) throws CertificateException {
        String string2 = (String)name2Class.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            Class clazz = Class.forName(string2);
            return clazz;
        }
        catch (Exception exception) {
            throw new CertificateException("Error instantiating class for " + string + " " + exception.toString());
        }
    }

    public static Class getClass(ObjectIdentifier objectIdentifier) throws CertificateException {
        String string = OIDMap.getName(objectIdentifier);
        if (string == null) {
            return null;
        }
        String string2 = (String)name2Class.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            Class clazz = Class.forName(string2);
            return clazz;
        }
        catch (Exception exception) {
            throw new CertificateException("Error instantiating class for " + string + " " + exception.toString());
        }
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        return (String)oid2Name.get(objectIdentifier);
    }

    public static ObjectIdentifier getOID(String string) {
        return (ObjectIdentifier)name2OID.get(string);
    }

    private static void loadClassDefault(Properties properties) {
        properties.put(AUTH_KEY_IDENTIFIER, "sun.security.x509.AuthorityKeyIdentifierExtension");
        properties.put(SUB_KEY_IDENTIFIER, "sun.security.x509.SubjectKeyIdentifierExtension");
        properties.put(KEY_USAGE, "sun.security.x509.KeyUsageExtension");
        properties.put(PRIVATE_KEY_USAGE, "sun.security.x509.PrivateKeyUsageExtension");
        properties.put(POLICY_MAPPINGS, "sun.security.x509.PolicyMappingsExtension");
        properties.put(SUB_ALT_NAME, "sun.security.x509.SubjectAlternativeNameExtension");
        properties.put(ISSUER_ALT_NAME, "sun.security.x509.IssuerAlternativeNameExtension");
        properties.put(BASIC_CONSTRAINTS, "sun.security.x509.BasicConstraintsExtension");
        properties.put(NAME_CONSTRAINTS, "sun.security.x509.NameConstraintsExtension");
        properties.put(POLICY_CONSTRAINTS, "sun.security.x509.PolicyConstraintsExtension");
        properties.put(CRL_NUMBER, "sun.security.x509.CRLNumberExtension");
        properties.put(CRL_REASON, "sun.security.x509.CRLReasonCodeExtension");
        properties.put(NETSCAPE_CERT, "sun.security.x509.NetscapeCertTypeExtension");
    }

    private static void loadClasses() {
        Properties properties = new Properties();
        OIDMap.loadClassDefault(properties);
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            name2Class.put(string, string2);
        }
    }

    private static void loadNames() {
        Properties properties = new Properties();
        OIDMap.loadNamesDefault(properties);
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(string2);
            name2OID.put(string, objectIdentifier);
            oid2Name.put(objectIdentifier, string);
        }
    }

    private static void loadNamesDefault(Properties properties) {
        properties.put(SUB_KEY_IDENTIFIER, "2.5.29.14");
        properties.put(KEY_USAGE, "2.5.29.15");
        properties.put(PRIVATE_KEY_USAGE, "2.5.29.16");
        properties.put(SUB_ALT_NAME, "2.5.29.17");
        properties.put(ISSUER_ALT_NAME, "2.5.29.18");
        properties.put(BASIC_CONSTRAINTS, "2.5.29.19");
        properties.put(CRL_NUMBER, "2.5.29.20");
        properties.put(CRL_REASON, "2.5.29.21");
        properties.put(NAME_CONSTRAINTS, "2.5.29.30");
        properties.put(POLICY_MAPPINGS, "2.5.29.33");
        properties.put(AUTH_KEY_IDENTIFIER, "2.5.29.35");
        properties.put(POLICY_CONSTRAINTS, "2.5.29.36");
        properties.put(NETSCAPE_CERT, "2.16.840.1.113730.1.1");
    }
}

