/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.LogStream;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import sun.rmi.server.RemoteProxy;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;

public class UnicastRef
implements RemoteRef {
    protected LiveRef ref;

    public UnicastRef() {
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        if (RemoteProxy.logLevel >= 10) {
            LogStream.log("transport").println("UnicastRef.done: free connection (reuse =  true)");
        }
        this.free(remoteCall, true);
        try {
            remoteCall.done();
        }
        catch (IOException iOException) {}
    }

    private void free(RemoteCall remoteCall, boolean bl) throws RemoteException {
        Connection connection = ((StreamRemoteCall)remoteCall).getConnection();
        this.ref.getChannel().free(connection, bl);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Remote var1_1, Method var2_2, Object[] var3_3, long var4_4) throws Exception {
        block36: {
            block35: {
                if (RemoteProxy.logLevel >= 10) {
                    LogStream.log("transport").println("UnicastRef.invoke: method: " + var2_2);
                }
                var6_5 = this.ref.getChannel().newConnection();
                var7_6 = true;
                var8_7 = false;
                try {
                    try {
                        block34: {
                            block37: {
                                block33: {
                                    if (RemoteProxy.logLevel >= 20) {
                                        LogStream.log("transport").println("UnicastRef.invoke: opnum = " + var4_4);
                                    }
                                    var12_8 = new StreamRemoteCall(var6_5, this.ref.getObjID(), -1, var4_4);
                                    try {
                                        var13_11 = var12_8.getOutputStream();
                                        this.marshalCustomCallData(var13_11);
                                        var14_14 = var2_2.getParameterTypes();
                                        var15_16 = 0;
                                        while (var15_16 < var14_14.length) {
                                            UnicastRef.marshalValue(var14_14[var15_16], var3_3[var15_16], var13_11);
                                            ++var15_16;
                                        }
                                    }
                                    catch (IOException var13_12) {
                                        if (RemoteProxy.logLevel < 10) throw new MarshalException("error marshalling arguments", var13_12);
                                        var15_17 = var14_15 = LogStream.log("transport");
                                        synchronized (var15_17) {
                                            var14_15.print("UnicastRef.invoke: IOException marshalling arguments: ");
                                            var13_12.printStackTrace(var14_15);
                                            throw new MarshalException("error marshalling arguments", var13_12);
                                        }
                                    }
                                    var12_8.executeCall();
                                    try {
                                        try {
                                            var15_18 = var2_2.getReturnType();
                                            if (var15_18 == Void.TYPE) {
                                                var9_21 = null;
                                                var14_14 = null;
                                                break block33;
                                            }
                                            var16_26 = var12_8.getInputStream();
                                            var17_29 = UnicastRef.unmarshalValue(var15_18, var16_26);
                                            var8_7 = true;
                                            if (RemoteProxy.logLevel >= 10) {
                                                LogStream.log("transport").println("UnicastRef.invoke(new): free connection (reuse = true)");
                                            }
                                            this.ref.getChannel().free(var6_5, true);
                                            var9_22 = var17_29;
                                            break block34;
                                        }
                                        catch (IOException var15_19) {
                                            if (RemoteProxy.logLevel < 10) throw new UnmarshalException("error unmarshalling return", var15_19);
                                            var17_30 = var16_27 = LogStream.log("transport");
                                            synchronized (var17_30) {
                                                var16_27.print("UnicastRef.invoke: IOException unmarshalling return: ");
                                                var15_19.printStackTrace(var16_27);
                                                throw new UnmarshalException("error unmarshalling return", var15_19);
                                            }
                                        }
                                        catch (ClassNotFoundException var15_20) {
                                            if (RemoteProxy.logLevel < 10) throw new UnmarshalException("error unmarshalling return", var15_20);
                                            var17_31 = var16_28 = LogStream.log("transport");
                                            synchronized (var17_31) {
                                                var16_28.print("UnicastRef.invoke: ClassNotFoundException unmarshalling return: ");
                                                var15_20.printStackTrace(var16_28);
                                                throw new UnmarshalException("error unmarshalling return", var15_20);
                                            }
                                        }
                                    }
                                    catch (Throwable var13_13) {
                                        var14_14 = null;
                                        try {
                                            var12_8.done();
                                            throw var13_13;
                                        }
                                        catch (IOException v3) {
                                            var7_6 = false;
                                        }
                                        throw var13_13;
                                    }
                                }
                                ** try [egrp 8[TRYBLOCK] [7 : 451->461)] { 
lbl80:
                                // 1 sources

                                var12_8.done();
                                break block37;
lbl82:
                                // 1 sources

                                catch (IOException v4) {
                                    var7_6 = false;
                                }
                            }
                            var11_23 = null;
                            if (var8_7 != false) return var9_21;
                            if (RemoteProxy.logLevel >= 10) {
                                LogStream.log("transport").println("UnicastRef.invoke(new): free connection (reuse = " + var7_6 + ")");
                            }
                            break block35;
                        }
                        var14_14 = null;
                        try {}
                        catch (IOException v5) {
                            var7_6 = false;
                            break block36;
                        }
                        var12_8.done();
                        break block36;
                    }
                    catch (RemoteException var12_9) {
                        var7_6 = false;
                        throw var12_9;
                    }
                    catch (Error var12_10) {
                        var7_6 = false;
                        throw var12_10;
                    }
                }
                catch (Throwable var10_32) {
                    var11_25 = null;
                    if (var8_7 != false) throw var10_32;
                    if (RemoteProxy.logLevel >= 10) {
                        LogStream.log("transport").println("UnicastRef.invoke(new): free connection (reuse = " + var7_6 + ")");
                    }
                    this.ref.getChannel().free(var6_5, var7_6);
                    throw var10_32;
                }
            }
            this.ref.getChannel().free(var6_5, var7_6);
            return var9_21;
        }
        var11_24 = null;
        if (var8_7 != false) return var9_22;
        if (RemoteProxy.logLevel >= 10) {
            LogStream.log("transport").println("UnicastRef.invoke(new): free connection (reuse = " + var7_6 + ")");
        }
        this.ref.getChannel().free(var6_5, var7_6);
        return var9_22;
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        try {
            if (RemoteProxy.logLevel >= 20) {
                LogStream.log("transport").println("UnicastRef.invoke: execute call");
            }
            remoteCall.executeCall();
        }
        catch (RemoteException remoteException) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream2 = logStream = LogStream.log("transport");
                synchronized (logStream2) {
                    logStream.print("UnicastRef.invoke: exception: ");
                    remoteException.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, false);
            throw remoteException;
        }
        catch (Error error) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream3 = logStream = LogStream.log("transport");
                synchronized (logStream3) {
                    logStream.print("UnicastRef.invoke: error: ");
                    error.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream4 = logStream = LogStream.log("transport");
                synchronized (logStream4) {
                    logStream.print("UnicastRef.invoke: exception: ");
                    runtimeException.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, false);
            throw runtimeException;
        }
        catch (Exception exception) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream5 = logStream = LogStream.log("transport");
                synchronized (logStream5) {
                    logStream.print("UnicastRef.invoke: exception: ");
                    exception.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, true);
            throw exception;
        }
    }

    protected void marshalCustomCallData(ObjectOutput objectOutput) throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalValue(Class clazz, Object object, ObjectOutput objectOutput) throws IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                objectOutput.writeInt((Integer)object);
                return;
            } else if (clazz == Boolean.TYPE) {
                objectOutput.writeBoolean((Boolean)object);
                return;
            } else if (clazz == Byte.TYPE) {
                objectOutput.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                objectOutput.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Short.TYPE) {
                objectOutput.writeShort(((Short)object).shortValue());
                return;
            } else if (clazz == Long.TYPE) {
                objectOutput.writeLong((Long)object);
                return;
            } else if (clazz == Float.TYPE) {
                objectOutput.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (clazz != Double.TYPE) throw new Error("Unrecognized primitive type: " + clazz);
                objectOutput.writeDouble((Double)object);
            }
            return;
        } else {
            objectOutput.writeObject(object);
        }
    }

    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n, long l) throws RemoteException {
        if (RemoteProxy.logLevel >= 10) {
            LogStream.log("transport").println("UnicastRef.newCall: get connection");
        }
        Connection connection = this.ref.getChannel().newConnection();
        try {
            if (RemoteProxy.logLevel >= 20) {
                LogStream.log("transport").println("UnicastRef.newCall: create call context");
            }
            StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection, this.ref.getObjID(), n, l);
            try {
                this.marshalCustomCallData(streamRemoteCall.getOutputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshaling custom call data");
            }
            return streamRemoteCall;
        }
        catch (RemoteException remoteException) {
            this.ref.getChannel().free(connection, false);
            throw remoteException;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = LiveRef.read(objectInput, false);
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)remoteRef).ref);
        }
        return false;
    }

    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    protected static Object unmarshalValue(Class clazz, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return new Integer(objectInput.readInt());
            }
            if (clazz == Boolean.TYPE) {
                return new Boolean(objectInput.readBoolean());
            }
            if (clazz == Byte.TYPE) {
                return new Byte(objectInput.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(objectInput.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(objectInput.readShort());
            }
            if (clazz == Long.TYPE) {
                return new Long(objectInput.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(objectInput.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(objectInput.readDouble());
            }
            throw new Error("Unrecognized primitive type: " + clazz);
        }
        return objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.ref.write(objectOutput, false);
    }
}

