/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.security.AccessController;
import sun.rmi.server.LoaderHandler;
import sun.security.action.GetBooleanAction;

public class MarshalInputStream
extends ObjectInputStream {
    private boolean skipDefaultResolveClass = false;
    private static final boolean useCodebaseOnly = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.codebase"));

    public MarshalInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
    }

    protected Object readLocation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Object object = this.readLocation();
        if (!this.skipDefaultResolveClass) {
            try {
                return super.resolveClass(objectStreamClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        String string = objectStreamClass.getName();
        try {
            if (!useCodebaseOnly && object != null && object instanceof String) {
                String string2 = (String)object;
                return LoaderHandler.loadClass(string2, string);
            }
            return LoaderHandler.loadClass(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Malformed URL: " + object);
        }
    }

    void skipDefaultResolveClass() {
        this.skipDefaultResolveClass = true;
    }
}

