/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Hashtable;

public class ActivationGroupImpl
extends ActivationGroup {
    private Hashtable active = new Hashtable(101);
    private boolean groupInactive = false;
    private ActivationGroupID groupID;
    private ArrayList lockedIDs = new ArrayList();
    private static Class[] objConstrParams = new Class[]{class$java$rmi$activation$ActivationID != null ? class$java$rmi$activation$ActivationID : (class$java$rmi$activation$ActivationID = ActivationGroupImpl.class$("java.rmi.activation.ActivationID")), class$java$rmi$MarshalledObject != null ? class$java$rmi$MarshalledObject : (class$java$rmi$MarshalledObject = ActivationGroupImpl.class$("java.rmi.MarshalledObject"))};
    static /* synthetic */ Class class$java$rmi$activation$ActivationID;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;

    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationGroupID);
        this.groupID = activationGroupID;
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception exception) {
                throw new RemoteException("unable to set security manager", exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acquireLock(ActivationID activationID) {
        while (true) {
            block18: {
                ActivationID activationID2;
                Serializable serializable = this;
                synchronized (serializable) {
                    int n = this.lockedIDs.indexOf(activationID);
                    if (n <= 0) {
                        this.lockedIDs.add(activationID);
                        return;
                    }
                    activationID2 = (ActivationID)this.lockedIDs.get(n);
                }
                serializable = activationID2;
                synchronized (serializable) {
                    block17: {
                        block19: {
                            ActivationGroupImpl activationGroupImpl = this;
                            synchronized (activationGroupImpl) {
                                Object var6_7;
                                block16: {
                                    block15: {
                                        int n = this.lockedIDs.indexOf(activationID2);
                                        if (n < 0) {
                                            var6_7 = null;
                                            break block15;
                                        }
                                        ActivationID activationID3 = (ActivationID)this.lockedIDs.get(n);
                                        if (activationID3 != activationID2) {
                                            break block16;
                                        }
                                        break block17;
                                    }
                                    break block19;
                                }
                                var6_7 = null;
                            }
                        }
                        Object var4_4 = null;
                        break block18;
                    }
                    try {
                        activationID2.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
            }
        }
    }

    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
        block6: {
            try {
                this.acquireLock(activationID);
                Object object = this;
                synchronized (object) {
                    if (this.groupInactive) {
                        throw new ActivationException("group is inactive");
                    }
                }
                if (this.active.contains(activationID)) break block6;
                object = new ActiveEntry(remote);
                this.active.put(activationID, object);
                super.activeObject(activationID, ((ActiveEntry)object).mobj);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.releaseLock(activationID);
                this.checkInactiveGroup();
                throw throwable;
            }
        }
        Object var4_4 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
    }

    private void checkInactiveGroup() {
        block8: {
            boolean bl = false;
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                    this.groupInactive = true;
                    bl = true;
                }
            }
            if (!bl) break block8;
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {}
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            Object object = this;
            synchronized (object) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            object = (ActiveEntry)this.active.get(activationID);
            if (object == null) {
                throw new UnknownObjectException("object not active");
            }
            try {
                if (!Activatable.unexportObject(((ActiveEntry)object).impl, false)) {
                    boolean bl = false;
                    Object var4_4 = null;
                    this.releaseLock(activationID);
                    this.checkInactiveGroup();
                    return bl;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {}
            try {
                super.inactiveObject(activationID);
            }
            catch (UnknownObjectException unknownObjectException) {}
            this.active.remove(activationID);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var4_5 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshalledObject newInstance(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException {
        MarshalledObject marshalledObject;
        if (!this.groupID.equals(activationDesc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            try {
                this.acquireLock(activationID);
                Object object = this;
                synchronized (object) {
                    if (this.groupInactive) {
                        throw new ActivationException("group is inactive");
                    }
                }
                object = (ActiveEntry)this.active.get(activationID);
                if (object != null) {
                    MarshalledObject marshalledObject2 = ((ActiveEntry)object).mobj;
                    Object var5_10 = null;
                    this.releaseLock(activationID);
                    this.checkInactiveGroup();
                    return marshalledObject2;
                }
                String string = activationDesc.getClassName();
                Class clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
                Constructor constructor = clazz.getConstructor(objConstrParams);
                Object[] objectArray = new Object[]{activationID, activationDesc.getData()};
                Remote remote = (Remote)constructor.newInstance(objectArray);
                object = new ActiveEntry(remote);
                this.active.put(activationID, object);
                marshalledObject = ((ActiveEntry)object).mobj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodError);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ActivationException("exception in object constructor", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new ActivationException("unable to activate object", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var5_11 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return marshalledObject;
    }

    private void releaseLock(ActivationID activationID) {
        Serializable serializable = this;
        synchronized (serializable) {
            this.lockedIDs.remove(activationID);
        }
        serializable = activationID;
        synchronized (serializable) {
            activationID.notifyAll();
        }
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                this.mobj = new MarshalledObject(remote);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", iOException);
            }
        }
    }
}

