/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.SimpleRenderPipe;

public class ShapeToPolyConverter
implements ShapeDrawPipe {
    SimpleRenderPipe outpipe;
    ShapeDrawPipe fillpipe;
    boolean doTx;

    public ShapeToPolyConverter(SimpleRenderPipe simpleRenderPipe, ShapeDrawPipe shapeDrawPipe, boolean bl) {
        this.outpipe = simpleRenderPipe;
        this.fillpipe = shapeDrawPipe;
        this.doTx = bl;
    }

    public ShapeToPolyConverter(SimpleRenderPipe simpleRenderPipe, boolean bl) {
        this.outpipe = simpleRenderPipe;
        this.doTx = bl;
    }

    private void doDraw(SunGraphics2D sunGraphics2D, Shape shape, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(this.doTx ? sunGraphics2D.transform : null, 1.0);
        boolean bl2 = pathIterator.getWindingRule() == 0;
        Polygon polygon = new Polygon();
        float[] fArray = new float[6];
        int[] nArray = new int[10];
        int n = 0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    nArray = this.sendPoly(sunGraphics2D, polygon, bl, bl2, nArray, false);
                    n = polygon.npoints;
                }
                case 1: {
                    polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                    break;
                }
                case 4: {
                    if (polygon.npoints <= 0) break;
                    polygon.addPoint(polygon.xpoints[n], polygon.ypoints[n]);
                    break;
                }
            }
            pathIterator.next();
        }
        nArray = this.sendPoly(sunGraphics2D, polygon, bl, bl2, nArray, true);
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        this.doDraw(sunGraphics2D, shape, false);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        if (this.fillpipe != null) {
            this.fillpipe.fill(sunGraphics2D, shape);
        } else {
            this.doDraw(sunGraphics2D, shape, true);
        }
    }

    private int[] sendPoly(SunGraphics2D sunGraphics2D, Polygon polygon, boolean bl, boolean bl2, int[] nArray, boolean bl3) {
        int n = nArray[0];
        int n2 = n == 0 ? 0 : nArray[n];
        int n3 = polygon.npoints - n2;
        if (n3 < 2) {
            polygon.npoints = n2;
        } else {
            if (++n >= nArray.length) {
                int[] nArray2 = new int[nArray.length + 10];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[n] = polygon.npoints;
            nArray[0] = n;
        }
        if (bl3) {
            n2 = 0;
            int n4 = 1;
            while (n4 <= n) {
                n3 = nArray[n4];
                nArray[n4 - 1] = n3 - n2;
                n2 = n3;
                ++n4;
            }
            if (bl) {
                this.outpipe.fillPolys(sunGraphics2D, polygon.xpoints, polygon.ypoints, nArray, n, bl2);
            } else {
                this.outpipe.drawPolys(sunGraphics2D, polygon.xpoints, polygon.ypoints, nArray, n, false);
            }
        }
        return nArray;
    }
}

