/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.RasterLockingException;

public final class LockableRaster {
    private Raster parentRaster;
    private SunGraphics2D parent2D;
    private BufferedImage parentImage;
    private int parentType;
    private static final int PARENT_RASTER = 1;
    private static final int PARENT_2D = 2;
    private static final int PARENT_IMAGE = 3;
    private static final int metaFormat = 2;
    private ColorModel parentCM;
    private ImageData cachedID;
    public ImageData id;
    public int type;
    public String devID;
    static final int DCM_RED_MASK = 0xFF0000;
    static final int DCM_GREEN_MASK = 65280;
    static final int DCM_BLUE_MASK = 255;
    static final int DCM_ALPHA_MASK = -16777216;
    static final int DCM_565_RED_MASK = 63488;
    static final int DCM_565_GRN_MASK = 2016;
    static final int DCM_565_BLU_MASK = 31;
    static final int DCM_555_RED_MASK = 31744;
    static final int DCM_555_GRN_MASK = 992;
    static final int DCM_555_BLU_MASK = 31;
    static final int DCM_BGR_RED_MASK = 255;
    static final int DCM_BGR_GRN_MASK = 65280;
    static final int DCM_BGR_BLU_MASK = 0xFF0000;

    public LockableRaster(int n, int n2) {
        this.parent2D = null;
        this.parentImage = null;
        this.parentType = 1;
        this.id = null;
        this.cachedID = null;
        this.parentCM = ColorModel.getRGBdefault();
        this.type = 2;
        this.devID = null;
        this.parentRaster = this.parentCM.createCompatibleWritableRaster(n, n2);
    }

    public LockableRaster(BufferedImage bufferedImage) {
        this.parentRaster = bufferedImage.getRaster();
        this.parent2D = null;
        this.parentImage = bufferedImage;
        this.parentType = 3;
        this.id = null;
        this.cachedID = null;
        this.parentCM = bufferedImage.getColorModel();
        this.type = bufferedImage.getType();
        this.devID = null;
        this.type = this.type == 0 ? LockableRaster.findRasterType(this.parentRaster, this.parentCM) : LockableRaster.adjustCM(this.type, this.parentCM);
    }

    public LockableRaster(Raster raster, ColorModel colorModel) {
        this.parentRaster = raster;
        this.parent2D = null;
        this.parentImage = null;
        this.parentType = 1;
        this.id = null;
        this.cachedID = null;
        this.parentCM = colorModel;
        this.type = LockableRaster.findRasterType(this.parentRaster, this.parentCM);
        this.devID = null;
    }

    public LockableRaster(SunGraphics2D sunGraphics2D) {
        this.parentRaster = null;
        this.parent2D = sunGraphics2D;
        this.parentImage = null;
        this.parentType = 2;
        Rectangle rectangle = sunGraphics2D.getCompBounds();
        this.id = sunGraphics2D.lock(rectangle.x, rectangle.y, 1, 1, 2);
        this.cachedID = null;
        this.parentCM = null;
        this.type = 0;
        this.devID = sunGraphics2D.getDevID();
        if (this.id != null) {
            this.type = this.id.getType();
            sunGraphics2D.unlock(this.id);
            this.id = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int adjustCM(int n, ColorModel colorModel) {
        if (colorModel.getTransparency() == 2) {
            switch (n) {
                case 13: {
                    return -16;
                }
                case 2: {
                    return -14;
                }
                case 3: {
                    return -15;
                }
                default: {
                    return n;
                }
            }
        }
        if (!(colorModel instanceof IndexColorModel)) return n;
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (n != 13) return n;
        if (!ImageData.isAllOpaqueGrayICM(indexColorModel)) return n;
        if (indexColorModel.getPixelSize() != 8) return n;
        return -17;
    }

    public boolean containsTransparentPixels() {
        if (this.parentCM == null) {
            return false;
        }
        return this.parentCM.getTransparency() == 2;
    }

    private static int findRasterType(Raster raster, ColorModel colorModel) {
        int n = 0;
        int n2 = raster.getNumBands();
        if (raster instanceof IntegerComponentRaster && (n2 == 3 || n2 == 4)) {
            IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)raster;
            int n3 = colorModel.getPixelSize();
            if (integerComponentRaster.getPixelStride() == 1 && colorModel instanceof DirectColorModel && (n3 == 32 || n3 == 24) || n3 == 25) {
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                int n4 = directColorModel.getRedMask();
                int n5 = directColorModel.getGreenMask();
                int n6 = directColorModel.getBlueMask();
                if (n4 == 0xFF0000 && n5 == 65280 && n6 == 255) {
                    boolean bl = directColorModel.isAlphaPremultiplied();
                    if (directColorModel.getAlphaMask() == -16777216) {
                        n = bl ? 3 : 2;
                    } else if (n3 == 24) {
                        n = 1;
                    } else if (n3 == 25) {
                        n = -14;
                    }
                } else if (n3 == 24 && n4 == 255 && n5 == 65280 && n6 == 0xFF0000) {
                    n = 4;
                }
            }
        } else if (colorModel instanceof IndexColorModel && n2 == 1) {
            ShortComponentRaster shortComponentRaster;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n7 = indexColorModel.getPixelSize();
            if (raster instanceof BytePackedRaster) {
                n = 12;
            } else if (raster instanceof ByteComponentRaster) {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
                if (byteComponentRaster.getPixelStride() == 1 && n7 <= 8) {
                    n = 13;
                }
            } else if (raster instanceof ShortComponentRaster && (shortComponentRaster = (ShortComponentRaster)raster).getPixelStride() == 1 && n7 == 12 && ImageData.isAllOpaqueGrayICM(indexColorModel)) {
                n = -18;
            }
        } else if (raster instanceof ShortComponentRaster && colorModel instanceof DirectColorModel && n2 == 3) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            if (directColorModel.getRedMask() == 63488) {
                if (directColorModel.getGreenMask() == 2016 && directColorModel.getBlueMask() == 31) {
                    n = 8;
                }
            } else if (directColorModel.getRedMask() == 31744 && directColorModel.getGreenMask() == 992 && directColorModel.getBlueMask() == 31) {
                n = 9;
            }
        } else if (raster instanceof ShortComponentRaster && colorModel instanceof ComponentColorModel && colorModel.getColorSpace().getType() == 6 && n2 == 1) {
            if (((ShortComponentRaster)raster).getPixelStride() == 1) {
                n = 11;
            }
        } else if (raster instanceof ByteComponentRaster) {
            if (colorModel instanceof ComponentColorModel && raster.getSampleModel() instanceof PixelInterleavedSampleModel && (n2 == 3 || n2 == 4)) {
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
                int[] nArray = byteComponentRaster.getDataOffsets();
                if (componentColorModel.getNumComponents() != n2) {
                    throw new RasterFormatException("Number of components in ColorModeldoes not match # in Raster");
                }
                if (byteComponentRaster.getPixelStride() == n2) {
                    if (nArray[0] == n2 - 1 && nArray[1] == n2 - 2 && nArray[2] == n2 - 3) {
                        if (!componentColorModel.isAlphaPremultiplied()) {
                            if (n2 == 3) {
                                n = 5;
                            } else if (nArray[3] == 0) {
                                n = 6;
                            }
                        } else if (n2 == 4 && nArray[3] == 0) {
                            n = 7;
                        }
                    } else if (n2 == 3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                        n = -12;
                    }
                }
            } else if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().getType() == 6 && n2 == 1 && ((ByteComponentRaster)raster).getPixelStride() == 1) {
                n = 10;
            }
        }
        n = LockableRaster.adjustCM(n, colorModel);
        return n;
    }

    public boolean isTranslucent() {
        if (this.parentCM == null) {
            return false;
        }
        return this.parentCM.getTransparency() == 3;
    }

    public void lock(int n, int n2, int n3, int n4, int n5) throws RasterLockingException {
        switch (this.parentType) {
            case 1: 
            case 3: {
                this.id = this.lockRaster(this.parentRaster, this.parentCM, n2, n3, n4, n5, n);
                break;
            }
            case 2: {
                this.id = this.parent2D.lock(n2, n3, n4, n5, n);
                break;
            }
            default: {
                this.id = null;
            }
        }
        if (this.id == null) {
            throw new RasterLockingException("Surface not available/bad request");
        }
        this.type = this.id.getType();
    }

    private ImageData lockRaster(Raster raster, ColorModel colorModel, int n, int n2, int n3, int n4, int n5) {
        if (colorModel == null || raster == null) {
            return null;
        }
        ImageData imageData = this.cachedID;
        if (imageData == null) {
            imageData = new ImageData();
            if (!LockableRaster.prepareImageData(imageData, raster, colorModel, this.type)) {
                return null;
            }
            this.type = imageData.getType();
        }
        imageData.setViewArea(n, n2, n3, n4);
        imageData.setLockMethod(n5);
        if (LockableRaster.prepareRasterBounds(imageData)) {
            this.cachedID = imageData;
            return imageData;
        }
        return null;
    }

    public static boolean prepareImageData(ImageData imageData, Raster raster, ColorModel colorModel, int n) {
        Object object;
        boolean bl = false;
        SampleModel sampleModel = raster.getSampleModel();
        int n2 = sampleModel.getNumBands();
        byte[] byArray = null;
        int[] nArray = null;
        short[] sArray = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = raster.getWidth();
        int n11 = raster.getHeight();
        if (n == 0) {
            n = LockableRaster.findRasterType(raster, colorModel);
        }
        switch (n) {
            case -15: 
            case -14: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)raster;
                nArray = integerComponentRaster.getDataStorage();
                if (nArray == null) break;
                imageData.setIntDataArray(nArray);
                n3 = integerComponentRaster.getScanlineStride();
                n4 = integerComponentRaster.getPixelStride();
                n5 = 1;
                n6 = 4;
                n7 = integerComponentRaster.getDataOffset(0);
                n8 = n7 % n3 / n4;
                n9 = (n7 - n8) / n3;
                bl = true;
                break;
            }
            case -17: 
            case -16: 
            case -12: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                object = (ByteComponentRaster)raster;
                byArray = ((ByteComponentRaster)object).getDataStorage();
                if (byArray == null) break;
                imageData.setByteDataArray(byArray);
                n3 = ((ByteComponentRaster)object).getScanlineStride();
                n4 = ((ByteComponentRaster)object).getPixelStride();
                n5 = 1;
                n6 = 1;
                n7 = ((ByteComponentRaster)object).getDataOffset(0);
                n8 = n7 % n3 / n4;
                n9 = (n7 - n8) / n3;
                bl = true;
                break;
            }
            case -18: 
            case 8: 
            case 9: 
            case 11: {
                ShortComponentRaster shortComponentRaster = (ShortComponentRaster)raster;
                sArray = shortComponentRaster.getDataStorage();
                if (sArray == null) break;
                imageData.setShortDataArray(sArray);
                n3 = shortComponentRaster.getScanlineStride();
                n4 = shortComponentRaster.getPixelStride();
                n5 = 1;
                n6 = 2;
                n7 = shortComponentRaster.getDataOffset(0);
                n8 = n7 % n3 / n4;
                n9 = (n7 - n8) / n3;
                bl = true;
                break;
            }
            case 12: {
                BytePackedRaster bytePackedRaster = (BytePackedRaster)raster;
                byArray = bytePackedRaster.getDataStorage();
                if (byArray == null) break;
                imageData.setByteDataArray(byArray);
                n3 = bytePackedRaster.getScanlineStride();
                n4 = 1;
                n5 = 8 / bytePackedRaster.getNumberOfBits();
                n6 = 1;
                n7 = bytePackedRaster.getDataBitOffset();
                n8 = n7 % (n3 << 3) / bytePackedRaster.getNumberOfBits();
                n9 = n7 / (n3 << 3);
                bl = true;
                break;
            }
            case 0: {
                n5 = 1;
                bl = true;
                break;
            }
            default: {
                throw new InternalError("Unknown GraphicsPrimitive type");
            }
        }
        if (bl) {
            imageData.setType(n);
            if (colorModel != null && colorModel instanceof IndexColorModel) {
                int n12 = ((IndexColorModel)colorModel).getMapSize();
                object = new int[n12];
                ((IndexColorModel)colorModel).getRGBs((int[])object);
                imageData.setLutData(0);
                imageData.setIntLutDataArray((int[])object);
                imageData.setLutDataLength(n12);
            }
            imageData.setTransparency(colorModel.getTransparency());
            imageData.setDataPointer(0);
            imageData.setPixelStride(n4);
            imageData.setScanlineStride(n3);
            imageData.setNumChannels(n2);
            imageData.setPixelsPerDataUnit(n5);
            imageData.setBytePerChannel(n6);
            imageData.setColorModel(colorModel);
            imageData.setRaster(raster);
            imageData.setXSize(n10);
            imageData.setYSize(n11);
            imageData.setOffsetX(n8);
            imageData.setOffsetY(n9);
        }
        return bl;
    }

    public static boolean prepareRasterBounds(ImageData imageData) {
        return LockableRaster.prepareRasterBounds(imageData, 0, 0, imageData.getXSize(), imageData.getYSize());
    }

    public static boolean prepareRasterBounds(ImageData imageData, int n, int n2, int n3, int n4) {
        int n5 = imageData.getXViewArea();
        int n6 = imageData.getYViewArea();
        int n7 = imageData.getDXViewArea();
        int n8 = imageData.getDYViewArea();
        int n9 = n5 + n7;
        int n10 = n6 + n8;
        if (n5 < n) {
            n5 = n;
        }
        if (n6 < n2) {
            n6 = n2;
        }
        if (n9 > n + n3) {
            n9 = n + n3;
        }
        if (n10 > n2 + n4) {
            n10 = n2 + n4;
        }
        n7 = n9 - n5;
        n8 = n10 - n6;
        n5 += imageData.getOffsetX();
        n6 += imageData.getOffsetY();
        if (n8 > 0 && n7 > 0) {
            imageData.setDeviceArea(n5, n6, n7, n8);
            imageData.setOutputArea(n5, n6, n7, n8);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "LockableRaster[";
        switch (this.parentType) {
            case 1: {
                string = String.valueOf(string) + "Raster[";
                string = String.valueOf(string) + this.parentRaster + "[";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "2D[";
                string = String.valueOf(string) + this.parent2D + "[";
                string = String.valueOf(string) + this.id + "[";
                string = String.valueOf(string) + GraphicsPrimitive.typeStr(this.type);
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Image[";
                string = String.valueOf(string) + this.parentImage + "[";
                break;
            }
        }
        if (this.id != null) {
            string = String.valueOf(string) + this.id;
        }
        return string;
    }

    public void unlock() {
        switch (this.parentType) {
            case 2: {
                this.parent2D.unlock(this.id);
                break;
            }
        }
        this.id = null;
    }
}

