/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.GraphicsPrimitives;

public class GraphicsPrimitiveMgr {
    private static final boolean debugTrace = false;
    private static GraphicsPrimitive[][] deviceFunctions;
    private static GraphicsPrimitive[] collection;
    private static String[] deviceAtoms;
    private static GraphicsPrimitiveMgr mgr;

    static {
        mgr = new GraphicsPrimitiveMgr();
    }

    private GraphicsPrimitiveMgr() {
        deviceFunctions = new GraphicsPrimitive[1][];
    }

    private static int devAtomIndex(String string) {
        if (deviceAtoms == null) {
            deviceAtoms = new String[1];
            GraphicsPrimitiveMgr.deviceAtoms[0] = string;
            return 1;
        }
        if (deviceAtoms.length == 1 && deviceAtoms[0].equals(string)) {
            return 1;
        }
        int n = deviceAtoms.length;
        int n2 = 0;
        while (n2 < n) {
            if (deviceAtoms[n2].equals(string)) {
                return n2 + 1;
            }
            ++n2;
        }
        String[] stringArray = new String[n + 1];
        System.arraycopy(deviceAtoms, 0, stringArray, 0, n);
        stringArray[n] = string;
        deviceAtoms = stringArray;
        return n + 1;
    }

    private static final GraphicsPrimitive locate(String string, int[] nArray, int n) {
        GraphicsPrimitive[] graphicsPrimitiveArray = deviceFunctions[n];
        if (graphicsPrimitiveArray == null) {
            return null;
        }
        int n2 = graphicsPrimitiveArray.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[n3];
            if (graphicsPrimitive.satisfies(string, nArray)) {
                if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                    graphicsPrimitiveArray[n3] = graphicsPrimitive = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
                }
                GraphicsPrimitiveMgr.promoteMatchingEntry(n3, n);
                return graphicsPrimitive;
            }
            --n3;
        }
        GraphicsPrimitiveMgr.writeLog("Lookup found nothing for:");
        GraphicsPrimitiveMgr.writeLog(" " + string);
        n3 = 0;
        while (n3 < nArray.length) {
            GraphicsPrimitiveMgr.writeLog(" " + GraphicsPrimitive.typeStr(nArray[n3]));
            ++n3;
        }
        return null;
    }

    public static final synchronized GraphicsPrimitive locate(String string, int[] nArray, String string2) {
        int n;
        GraphicsPrimitive graphicsPrimitive = null;
        if (string2 != null && (n = GraphicsPrimitiveMgr.devAtomIndex(string2)) < deviceFunctions.length) {
            graphicsPrimitive = GraphicsPrimitiveMgr.locate(string, nArray, n);
        }
        if (graphicsPrimitive == null) {
            graphicsPrimitive = GraphicsPrimitiveMgr.locate(string, nArray, 0);
        }
        return graphicsPrimitive;
    }

    private static void promoteMatchingEntry(int n, int n2) {
        GraphicsPrimitive[] graphicsPrimitiveArray = deviceFunctions[n2];
        int n3 = graphicsPrimitiveArray.length;
        if (n < n3 - 10) {
            GraphicsPrimitive[] graphicsPrimitiveArray2 = new GraphicsPrimitive[n3];
            System.arraycopy(graphicsPrimitiveArray, 0, graphicsPrimitiveArray2, 0, n);
            System.arraycopy(graphicsPrimitiveArray, n + 1, graphicsPrimitiveArray2, n, n3 - n - 1);
            graphicsPrimitiveArray2[n3 - 1] = graphicsPrimitiveArray[n];
            graphicsPrimitiveArray = graphicsPrimitiveArray2;
            GraphicsPrimitiveMgr.deviceFunctions[n2] = graphicsPrimitiveArray;
        }
    }

    private static final GraphicsPrimitive[] register(GraphicsPrimitives graphicsPrimitives, int n) {
        GraphicsPrimitiveMgr.writeLog("Registering " + graphicsPrimitives);
        GraphicsPrimitive[] graphicsPrimitiveArray = graphicsPrimitives.getPrimitives();
        GraphicsPrimitive[] graphicsPrimitiveArray2 = deviceFunctions[n];
        if (graphicsPrimitiveArray == null) {
            return graphicsPrimitiveArray2;
        }
        int n2 = 0;
        int n3 = graphicsPrimitiveArray.length;
        if (graphicsPrimitiveArray2 != null) {
            n2 = graphicsPrimitiveArray2.length;
        }
        GraphicsPrimitive[] graphicsPrimitiveArray3 = new GraphicsPrimitive[n2 + n3];
        if (graphicsPrimitiveArray2 != null) {
            System.arraycopy(graphicsPrimitiveArray2, 0, graphicsPrimitiveArray3, 0, n2);
        }
        System.arraycopy(graphicsPrimitiveArray, 0, graphicsPrimitiveArray3, n2, n3);
        return graphicsPrimitiveArray3;
    }

    public static final synchronized void register(GraphicsPrimitives graphicsPrimitives, String string) {
        if (string != null) {
            int n = GraphicsPrimitiveMgr.devAtomIndex(string);
            if (n >= deviceFunctions.length) {
                GraphicsPrimitive[][] graphicsPrimitiveArray = new GraphicsPrimitive[n + 1][];
                System.arraycopy(deviceFunctions, 0, graphicsPrimitiveArray, 0, deviceFunctions.length);
                graphicsPrimitiveArray[n] = null;
                deviceFunctions = graphicsPrimitiveArray;
            }
            GraphicsPrimitiveMgr.deviceFunctions[n] = GraphicsPrimitiveMgr.register(graphicsPrimitives, n);
        } else {
            GraphicsPrimitiveMgr.deviceFunctions[0] = GraphicsPrimitiveMgr.register(graphicsPrimitives, 0);
        }
    }

    public static void testPrimitiveInstantiation() {
        int n = 0;
        int n2 = 0;
        while (n2 < deviceFunctions.length) {
            GraphicsPrimitive[] graphicsPrimitiveArray = deviceFunctions[n2];
            int n3 = 0;
            while (n3 < graphicsPrimitiveArray.length) {
                GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[n3];
                if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                    GraphicsPrimitive graphicsPrimitive2 = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
                    ++n;
                } else {
                    System.out.println(String.valueOf(String.valueOf(graphicsPrimitive)) + " has already been resolved.");
                }
                ++n3;
            }
            ++n2;
        }
        System.out.println(String.valueOf(n) + " graphics primitives resolved correctly.");
    }

    private static void writeLog(String string) {
    }
}

