/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Dimension;

class PSPaperSize {
    String paperSizeName;
    Dimension paperSize;
    int tolerance;
    static final PSPaperSize[] standardSizeTable = new PSPaperSize[]{new PSPaperSize("A3", 842, 1191), new PSPaperSize("A4", 595, 842), new PSPaperSize("B4", 729, 1032), new PSPaperSize("ISOB4", 709, 1001), new PSPaperSize("Legal13", 612, 936), new PSPaperSize("Letter", 612, 792), new PSPaperSize("Legal", 612, 1008), new PSPaperSize("Tabloid", 792, 1224), new PSPaperSize("A4Small", 595, 842), new PSPaperSize("LetterSmall", 612, 792), new PSPaperSize("Executive", 36, 540, 720)};

    public PSPaperSize(String string, int n, int n2) {
        this.paperSizeName = string;
        this.tolerance = 0;
        this.paperSize = new Dimension(n, n2);
    }

    public PSPaperSize(String string, int n, int n2, int n3) {
        this.paperSizeName = string;
        this.tolerance = n;
        this.paperSize = new Dimension(n2, n3);
    }

    public static PSPaperSize find(int n, int n2) {
        return PSPaperSize.find(n, n2, 0);
    }

    public static PSPaperSize find(int n, int n2, int n3) {
        int n4 = n3 + 1;
        int n5 = n3 + 1;
        PSPaperSize pSPaperSize = null;
        int n6 = 0;
        while (n6 < standardSizeTable.length) {
            PSPaperSize pSPaperSize2 = standardSizeTable[n6];
            int n7 = Math.abs(pSPaperSize2.paperSize.width - n);
            int n8 = Math.abs(pSPaperSize2.paperSize.height - n2);
            if (n7 <= pSPaperSize2.tolerance && n8 <= pSPaperSize2.tolerance) {
                return pSPaperSize2;
            }
            if (n7 <= n3 && n8 <= n3 && n7 + n8 < n4 + n5) {
                n4 = n7;
                n5 = n8;
                pSPaperSize = pSPaperSize2;
            }
            ++n6;
        }
        return pSPaperSize;
    }

    public static PSPaperSize find(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < standardSizeTable.length) {
            if (string.equalsIgnoreCase(PSPaperSize.standardSizeTable[n].paperSizeName)) {
                return standardSizeTable[n];
            }
            ++n;
        }
        return null;
    }

    public int height() {
        return this.paperSize.height;
    }

    public String name() {
        return this.paperSizeName;
    }

    public Dimension size() {
        return this.paperSize;
    }

    public String toPostScriptCode() {
        return this.toPostScriptCode(1, false);
    }

    public String toPostScriptCode(int n, boolean bl) {
        if (n == 2) {
            return "mark {\n%%BeginFeature: ManualFeed " + bl + "\n" + "<</ManualFeed " + bl + ">> setpagedevice\n" + "%%EndFeature\n" + "%%BeginFeature: PageSize *" + this.paperSizeName + "\n" + "<< /PageSize [" + this.width() + " " + this.height() + "]\n" + "   /ImagingBBox null\n" + "   /Policies <</PageSize 3>>\n" + " >> setpagedevice\n" + "%%EndFeature\n" + "} stopped cleartomark";
        }
        String string = this.paperSizeName.toLowerCase();
        if (!bl) {
            string = String.valueOf(string) + "tray";
        }
        return "mark {\n%%BeginFeature: ManualFeed " + bl + "\n" + "1 dict dup /ManualFeed " + bl + " put setpagedevice\n" + "%%EndFeature\n" + "} stopped {\n" + "%%BeginFeature: *ManualFeed " + bl + "\n" + "  statusdict /manualfeed " + bl + " put\n" + "%%EndFeature\n" + "} if cleartomark mark {\n" + "%%BeginFeature: PageSize *" + this.paperSizeName + "\n" + "3 dict begin\n" + "   /PageSize [" + this.width() + " " + this.height() + "] def\n" + "   /ImagingBBox null def\n" + "   /Policies 1 dict dup/PageSize 3 put def\n" + " currentdict end setpagedevice\n" + "%%EndFeature\n" + "} stopped {\n" + "  cleartomark statusdict begin mark {\n" + "%%BeginFeature: *PageSize " + this.paperSizeName + "\n" + "  " + string + "\n" + "%%EndFeature\n" + "  } stopped end\n" + "} if cleartomark\n" + "% now make sure we got what we requested!\n" + "gsave initgraphics clippath pathbbox grestore\n" + "5 dict begin\n" + "  3 -1 roll /yoff exch def 3 -1 roll /xoff exch def\n" + "  yoff sub /h exch def xoff sub /w exch def\n" + "  w " + (this.paperSize.width - 36) + " lt h " + (this.paperSize.height - 36) + " lt or {\n" + "    w 2 div xoff add h 2 div yoff add translate\n" + "    w xoff 2 mul add " + this.paperSize.width + " div\n" + "    h yoff 2 mul add " + this.paperSize.height + " div\n" + "    2 copy gt {exch} if pop dup scale\n" + "    " + -this.paperSize.width / 2 + " " + -this.paperSize.height / 2 + " translate\n" + "  } if\n" + "end\n";
    }

    public String toString() {
        return "PSPaperSize[" + this.paperSizeName + ": " + this.paperSize.width + "x" + this.paperSize.height + "]";
    }

    public int width() {
        return this.paperSize.width;
    }
}

