/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.text.AttributedCharacterIterator;
import sun.awt.motif.PSPrintStream;

public class PSGraphics
extends Graphics
implements PrintGraphics {
    public static Dimension Letter = new Dimension(612, 792);
    public static Dimension Legal = new Dimension(612, 1008);
    public static Dimension Executive = new Dimension(540, 720);
    public static Dimension A4 = new Dimension(595, 841);
    PSPrintStream stream;
    int pageNumber;
    Color foreground;
    Font font;
    Rectangle clipRect;
    int originX;
    int originY;
    int adjustX;
    int adjustY;
    FontMetrics curMetrics;
    private boolean disposed = false;

    public PSGraphics(PSGraphics pSGraphics) {
        this.stream = pSGraphics.stream;
        this.pageNumber = pSGraphics.pageNumber;
        this.foreground = pSGraphics.foreground;
        this.font = pSGraphics.font;
        this.clipRect = pSGraphics.clipRect;
        this.originX = pSGraphics.originX;
        this.originY = pSGraphics.originY;
        this.adjustX = pSGraphics.adjustX;
        this.adjustY = pSGraphics.adjustY;
        this.curMetrics = pSGraphics.curMetrics;
    }

    public PSGraphics(PSPrintStream pSPrintStream, int n) {
        this.stream = pSPrintStream;
        this.pageNumber = n;
        this.newAdjust();
    }

    private synchronized boolean blitImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, boolean bl) {
        if (!bl) {
            int n9;
            if (n7 < n5) {
                n9 = n;
                n = n3;
                n3 = n9;
                n9 = n5;
                n5 = n7;
                n7 = n9;
            }
            if (n8 < n6) {
                n9 = n2;
                n2 = n4;
                n4 = n9;
                n9 = n6;
                n6 = n8;
                n8 = n9;
            }
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, n5, n6, n7 - n5, n8 - n6, false);
        try {
            boolean bl2 = false;
            while (!bl2) {
                bl2 = pixelGrabber.grabPixels(5000L);
                if ((pixelGrabber.getStatus() & 0xC0) != 0) {
                    if (color != null) {
                        this.stream.fillRect(this, n, n2, n3 - n, n4 - n2, color);
                    }
                    System.out.println("Image status: " + pixelGrabber.getStatus());
                    return false;
                }
                if (bl2) continue;
                image.getSource().startProduction(pixelGrabber);
            }
        }
        catch (InterruptedException interruptedException) {
            if (color != null) {
                this.stream.fillRect(this, n, n2, n3 - n, n4 - n2, color);
            }
            return false;
        }
        Object object = pixelGrabber.getPixels();
        ColorModel colorModel = pixelGrabber.getColorModel();
        if (bl) {
            n7 = n5 + pixelGrabber.getWidth();
            n8 = n6 + pixelGrabber.getHeight();
            if (n3 <= n) {
                n3 = n + pixelGrabber.getWidth();
            }
            if (n4 <= n2) {
                n4 = n2 + pixelGrabber.getHeight();
            }
        }
        if (object instanceof byte[]) {
            this.stream.sendPixels(this, (byte[])object, (IndexColorModel)colorModel, n, n2, n3, n4, n5, n6, n7, n8, color);
        } else {
            this.stream.sendPixels(this, (int[])object, colorModel, n, n2, n3, n4, n5, n6, n7, n8, color);
        }
        return true;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.stream.fillRect(this, n, n2, n3, n4, this.stream.paperColor);
    }

    public synchronized void clipRect(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            n3 = 0;
        }
        if (n4 <= 0) {
            n4 = 0;
        }
        Rectangle rectangle = new Rectangle(n + this.originX, n2 + this.originY, n3, n4);
        if (this.clipRect != null) {
            rectangle = rectangle.intersection(this.clipRect);
        }
        this.clipRect = rectangle;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        new Exception().printStackTrace();
    }

    public Graphics create() {
        return new PSGraphics(this);
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            PSGraphics pSGraphics = this;
            synchronized (pSGraphics) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.stream.sendArc(this, n + n3 / 2, n2 + n4 / 2, n3 / 2, n4 / 2, n5, n5 + n6, false);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, 0, n, n2), n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            this.stream.fillRect(this, n, n2, n3 - n, n4 - n2, color);
            return true;
        }
        return this.blitImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, false);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            return true;
        }
        return this.blitImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, false);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        return this.blitImage(image, n, n2, n + n3, n2 + n4, 0, 0, -1, -1, color, true);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        return this.blitImage(image, n, n2, n + n3, n2 + n4, 0, 0, -1, -1, null, true);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.blitImage(image, n, n2, n, n2, 0, 0, -1, -1, color, true);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.blitImage(image, n, n2, n, n2, 0, 0, -1, -1, null, true);
    }

    public synchronized void drawLine(int n, int n2, int n3, int n4) {
        this.stream.sendLine(this, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawArc(n, n2, n3, n4, 0, 360);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.stream.sendPolygon(this, nArray, nArray2, n, true, false);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.stream.sendPolygon(this, nArray, nArray2, n, false, false);
    }

    public synchronized void drawRect(int n, int n2, int n3, int n4) {
        this.stream.sendRect(this, n, n2, n3, n4, false);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.stream.sendRoundRect(this, n, n2, n3, n4, (float)n5 / 2.0f, (float)n6 / 2.0f, false);
    }

    public synchronized void drawString(String string, int n, int n2) {
        this.stream.sendString(this, string, n, n2);
    }

    public synchronized void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        int n3;
        int n4 = attributedCharacterIterator.getBeginIndex();
        if (n4 >= (n3 = attributedCharacterIterator.getEndIndex())) {
            return;
        }
        Font font = this.font;
        StringBuffer stringBuffer = new StringBuffer();
        char c = attributedCharacterIterator.first();
        while (n4 < n3) {
            Font font2 = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
            int n5 = attributedCharacterIterator.getRunLimit(TextAttribute.FONT);
            while (n4 < n5) {
                stringBuffer.append(c);
                c = attributedCharacterIterator.next();
                ++n4;
            }
            this.setFont(font2);
            this.stream.sendString(this, stringBuffer.toString(), n, n2);
            stringBuffer.setLength(0);
        }
        this.setFont(font);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.stream.sendArc(this, n + n3 / 2, n2 + n4 / 2, n3 / 2, n4 / 2, n5, n5 + n6, true);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillArc(n, n2, n3, n4, 0, 360);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.stream.sendPolygon(this, nArray, nArray2, n, false, true);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.stream.sendRect(this, n, n2, n3, n4, true);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.stream.sendRoundRect(this, n, n2, n3, n4, (float)n5 / 2.0f, (float)n6 / 2.0f, true);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return this.clipRect == null ? null : new Rectangle(this.clipRect.x - this.originX, this.clipRect.y - this.originY, this.clipRect.width, this.clipRect.height);
    }

    public Color getColor() {
        return this.foreground;
    }

    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public PrintJob getPrintJob() {
        return this.stream.job;
    }

    private void newAdjust() {
        this.adjustX = this.originX;
        this.adjustY = this.stream.paperDim.height - this.originY;
    }

    public synchronized void setClip(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            n3 = 0;
        }
        if (n4 <= 0) {
            n4 = 0;
        }
        this.clipRect = new Rectangle(n + this.originX, n2 + this.originY, n3, n4);
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.clipRect = null;
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            throw new IllegalArgumentException("setClip(Shape) only supports Rectangle objects");
        }
    }

    public void setColor(Color color) {
        this.foreground = color;
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.curMetrics = null;
        }
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.originX + "," + this.originY + "]";
    }

    public void translate(int n, int n2) {
        this.originX += n;
        this.originY += n2;
        this.newAdjust();
    }
}

