/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextFieldPeer;
import sun.awt.SunToolkit;
import sun.awt.motif.MComponentPeer;

public class MTextFieldPeer
extends MComponentPeer
implements TextFieldPeer {
    public static final int BORDER = 2;
    public static final int MARGIN = 4;

    public MTextFieldPeer(TextField textField) {
        super(textField);
    }

    public void action() {
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                MTextFieldPeer.this.postEvent(new ActionEvent(MTextFieldPeer.this.target, 1001, ((TextField)MTextFieldPeer.this.target).getText()));
            }
        });
    }

    native void create(MComponentPeer var1);

    protected void disposeImpl() {
        this.preDispose();
        super.disposeImpl();
    }

    public native int getCaretPosition();

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.stringWidth(((TextField)this.target).getText()) + 20, fontMetrics.getHeight() + 15);
    }

    public Dimension getMinimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n + 20, fontMetrics.getHeight() + 15);
    }

    public Dimension getPreferredSize(int n) {
        return this.getMinimumSize(n);
    }

    public native int getSelectionEnd();

    public native int getSelectionStart();

    public native String getText();

    void initialize() {
        TextField textField = (TextField)this.target;
        this.setText(textField.getText());
        if (textField.echoCharIsSet()) {
            this.setEchoChar(textField.getEchoChar());
        }
        int n = textField.getSelectionStart();
        int n2 = textField.getSelectionEnd();
        if (n2 > n) {
            this.select(n, n2);
        }
        if (this.isBackgroundInherited()) {
            this.target.setBackground(SystemColor.text);
        }
        if (this.isForegroundInherited()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setEditable(textField.isEditable());
        super.initialize();
    }

    public native void insertReplaceText(String var1);

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int n) {
        return this.getMinimumSize(n);
    }

    void pDispose() {
        this.notifyTextComponentChange(false);
        super.pDispose();
    }

    void pHide() {
        this.notifyTextComponentChange(false);
        super.pHide();
    }

    public native void pSetEditable(boolean var1);

    void pShow() {
        super.pShow();
        this.notifyTextComponentChange(true);
    }

    public void pasteFromClipboard() {
        block2: {
            Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) break block2;
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insertReplaceText(string);
            }
            catch (Exception exception) {}
        }
    }

    int pos2x(int n) {
        TextField textField = (TextField)this.target;
        FontMetrics fontMetrics = this.getFontMetrics(textField.getFont());
        int n2 = 4;
        int[] nArray = fontMetrics.getWidths();
        String string = textField.getText();
        char c = textField.getEchoChar();
        if (c == '\u0000') {
            int n3 = 0;
            while (n3 < n) {
                n2 += nArray[string.charAt(n3)];
                ++n3;
            }
        } else {
            n2 += nArray[c] * n;
        }
        return n2;
    }

    public native void preDispose();

    public Dimension preferredSize(int n) {
        return this.getPreferredSize(n);
    }

    public void print(Graphics graphics) {
        TextField textField = (TextField)this.target;
        Dimension dimension = textField.size();
        int n = dimension.width - 4;
        int n2 = dimension.height - 4;
        Color color = textField.getBackground();
        Color color2 = textField.getForeground();
        Color color3 = color.brighter();
        String string = textField.getText();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        graphics.setFont(textField.getFont());
        graphics.setColor(textField.isEditable() ? color3 : color);
        graphics.fillRect(2, 2, n, n2);
        graphics.setColor(color);
        this.draw3DRect(graphics, color, 1, 1, dimension.width - 3, dimension.height - 3, false);
        if (string != null) {
            graphics.clipRect(2, 4, n, dimension.height - 8);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = dimension.width - 2;
            n2 = dimension.height - 8;
            int n6 = this.pos2x(n4) - n3;
            int n7 = this.pos2x(n5) - n3;
            if (n6 < 4 && n7 > n) {
                graphics.setColor(color3);
                graphics.fillRect(2, 4, n - 2, n2);
            } else {
                graphics.setColor(color);
                if (n6 >= 4 && n6 <= n) {
                    graphics.setColor(color3);
                    if (n7 > n) {
                        graphics.fillRect(n6, 4, n - n6, n2);
                    } else if (n6 != n7) {
                        graphics.fillRect(n6, 4, n7 - n6, n2);
                    }
                } else if (n7 >= 4 && n7 <= n) {
                    graphics.setColor(color3);
                    graphics.fillRect(2, 4, n7 - 2, n2);
                }
            }
            graphics.setColor(color2);
            int n8 = 4 - n3;
            char c = textField.getEchoChar();
            if (c == '\u0000') {
                graphics.drawString(string, n8, 6 + fontMetrics.getMaxAscent());
            } else {
                char[] cArray = new char[string.length()];
                int n9 = 0;
                while (n9 < cArray.length) {
                    cArray[n9] = c;
                    ++n9;
                }
                graphics.drawChars(cArray, 0, cArray.length, n8, 6 + fontMetrics.getMaxAscent());
            }
        }
        this.target.print(graphics);
    }

    public native void select(int var1, int var2);

    public native void setCaretPosition(int var1);

    public native void setEchoChar(char var1);

    public void setEchoCharacter(char c) {
        this.setEchoChar(c);
    }

    public void setEditable(boolean bl) {
        this.pSetEditable(bl);
        this.setBackground(this.target.getBackground());
    }

    public native void setFont(Font var1);

    public native void setText(String var1);

    public void valueChanged() {
        this.postEvent(new TextEvent(this.target, 900));
    }
}

