/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.List;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import sun.awt.SunToolkit;
import sun.awt.motif.MComponentPeer;

class MListPeer
extends MComponentPeer
implements ListPeer {
    static final int MARGIN = 2;
    static final int SPACE = 1;
    static final int SCROLLBAR = 16;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int vval;
    int hval;
    int vmax;
    int hmax;

    MListPeer(List list) {
        super(list);
    }

    public void action(int n) {
        final List list = (List)this.target;
        final int n2 = n;
        SunToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                list.select(n2);
                this.postEvent(new ActionEvent(target, 1001, list.getItem(n2)));
            }
        });
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public native void addItem(String var1, int var2);

    public void clear() {
        List list = (List)this.target;
        this.delItems(0, list.countItems());
    }

    native void create(MComponentPeer var1);

    public native void delItems(int var1, int var2);

    public native void deselect(int var1);

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n = list.countItems();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.isSelected(n3)) {
                nArray[n2++] = n3;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void handleListChanged(int n) {
        final MListPeer mListPeer = this;
        final List list = (List)this.target;
        final int n2 = n;
        SunToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                int[] nArray = mListPeer.getSelectedIndexes();
                boolean bl = false;
                int n = 0;
                while (n < nArray.length) {
                    if (n2 == nArray[n]) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                this.postEvent(new ItemEvent(list, 701, new Integer(n2), bl ? 1 : 2));
            }
        });
    }

    void initialize() {
        List list = (List)this.target;
        int n = list.countItems();
        int n2 = 0;
        while (n2 < n) {
            this.addItem(list.getItem(n2), -1);
            ++n2;
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        int n3 = list.getVisibleIndex();
        if (n3 >= 0) {
            this.makeVisible(n3);
        }
        int[] nArray = list.getSelectedIndexes();
        int n4 = 0;
        while (n4 < nArray.length) {
            this.select(nArray[n4]);
            ++n4;
        }
        if (n == 0) {
            this.addItem(" ", 0);
            this.delItems(0, 1);
        }
        super.pSetScrollbarBackground(MComponentPeer.getParent_NoClientCode(list).getBackground());
        if (this.isBackgroundInherited()) {
            this.target.setBackground(SystemColor.text);
        }
        if (this.isForegroundInherited()) {
            this.target.setForeground(SystemColor.textText);
        }
        super.initialize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public native boolean isSelected(int var1);

    int itemsInWindow(boolean bl) {
        Dimension dimension = this.target.size();
        int n = bl ? dimension.height - 20 : dimension.height - 4;
        int n2 = this.fontHeight - this.fontLeading;
        return n / (n2 + 2);
    }

    public native void makeVisible(int var1);

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(((List)this.target).getFont());
        return new Dimension(20 + fontMetrics.stringWidth("0123456789abcde"), (fontMetrics.getHeight() + 2) * n + 4);
    }

    void paintItem(Graphics graphics, Color color, Color color2, int n, boolean bl) {
        List list = (List)this.target;
        Dimension dimension = list.size();
        int n2 = list.getItemCount();
        Color color3 = color.darker();
        if (n < this.vval || n >= this.vval + this.itemsInWindow(this.hmax != 0)) {
            return;
        }
        int n3 = dimension.width - (4 + (this.vmax != 0 ? 16 : 0));
        int n4 = this.fontHeight - this.fontLeading;
        int n5 = n4 + 2;
        int n6 = 2 + n * n5 + 1;
        int n7 = n6 - this.vval * n5;
        int n8 = 3;
        Graphics graphics2 = graphics.create();
        if (n > n2 - 1) {
            graphics2.setColor(color);
            graphics2.fillRect(n8 - 2, n7 - 2, n3, n4 + 4);
            return;
        }
        if (bl) {
            graphics2.setColor(color3);
            graphics2.fillRect(n8 - 1, n7 - 1, n3 - 2, n4 + 2);
        } else {
            graphics2.setColor(color);
            graphics2.fillRect(n8 - 1, n7 - 1, n3 - 2, n4 + 2);
        }
        graphics2.setColor(color);
        graphics2.drawRect(n8 - 2, n7 - 2, n3 - 1, n4 + 3);
        graphics2.setColor(color2);
        String string = list.getItem(n);
        graphics2.clipRect(n8, n7, n3 - 2, n4);
        graphics2.drawString(string, n8 - this.hval, n7 + this.fontAscent);
        graphics2.dispose();
    }

    void paintItems(Graphics graphics, Color color, Color color2, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.paintItem(graphics, color, color2, n3, false);
            ++n3;
        }
    }

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public void print(Graphics graphics) {
        Object var19_19;
        Graphics graphics2;
        int n;
        int n2;
        int n3;
        List list = (List)this.target;
        Dimension dimension = list.size();
        Color color = list.getBackground();
        Color color2 = list.getForeground();
        int n4 = list.getItemCount();
        FontMetrics fontMetrics = this.getFontMetrics(list.getFont());
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            n3 = fontMetrics.stringWidth(list.getItem(n6));
            n5 = Math.max(n5, n3);
            ++n6;
        }
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
        int n7 = 0;
        int n8 = 0;
        int n9 = this.itemsInWindow(true);
        this.vmax = Math.max(n4 - n9, 0);
        int n10 = dimension.height - 16;
        if (this.vmax != 0) {
            n2 = dimension.width - 16;
            n = n2 - 6;
            this.hmax = Math.max(n5 - n, 0);
        } else {
            n2 = dimension.width;
            n = n2 - 6;
            this.hmax = Math.max(n5 - n, 0);
        }
        if (this.hmax == 0) {
            n10 = dimension.height;
            n9 = this.itemsInWindow(false);
            this.vmax = Math.max(n4 - n9, 0);
        }
        if (this.vmax == 0) {
            n2 = dimension.width;
            n = n2 - 6;
            this.hmax = Math.max(n5 - n, 0);
        }
        this.hval = 0;
        this.vval = 0;
        graphics.setColor(color);
        graphics.fillRect(0, 0, n2, n10);
        if (this.hmax != 0) {
            n3 = dimension.width - (this.vmax == 0 ? 0 : 16);
            graphics2 = graphics.create();
            graphics.fillRect(1, dimension.height - 16 - 3, n3 - 1, 13);
            try {
                graphics2.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics2, color, 14, n3, n8, this.hmax, this.hval, n, true);
            }
            finally {
                var19_19 = null;
                graphics2.dispose();
            }
        }
        if (this.vmax != 0) {
            n3 = dimension.height - (this.hmax == 0 ? 0 : 16);
            graphics2 = graphics.create();
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n3 - 1);
            try {
                graphics2.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics2, color, 14, n3, n7, this.vmax, this.vval, n9, false);
            }
            finally {
                var19_19 = null;
                graphics2.dispose();
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n2 - 1, n10 - 1, false);
        if (n4 > 0) {
            n3 = this.itemsInWindow(this.hmax != 0);
            int n11 = Math.min(n4 - 1, this.vval + n3 - 1);
            this.paintItems(graphics, color, color2, this.vval, n11);
        }
        this.target.print(graphics);
    }

    public void removeAll() {
        this.clear();
    }

    public native void select(int var1);

    public native void setBackground(Color var1);

    public void setForeground(Color color) {
        this.pSetInnerForeground(color);
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public native void setMultipleSelections(boolean var1);
}

