/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;

class MDragSourceContextPeerBuffer
extends ByteArrayOutputStream {
    private int readCursor = 0;
    private Long requestorID;

    MDragSourceContextPeerBuffer(Long l) {
        this.requestorID = l;
    }

    MDragSourceContextPeerBuffer(Long l, InputStream inputStream) throws IOException {
        this(l);
        this.fill(inputStream);
        this.close();
    }

    MDragSourceContextPeerBuffer(Long l, Object object) throws IOException {
        this(l);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        this.close();
    }

    MDragSourceContextPeerBuffer(Long l, String string) throws IOException {
        this(l);
        DataOutputStream dataOutputStream = new DataOutputStream(this);
        dataOutputStream.writeUTF(string);
        dataOutputStream.close();
        this.close();
    }

    MDragSourceContextPeerBuffer(Long l, byte[] byArray) {
        this(l);
        this.count = byArray.length;
        this.buf = new byte[this.count];
        System.arraycopy(byArray, 0, this.buf, 0, this.count);
        try {
            this.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void fill(InputStream inputStream) throws IOException {
        boolean bl = false;
        int n = inputStream.available();
        byte[] byArray = new byte[n > 8192 ? n : 8192];
        do {
            int n2;
            if (bl = (n2 = inputStream.read(byArray, 0, byArray.length)) == -1) continue;
            this.write(byArray, 0, n2);
        } while (!bl);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    byte[] getBuffer() {
        return this.buf;
    }

    Long getRequestorID() {
        return this.requestorID;
    }

    int incrReadCursor(int n) {
        int n2 = this.readCursor + n;
        int n3 = this.size();
        this.readCursor = n2 >= n3 ? n3 : n2;
        return this.readCursor == n3 ? -1 : this.readCursor;
    }
}

