/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import sun.awt.font.Shaping;
import sun.awt.font.TextLabel;
import sun.awt.font.TextSource;

public class TextSourceLabel
extends TextLabel {
    TextSource source;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    String str;
    GlyphVector gv;

    public TextSourceLabel(TextSource textSource) {
        this(textSource, null, null, null);
    }

    public TextSourceLabel(TextSource textSource, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, GlyphVector glyphVector) {
        this.source = textSource;
        this.lb = rectangle2D;
        this.ab = rectangle2D2;
        this.gv = glyphVector;
    }

    protected Rectangle2D createAlignBounds() {
        return this.createLogicalBounds();
    }

    protected GlyphVector createGV() {
        return this.source.getFont().createGlyphVector(this.source.getFRC(), this.getString());
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    protected String createString() {
        return Shaping.getShapedString(this.source);
    }

    protected Rectangle2D createVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.drawGlyphVector(this.getGV(), f, f2);
    }

    public final Rectangle2D getAlignBounds(float f, float f2) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f), (float)(this.ab.getY() + (double)f2), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    private final GlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    public final Rectangle2D getLogicalBounds(float f, float f2) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f), (float)(this.lb.getY() + (double)f2), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    public Shape getOutline(float f, float f2) {
        return this.getGV().getOutline(f, f2);
    }

    public TextSource getSource() {
        return this.source;
    }

    private final String getString() {
        if (this.str == null) {
            this.str = this.createString();
        }
        return this.str;
    }

    public final Rectangle2D getVisualBounds(float f, float f2) {
        if (this.vb == null) {
            this.vb = this.createVisualBounds();
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f), (float)(this.vb.getY() + (double)f2), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }
}

