/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import sun.awt.font.NativeFontWrapper;

public class StandardGlyphVector
extends GlyphVector {
    private Font font;
    private int[] glyphs;
    private float[] positions;
    private FontRenderContext frc;
    private double[] glyphTX;

    public StandardGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, string.toCharArray(), dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        char[] cArray = new char[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
        char c = characterIterator.first();
        while (c != '\uffff') {
            cArray[characterIterator.getIndex() - characterIterator.getBeginIndex()] = c;
            c = characterIterator.next();
        }
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = nArray;
        this.positions = null;
        this.frc = fontRenderContext;
    }

    public boolean equals(GlyphVector glyphVector) {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int n) {
        return this.glyphs[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = this.glyphs[n3 + n];
            ++n3;
        }
        return nArray2;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        this.initPositions();
        Shape shape = this.getGlyphOutline(n);
        return shape.getBounds();
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        GlyphMetrics glyphMetrics = new GlyphMetrics(0.0f, new Rectangle2D.Float(), 0);
        NativeFontWrapper.getGlyphMetrics(this.font, this.glyphs[n], this.getGlyphTX(), this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), glyphMetrics);
        return glyphMetrics;
    }

    public Shape getGlyphOutline(int n) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath = (GeneralPath)NativeFontWrapper.getGlyphOutline(this, this.font, this.getGlyphTX(), this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), n, generalPath);
        return generalPath;
    }

    public Point2D getGlyphPosition(int n) {
        this.initPositions();
        return new Point2D.Float(this.positions[n * 2], this.positions[n * 2 + 1]);
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        this.initPositions();
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        int n3 = 0;
        while (n3 < n2) {
            fArray2[n3 * 2] = this.positions[(n3 + n) * 2];
            fArray2[n3 * 2 + 1] = this.positions[(n3 + n) * 2 + 1];
            ++n3;
        }
        return fArray2;
    }

    private double[] getGlyphTX() {
        if (this.glyphTX != null) {
            return this.glyphTX;
        }
        this.glyphTX = new double[6];
        float f = this.font.getSize2D();
        AffineTransform affineTransform = (AffineTransform)this.frc.getTransform().clone();
        affineTransform.scale(f, f);
        affineTransform.preConcatenate(this.font.getTransform());
        affineTransform.getMatrix(this.glyphTX);
        return this.glyphTX;
    }

    public AffineTransform getGlyphTransform(int n) {
        return new AffineTransform();
    }

    public Shape getGlyphVisualBounds(int n) {
        this.initPositions();
        Shape shape = this.getGlyphOutline(n);
        return shape.getBounds();
    }

    public Rectangle2D getLogicalBounds() {
        Shape shape = this.getOutline();
        return shape.getBounds();
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    public Shape getOutline(float f, float f2) {
        GeneralPath generalPath = new GeneralPath(0);
        double[] dArray = this.getGlyphTX();
        generalPath = (GeneralPath)NativeFontWrapper.getGlyphVectorOutline(this, this.font, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), (float)dArray[4] + f, (float)dArray[5] + f2, generalPath);
        return generalPath;
    }

    public Rectangle2D getVisualBounds() {
        Shape shape = this.getOutline();
        return shape.getBounds();
    }

    private void initPositions() {
        if (this.positions == null) {
            this.performDefaultLayout();
        }
    }

    public void performDefaultLayout() {
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.layoutGlyphVector(this.font, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), (float)dArray[4], (float)dArray[5], this);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.initPositions();
        this.positions[n * 2] = (float)point2D.getX();
        this.positions[n * 2 + 1] = (float)point2D.getY();
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
    }
}

